/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.ram.server;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import mcp.mobius.ram.server.BreadcrumbManager;
import mcp.mobius.ram.server.CoordinateBlock;
import mcp.mobius.ram.server.DataSaveManager;
import mcp.mobius.ram.server.ISaveable;
import mcp.mobius.ram.server.WaypointManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public enum PathManager implements ISaveable
{
    INSTANCE;

    HashBasedTable<WaypointManager.Waypoint, WaypointManager.Waypoint, ArrayList<CoordinateBlock>> pathsBuilding = HashBasedTable.create();
    HashBasedTable<WaypointManager.Waypoint, WaypointManager.Waypoint, ArrayList<CoordinateBlock>> pathsFinal = HashBasedTable.create();
    public DataSaveManager save = new DataSaveManager(this);

    public void addPoint(WaypointManager.Waypoint start, WaypointManager.Waypoint end, CoordinateBlock coord) {
        if (!this.pathsBuilding.contains((Object)start, (Object)end)) {
            this.pathsBuilding.put((Object)start, (Object)end, new ArrayList());
        }
        ((ArrayList)this.pathsBuilding.get((Object)start, (Object)end)).add(coord);
        this.save.writeToFile();
    }

    public ArrayList<CoordinateBlock> getPath(WaypointManager.Waypoint start, WaypointManager.Waypoint end) {
        return (ArrayList)this.pathsFinal.get((Object)start, (Object)end);
    }

    public void makeFinal(WaypointManager.Waypoint start, WaypointManager.Waypoint end) {
        ArrayList path = (ArrayList)this.pathsBuilding.get((Object)start, (Object)end);
        this.pathsFinal.put((Object)start, (Object)end, (Object)path);
        this.pathsBuilding.remove((Object)start, (Object)end);
        BreadcrumbManager.INSTANCE.clearLinkedBreadcrumbs(start, end);
        this.save.writeToFile();
    }

    public void removePath(WaypointManager.Waypoint start, WaypointManager.Waypoint end) {
        this.pathsFinal.remove((Object)start, (Object)end);
        this.save.writeToFile();
    }

    public void removeAllPathsToDestination(WaypointManager.Waypoint end) {
        for (WaypointManager.Waypoint start : this.pathsFinal.rowKeySet()) {
            this.pathsFinal.remove((Object)start, (Object)end);
        }
        this.save.writeToFile();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("paths", (NBTBase)this.writeToNBT_(this.pathsFinal));
        nbt.func_74782_a("pathsBuilding", (NBTBase)this.writeToNBT_(this.pathsBuilding));
    }

    public NBTTagList writeToNBT_(HashBasedTable<WaypointManager.Waypoint, WaypointManager.Waypoint, ArrayList<CoordinateBlock>> paths) {
        NBTTagList tagList = new NBTTagList();
        for (Table.Cell path : paths.cellSet()) {
            NBTTagCompound tagPath = new NBTTagCompound();
            tagPath.func_74782_a("wpStart", (NBTBase)((WaypointManager.Waypoint)path.getRowKey()).toNBT());
            tagPath.func_74782_a("wpEnd", (NBTBase)((WaypointManager.Waypoint)path.getColumnKey()).toNBT());
            NBTTagList tagCoords = new NBTTagList();
            for (CoordinateBlock coord : (ArrayList)path.getValue()) {
                tagCoords.func_74742_a((NBTBase)coord.toNBT());
            }
            tagPath.func_74782_a("coords", (NBTBase)tagCoords);
            tagList.func_74742_a((NBTBase)tagPath);
        }
        return tagList;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.readFromNBT_(this.pathsFinal, nbt.func_150295_c("paths", 10));
        this.readFromNBT_(this.pathsBuilding, nbt.func_150295_c("pathsBuilding", 10));
    }

    public void readFromNBT_(HashBasedTable<WaypointManager.Waypoint, WaypointManager.Waypoint, ArrayList<CoordinateBlock>> paths, NBTTagList tagPaths) {
        paths.clear();
        for (int i = 0; i < tagPaths.func_74745_c(); ++i) {
            NBTTagCompound tagPath = tagPaths.func_150305_b(i);
            WaypointManager waypointManager = WaypointManager.INSTANCE;
            waypointManager.getClass();
            WaypointManager.Waypoint wpStart = new WaypointManager.Waypoint(waypointManager, tagPath.func_74775_l("wpStart"));
            WaypointManager waypointManager2 = WaypointManager.INSTANCE;
            waypointManager2.getClass();
            WaypointManager.Waypoint wpEnd = new WaypointManager.Waypoint(waypointManager2, tagPath.func_74775_l("wpEnd"));
            NBTTagList tagCoords = tagPath.func_150295_c("coords", 10);
            ArrayList<CoordinateBlock> coords = new ArrayList<CoordinateBlock>();
            for (int j = 0; j < tagCoords.func_74745_c(); ++j) {
                coords.add(new CoordinateBlock(tagCoords.func_150305_b(j)));
            }
            paths.put((Object)wpStart, (Object)wpEnd, coords);
        }
    }

    @Override
    public String[] getFilenames() {
        return new String[]{"paths1.dat", "paths2.dat", "paths.lck"};
    }
}

