/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.ram.server;

import java.util.Collection;
import java.util.HashMap;
import mcp.mobius.ram.server.CoordinateBlock;
import mcp.mobius.ram.server.DataSaveManager;
import mcp.mobius.ram.server.ISaveable;
import mcp.mobius.ram.server.PathManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public enum WaypointManager implements ISaveable
{
    INSTANCE;

    public DataSaveManager save = new DataSaveManager(this);
    HashMap<CoordinateBlock, Waypoint> waypoints = new HashMap();
    private int NBTVersion = 1;

    public void addWaypoint(String s, int d, int x, int y, int z) {
        this.addWaypoint(s, new CoordinateBlock(d, x, y, z));
    }

    public void addWaypoint(String s, CoordinateBlock coord) {
        this.waypoints.put(coord, new Waypoint(s, coord));
        this.save.writeToFile();
    }

    public void rmWaypoint(int d, int x, int y, int z) {
        this.rmWaypoint(new CoordinateBlock(d, x, y, z));
    }

    public void rmWaypoint(CoordinateBlock coord) {
        PathManager.INSTANCE.removeAllPathsToDestination(this.waypoints.get(coord));
        this.waypoints.remove(coord);
        this.save.writeToFile();
    }

    public Collection<Waypoint> getWaypoints() {
        return this.waypoints.values();
    }

    public Waypoint getWaypoint(int d, int x, int y, int z) {
        return this.getWaypoint(new CoordinateBlock(d, x, y, z));
    }

    public Waypoint getWaypoint(CoordinateBlock coord) {
        return this.waypoints.get(coord);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("version", this.NBTVersion);
        NBTTagList waypointsNBT = new NBTTagList();
        for (Waypoint waypoint : this.waypoints.values()) {
            waypointsNBT.func_74742_a((NBTBase)waypoint.toNBT());
        }
        nbt.func_74782_a("waypoints", (NBTBase)waypointsNBT);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.waypoints.clear();
        NBTTagList waypointsNBT = nbt.func_150295_c("waypoints", 10);
        for (int i = 0; i < waypointsNBT.func_74745_c(); ++i) {
            Waypoint wp = new Waypoint(waypointsNBT.func_150305_b(i));
            this.waypoints.put(wp.coord, wp);
        }
    }

    @Override
    public String[] getFilenames() {
        return new String[]{"waypoint1.dat", "waypoint2.dat", "waypoint.lck"};
    }

    public final class Waypoint {
        public final CoordinateBlock coord;
        public final String name;

        public Waypoint(String s, int d, int x, int y, int z) {
            this.name = s;
            this.coord = new CoordinateBlock(d, x, y, z);
        }

        public Waypoint(String s, CoordinateBlock coord) {
            this.name = s;
            this.coord = coord;
        }

        public Waypoint(NBTTagCompound tag) {
            this.name = tag.func_74779_i("name");
            this.coord = new CoordinateBlock(tag.func_74775_l("coord"));
        }

        public String toString() {
            return String.format("Waypoint @ %s with name %s", this.coord, this.name);
        }

        public boolean equals(Object o) {
            Waypoint c = (Waypoint)o;
            return this.coord.equals(c.coord) && this.name.equals(c.name);
        }

        public int hashCode() {
            return this.coord.hashCode() + 8167 * this.name.hashCode();
        }

        public NBTTagCompound toNBT() {
            NBTTagCompound waypoint = new NBTTagCompound();
            waypoint.func_74778_a("name", this.name);
            waypoint.func_74782_a("coord", (NBTBase)this.coord.toNBT());
            return waypoint;
        }
    }
}

