/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica;

import com.github.lunatrius.core.util.vector.Vector3i;
import com.github.lunatrius.schematica.config.BlockInfo;
import com.github.lunatrius.schematica.config.PlacementData;
import com.github.lunatrius.schematica.handler.ConfigurationHandler;
import com.github.lunatrius.schematica.proxy.ClientProxy;
import com.github.lunatrius.schematica.reference.Reference;
import com.github.lunatrius.schematica.world.SchematicWorld;
import cpw.mods.fml.common.registry.GameData;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C0BPacketEntityAction;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.BlockFluidBase;

public class SchematicPrinter {
    public static final int WILDCARD_METADATA = -1;
    public static final int SIZE_CRAFTING_OUT = 1;
    public static final int SIZE_CRAFTING_IN = 4;
    public static final int SIZE_ARMOR = 4;
    public static final int SIZE_INVENTORY = 27;
    public static final int SIZE_HOTBAR = 9;
    public static final int SLOT_OFFSET_CRAFTING_OUT = 0;
    public static final int SLOT_OFFSET_CRAFTING_IN = 1;
    public static final int SLOT_OFFSET_ARMOR = 5;
    public static final int SLOT_OFFSET_INVENTORY = 9;
    public static final int SLOT_OFFSET_HOTBAR = 36;
    public static final int INV_OFFSET_HOTBAR = 0;
    public static final int INV_OFFSET_INVENTORY = 9;
    public static final SchematicPrinter INSTANCE = new SchematicPrinter();
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private boolean isEnabled;
    private boolean isPrinting;
    private SchematicWorld schematic = null;
    private byte[][][] timeout = null;

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public boolean togglePrinting() {
        this.isPrinting = !this.isPrinting;
        return this.isPrinting;
    }

    public boolean isPrinting() {
        return this.isPrinting;
    }

    public void setPrinting(boolean isPrinting) {
        this.isPrinting = isPrinting;
    }

    public SchematicWorld getSchematic() {
        return this.schematic;
    }

    public void setSchematic(SchematicWorld schematic) {
        this.isPrinting = false;
        this.schematic = schematic;
        this.refresh();
    }

    public void refresh() {
        this.timeout = this.schematic != null ? new byte[this.schematic.getWidth()][this.schematic.func_72800_K()][this.schematic.getLength()] : (byte[][][])null;
    }

    public boolean print() {
        EntityClientPlayerMP player = this.minecraft.field_71439_g;
        WorldClient world = this.minecraft.field_71441_e;
        this.syncSneaking(player, true);
        Vector3i trans = ClientProxy.playerPosition.clone().sub((double)this.schematic.position.x, (double)this.schematic.position.y, (double)this.schematic.position.z).toVector3i();
        int minX = Math.max(0, trans.x - 3);
        int maxX = Math.min(this.schematic.getWidth(), trans.x + 4);
        int minY = Math.max(0, trans.y - 3);
        int maxY = Math.min(this.schematic.func_72800_K(), trans.y + 4);
        int minZ = Math.max(0, trans.z - 3);
        int maxZ = Math.min(this.schematic.getLength(), trans.z + 4);
        int slot = player.field_71071_by.field_70461_c;
        boolean isSneaking = player.func_70093_af();
        boolean isRenderingLayer = this.schematic.isRenderingLayer;
        int renderingLayer = this.schematic.renderingLayer;
        for (int y = minY; y < maxY; ++y) {
            if (isRenderingLayer && y != renderingLayer) continue;
            for (int x = minX; x < maxX; ++x) {
                for (int z = minZ; z < maxZ; ++z) {
                    try {
                        if (!this.placeBlock((World)world, (EntityPlayer)player, x, y, z)) continue;
                        player.field_71071_by.field_70461_c = slot;
                        this.syncSneaking(player, isSneaking);
                        return true;
                    }
                    catch (Exception e) {
                        Reference.logger.error("Could not place block!", (Throwable)e);
                        player.field_71071_by.field_70461_c = slot;
                        this.syncSneaking(player, isSneaking);
                        return false;
                    }
                }
            }
        }
        player.field_71071_by.field_70461_c = slot;
        this.syncSneaking(player, isSneaking);
        return true;
    }

    private boolean placeBlock(World world, EntityPlayer player, int x, int y, int z) {
        if (this.timeout[x][y][z] > 0) {
            byte[] byArray = this.timeout[x][y];
            int n = z;
            byArray[n] = (byte)(byArray[n] - ConfigurationHandler.placeDelay);
            return false;
        }
        int wx = this.schematic.position.x + x;
        int wy = this.schematic.position.y + y;
        int wz = this.schematic.position.z + z;
        Block block = this.schematic.func_147439_a(x, y, z);
        Block realBlock = world.func_147439_a(wx, wy, wz);
        int metadata = this.schematic.func_72805_g(x, y, z);
        int realMetadata = world.func_72805_g(wx, wy, wz);
        if (block == realBlock && metadata == realMetadata) {
            return false;
        }
        if (ConfigurationHandler.destroyBlocks && !world.func_147437_c(wx, wy, wz) && this.minecraft.field_71442_b.func_78758_h()) {
            this.minecraft.field_71442_b.func_78743_b(wx, wy, wz, 0);
            this.timeout[x][y][z] = (byte)ConfigurationHandler.timeout;
            return !ConfigurationHandler.destroyInstantly;
        }
        if (this.schematic.func_147437_c(x, y, z)) {
            return false;
        }
        if (!realBlock.isReplaceable((IBlockAccess)world, wx, wy, wz)) {
            return false;
        }
        Item item = BlockInfo.getItemFromBlock(block);
        if (item == null) {
            Reference.logger.debug(GameData.getBlockRegistry().func_148750_c((Object)block) + " is missing a mapping!");
            return false;
        }
        if (this.placeBlock(this.minecraft, world, player, wx, wy, wz, item, metadata)) {
            this.timeout[x][y][z] = (byte)ConfigurationHandler.timeout;
            if (!ConfigurationHandler.placeInstantly) {
                return true;
            }
        }
        return false;
    }

    private boolean isSolid(World world, int x, int y, int z, ForgeDirection side) {
        Block block = world.func_147439_a(x += side.offsetX, y += side.offsetY, z += side.offsetZ);
        if (block == null) {
            return false;
        }
        if (block.isAir((IBlockAccess)world, x, y, z)) {
            return false;
        }
        if (block instanceof BlockFluidBase) {
            return false;
        }
        return !block.isReplaceable((IBlockAccess)world, x, y, z);
    }

    private ForgeDirection[] getSolidSides(World world, int x, int y, int z) {
        ArrayList<ForgeDirection> list = new ArrayList<ForgeDirection>();
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.isSolid(world, x, y, z, side)) continue;
            list.add(side);
        }
        ForgeDirection[] sides = new ForgeDirection[list.size()];
        return list.toArray(sides);
    }

    private boolean placeBlock(Minecraft minecraft, World world, EntityPlayer player, int x, int y, int z, Item item, int itemDamage) {
        if (item instanceof ItemBucket || item == Items.field_151155_ap) {
            return false;
        }
        PlacementData data = BlockInfo.getPlacementDataFromItem(item);
        if (!this.isValidOrientation(player, x, y, z, data, itemDamage)) {
            return false;
        }
        ForgeDirection[] solidSides = this.getSolidSides(world, x, y, z);
        ForgeDirection direction = ForgeDirection.UNKNOWN;
        float offsetY = 0.0f;
        if (solidSides.length > 0) {
            int metadata = -1;
            if (data != null) {
                ForgeDirection[] validDirections = data.getValidDirections(solidSides, itemDamage);
                if (validDirections.length > 0) {
                    direction = validDirections[0];
                }
                offsetY = data.getOffsetFromMetadata(itemDamage);
                if (data.maskMetaInHand != -1) {
                    metadata = data.getMetaInHand(itemDamage);
                }
            } else {
                direction = solidSides[0];
            }
            if (!this.swapToItem(player.field_71071_by, item, metadata)) {
                return false;
            }
        }
        if (direction != ForgeDirection.UNKNOWN || !ConfigurationHandler.placeAdjacent) {
            return this.placeBlock(minecraft, world, player, x, y, z, direction, 0.0f, offsetY, 0.0f);
        }
        return false;
    }

    private boolean isValidOrientation(EntityPlayer player, int x, int y, int z, PlacementData data, int metadata) {
        if (data != null) {
            switch (data.type) {
                case BLOCK: {
                    return true;
                }
                case PLAYER: {
                    Integer integer = data.mapping.get(ClientProxy.orientation);
                    if (integer == null) break;
                    return integer == (metadata & data.maskMeta);
                }
                case PISTON: {
                    Integer integer = data.mapping.get(ClientProxy.orientation);
                    if (integer == null) break;
                    return BlockPistonBase.func_150071_a(null, (int)x, (int)y, (int)z, (EntityLivingBase)player) == BlockPistonBase.func_150076_b((int)metadata);
                }
            }
            return false;
        }
        return true;
    }

    private boolean placeBlock(Minecraft minecraft, World world, EntityPlayer player, int x, int y, int z, ForgeDirection direction, float offsetX, float offsetY, float offsetZ) {
        ItemStack itemStack = player.func_71045_bC();
        boolean success = false;
        int side = direction.getOpposite().ordinal();
        boolean bl = success = !ForgeEventFactory.onPlayerInteract((EntityPlayer)minecraft.field_71439_g, (PlayerInteractEvent.Action)PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, (int)(x += direction.offsetX), (int)(y += direction.offsetY), (int)(z += direction.offsetZ), (int)side, (World)world).isCanceled();
        if (success && (success = minecraft.field_71442_b.func_78760_a(player, world, itemStack, x, y, z, side, Vec3.func_72443_a((double)((float)x + offsetX), (double)((float)y + offsetY), (double)((float)z + offsetZ))))) {
            minecraft.field_71439_g.func_71038_i();
        }
        if (itemStack != null && itemStack.field_77994_a == 0 && success) {
            player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
        }
        return success;
    }

    private void syncSneaking(EntityClientPlayerMP player, boolean isSneaking) {
        player.func_70095_a(isSneaking);
        player.field_71174_a.func_147297_a((Packet)new C0BPacketEntityAction((Entity)player, isSneaking ? 1 : 2));
    }

    private boolean swapToItem(InventoryPlayer inventory, Item item, int itemDamage) {
        return this.swapToItem(inventory, item, itemDamage, true);
    }

    private boolean swapToItem(InventoryPlayer inventory, Item item, int itemDamage, boolean swapSlots) {
        int slot = this.getInventorySlotWithItem(inventory, item, itemDamage);
        if (this.minecraft.field_71442_b.func_78758_h() && (slot < 0 || slot >= 9) && ConfigurationHandler.swapSlotsQueue.size() > 0) {
            inventory.field_70461_c = this.getNextSlot();
            inventory.func_70299_a(inventory.field_70461_c, new ItemStack(item, 1, itemDamage));
            this.minecraft.field_71442_b.func_78761_a(inventory.func_70301_a(inventory.field_70461_c), 36 + inventory.field_70461_c);
            return true;
        }
        if (slot >= 0 && slot < 9) {
            inventory.field_70461_c = slot;
            return true;
        }
        if (swapSlots && slot >= 9 && slot < 36 && this.swapSlots(inventory, slot)) {
            return this.swapToItem(inventory, item, itemDamage, false);
        }
        return false;
    }

    private int getInventorySlotWithItem(InventoryPlayer inventory, Item item, int itemDamage) {
        for (int i = 0; i < inventory.field_70462_a.length; ++i) {
            if (inventory.field_70462_a[i] == null || inventory.field_70462_a[i].func_77973_b() != item || itemDamage != -1 && inventory.field_70462_a[i].func_77960_j() != itemDamage) continue;
            return i;
        }
        return -1;
    }

    private boolean swapSlots(InventoryPlayer inventory, int from) {
        if (ConfigurationHandler.swapSlotsQueue.size() > 0) {
            int slot;
            ItemStack itemStack = inventory.field_70462_a[(slot = this.getNextSlot()) + 0];
            this.swapSlots(from, slot, itemStack == null || itemStack.field_77994_a == 0);
            return true;
        }
        return false;
    }

    private int getNextSlot() {
        int slot = ConfigurationHandler.swapSlotsQueue.poll() % 9;
        ConfigurationHandler.swapSlotsQueue.offer(slot);
        return slot;
    }

    private boolean swapSlots(int from, int to, boolean targetEmpty) {
        if (from >= 0 && from < 9) {
            from = 36 + (from - 0);
        } else if (from >= 9 && from < 36) {
            from = 9 + (from - 9);
        } else {
            return false;
        }
        if (to >= 0 && to < 9) {
            to = 36 + (to - 0);
        } else if (to >= 9 && to < 36) {
            to = 9 + (to - 9);
        } else {
            return false;
        }
        this.clickSlot(from);
        this.clickSlot(to);
        if (!targetEmpty) {
            this.clickSlot(from);
        }
        return true;
    }

    private ItemStack clickSlot(int slot) {
        return this.minecraft.field_71442_b.func_78753_a(this.minecraft.field_71439_g.field_71069_bz.field_75152_c, slot, 0, 0, (EntityPlayer)this.minecraft.field_71439_g);
    }
}

