/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.command;

import com.github.lunatrius.schematica.FileFilterSchematic;
import com.github.lunatrius.schematica.Schematica;
import com.github.lunatrius.schematica.command.CommandSchematicaBase;
import com.github.lunatrius.schematica.util.FileUtils;
import java.io.File;
import java.util.LinkedList;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.event.ClickEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import org.apache.commons.io.FilenameUtils;

public class CommandSchematicaList
extends CommandSchematicaBase {
    private static final FileFilterSchematic FILE_FILTER_SCHEMATIC = new FileFilterSchematic(false);

    public String func_71517_b() {
        return "schematicaList";
    }

    public String func_71518_a(ICommandSender sender) {
        return "schematica.command.list.usage";
    }

    /*
     * WARNING - void declaration
     */
    public void func_71515_b(ICommandSender sender, String[] arguments) {
        void var14_18;
        File[] files;
        if (!(sender instanceof EntityPlayer)) {
            throw new CommandException("schematica.command.save.playersOnly", new Object[0]);
        }
        int page = 0;
        try {
            if (arguments.length > 0 && (page = Integer.parseInt(arguments[0]) - 1) < 0) {
                page = 0;
            }
        }
        catch (NumberFormatException e) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayer player = (EntityPlayer)sender;
        int pageSize = 9;
        int pageStart = page * pageSize;
        int pageEnd = pageStart + pageSize;
        int currentFile = 0;
        LinkedList<ChatComponentText> componentsToSend = new LinkedList<ChatComponentText>();
        File file = Schematica.proxy.getPlayerSchematicDirectory(player, true);
        File[] arr$ = files = file.listFiles(FILE_FILTER_SCHEMATIC);
        int len$ = arr$.length;
        boolean bl = false;
        while (var14_18 < len$) {
            File path = arr$[var14_18];
            if (currentFile >= pageStart && currentFile < pageEnd) {
                String fileName = FilenameUtils.removeExtension((String)path.getName());
                ChatComponentText chatComponent = new ChatComponentText(String.format("%2d (%s): %s [", currentFile + 1, FileUtils.humanReadableByteCount(path.length()), fileName));
                String removeCommand = String.format("/%s %s", "schematicaRemove", fileName);
                IChatComponent removeLink = new ChatComponentTranslation("schematica.command.list.remove", new Object[0]).func_150255_a(new ChatStyle().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, removeCommand)).func_150238_a(EnumChatFormatting.RED));
                chatComponent.func_150257_a(removeLink);
                chatComponent.func_150258_a("][");
                String downloadCommand = String.format("/%s %s", "schematicaDownload", fileName);
                IChatComponent downloadLink = new ChatComponentTranslation("schematica.command.list.download", new Object[0]).func_150255_a(new ChatStyle().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, downloadCommand)).func_150238_a(EnumChatFormatting.GREEN));
                chatComponent.func_150257_a(downloadLink);
                chatComponent.func_150258_a("]");
                componentsToSend.add(chatComponent);
            }
            ++currentFile;
            ++var14_18;
        }
        if (currentFile == 0) {
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation("schematica.command.list.noSchematics", new Object[0]));
            return;
        }
        int totalPages = (currentFile - 1) / pageSize;
        if (page > totalPages) {
            throw new CommandException("schematica.command.list.noSuchPage", new Object[0]);
        }
        sender.func_145747_a(new ChatComponentTranslation("schematica.command.list.header", new Object[]{page + 1, totalPages + 1}).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.DARK_GREEN)));
        for (IChatComponent iChatComponent : componentsToSend) {
            sender.func_145747_a(iChatComponent);
        }
    }
}

