/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.tooltip;

import com.github.lunatrius.core.client.gui.FontRendererHelper;
import com.github.lunatrius.schematica.handler.ConfigurationHandler;
import com.github.lunatrius.schematica.world.SchematicWorld;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import org.lwjgl.opengl.GL11;

public class TooltipHandler {
    public static final TooltipHandler INSTANCE = new TooltipHandler();
    private static final FMLControlledNamespacedRegistry<Block> BLOCK_REGISTRY = GameData.getBlockRegistry();
    private static final int PADDING = 6;
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private int width = 1280;
    private int height = 720;

    public boolean renderTooltip(SchematicWorld schematic, MovingObjectPosition objectMouseOver) {
        if (objectMouseOver != null) {
            if (objectMouseOver.field_72313_a == MovingObjectPosition.MovingObjectType.MISS) {
                return false;
            }
            if (this.minecraft.field_71474_y.field_74330_P || this.minecraft.field_71462_r != null && !(this.minecraft.field_71462_r instanceof GuiChat)) {
                return false;
            }
            List<String> lines = this.getText(schematic, objectMouseOver.field_72311_b, objectMouseOver.field_72312_c, objectMouseOver.field_72309_d);
            if (!lines.isEmpty()) {
                ScaledResolution scaledResolution = new ScaledResolution(this.minecraft, this.minecraft.field_71443_c, this.minecraft.field_71440_d);
                this.width = scaledResolution.func_78326_a();
                this.height = scaledResolution.func_78328_b();
                this.drawHoveringText(lines, ConfigurationHandler.tooltipX, ConfigurationHandler.tooltipY, this.minecraft.field_71466_p);
            }
            GL11.glDisable((int)2896);
        }
        return false;
    }

    private List<String> getText(SchematicWorld schematic, int x, int y, int z) {
        ArrayList<String> list = new ArrayList<String>();
        Block block = schematic.func_147439_a(x, y, z);
        int blockMetadata = schematic.func_72805_g(x, y, z);
        list.add(block.func_149732_F());
        list.add("\u00a77" + BLOCK_REGISTRY.func_148750_c((Object)block) + "\u00a7r : " + blockMetadata);
        return list;
    }

    private void drawHoveringText(List<String> lines, float x, float y, FontRenderer fontRenderer) {
        GL11.glDisable((int)32826);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        int width = 0;
        int height = lines.size() * (fontRenderer.field_78288_b + 1) - 1;
        for (String line : lines) {
            int strWidth = fontRenderer.func_78256_a(line);
            if (strWidth <= width) continue;
            width = strWidth;
        }
        int posX = MathHelper.func_76125_a((int)((int)((float)this.width / 100.0f * x)), (int)(width / 2 + 6), (int)(this.width - (width + 1) / 2 - 6));
        int posY = MathHelper.func_76125_a((int)((int)((float)this.height / 100.0f * y)), (int)6, (int)(this.height - height - 6));
        int colorBackground = -267386864;
        this.drawGradientRect((posX -= width / 2) - 3, posY - 4, posX + width + 3, posY - 3, -267386864, -267386864);
        this.drawGradientRect(posX - 3, posY + height + 3, posX + width + 3, posY + height + 4, -267386864, -267386864);
        this.drawGradientRect(posX - 3, posY - 3, posX + width + 3, posY + height + 3, -267386864, -267386864);
        this.drawGradientRect(posX - 4, posY - 3, posX - 3, posY + height + 3, -267386864, -267386864);
        this.drawGradientRect(posX + width + 3, posY - 3, posX + width + 4, posY + height + 3, -267386864, -267386864);
        int colorTop = 0x505000FF;
        int colorBottom = 1344798847;
        this.drawGradientRect(posX - 3, posY - 3 + 1, posX - 3 + 1, posY + height + 3 - 1, 0x505000FF, 1344798847);
        this.drawGradientRect(posX + width + 2, posY - 3 + 1, posX + width + 3, posY + height + 3 - 1, 0x505000FF, 1344798847);
        this.drawGradientRect(posX - 3, posY - 3, posX + width + 3, posY - 3 + 1, 0x505000FF, 0x505000FF);
        this.drawGradientRect(posX - 3, posY + height + 2, posX + width + 3, posY + height + 3, 1344798847, 1344798847);
        posX += width / 2;
        for (String line : lines) {
            FontRendererHelper.drawCenteredString((FontRenderer)fontRenderer, (String)line, (int)posX, (int)posY, (int)-1);
            posY += 10;
        }
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
        RenderHelper.func_74519_b();
        GL11.glEnable((int)32826);
    }

    private void drawGradientRect(int x0, int y0, int x1, int y1, int colorA, int colorB) {
        float alphaA = (float)(colorA >> 24 & 0xFF) / 255.0f;
        float redA = (float)(colorA >> 16 & 0xFF) / 255.0f;
        float greenA = (float)(colorA >> 8 & 0xFF) / 255.0f;
        float blueA = (float)(colorA & 0xFF) / 255.0f;
        float alphaB = (float)(colorB >> 24 & 0xFF) / 255.0f;
        float redB = (float)(colorB >> 16 & 0xFF) / 255.0f;
        float greenB = (float)(colorB >> 8 & 0xFF) / 255.0f;
        float blueB = (float)(colorB & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(redA, greenA, blueA, alphaA);
        tessellator.func_78377_a((double)x1, (double)y0, 300.0);
        tessellator.func_78377_a((double)x0, (double)y0, 300.0);
        tessellator.func_78369_a(redB, greenB, blueB, alphaB);
        tessellator.func_78377_a((double)x0, (double)y1, 300.0);
        tessellator.func_78377_a((double)x1, (double)y1, 300.0);
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }
}

