/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.world.chunk;

import com.github.lunatrius.core.util.vector.Vector3i;
import com.github.lunatrius.schematica.Schematica;
import com.github.lunatrius.schematica.api.ISchematic;
import com.github.lunatrius.schematica.reference.Reference;
import com.github.lunatrius.schematica.world.chunk.SchematicContainer;
import com.github.lunatrius.schematica.world.schematic.SchematicFormat;
import java.io.File;
import net.minecraft.command.ICommandSender;
import net.minecraft.world.World;

public class FileSaveSchematicContainer
extends SchematicContainer {
    private final File file;
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;

    public FileSaveSchematicContainer(ISchematic schematic, ICommandSender player, World world, File file, Vector3i startPos) {
        super(schematic, player, world, startPos);
        this.file = file;
        this.minX = startPos.x;
        this.minY = startPos.y;
        this.minZ = startPos.z;
        this.maxX = startPos.x + schematic.getWidth();
        this.maxY = startPos.y + schematic.getHeight();
        this.maxZ = startPos.z + schematic.getLength();
    }

    @Override
    public void first() {
        this.tellSender("schematica.command.save.started", this.getChunkCount(), this.file.getName());
    }

    @Override
    protected void processSingleChunk(int chunkX, int chunkZ) {
        Reference.logger.debug(String.format("Copying chunk at [%d,%d] into %s", chunkX, chunkZ, this.file.getName()));
        Schematica.proxy.copyChunkToSchematic(this.getSchematic(), this.getWorld(), chunkX, chunkZ, this.minX, this.maxX, this.minY, this.maxY, this.minZ, this.maxZ);
    }

    @Override
    public void complete() {
        boolean success = SchematicFormat.writeToFile(this.file, this.getSchematic());
        String message = success ? "schematica.command.save.saveSucceeded" : "schematica.command.save.saveFailed";
        this.tellSender(message, this.file.getName());
    }
}

