/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.world.chunk;

import com.github.lunatrius.core.util.vector.Vector3i;
import com.github.lunatrius.schematica.Schematica;
import com.github.lunatrius.schematica.api.ISchematic;
import com.github.lunatrius.schematica.reference.Reference;
import com.github.lunatrius.schematica.world.chunk.SchematicContainer;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class GenerateSchematicContainer
extends SchematicContainer {
    private String fileName;
    private Vector3i startPos;

    public GenerateSchematicContainer(ISchematic schematic, ICommandSender player, World world, Vector3i startPos, String fileName) {
        super(schematic, player, world, startPos);
        this.fileName = fileName;
        this.startPos = startPos;
    }

    @Override
    public void first() {
        this.tellSender("schematica.command.generate.started", this.getChunkCount(), this.fileName);
    }

    @Override
    protected void processSingleChunk(int chunkX, int chunkZ) {
        Reference.logger.debug(String.format("Loading chunk at [%d,%d] from %s", chunkX, chunkZ, this.fileName));
        Schematica.proxy.generateSchematicChunk(this.getSchematic(), this.getWorld(), chunkX, chunkZ, this.startPos);
    }

    @Override
    public void complete() {
        for (NBTTagCompound entity : this.getSchematic().getEntityData()) {
            entity.func_82580_o("UUIDMost");
            entity.func_82580_o("PersistentIDMSB");
            NBTTagList pos = entity.func_150295_c("Pos", 6);
            pos.func_150304_a(0, (NBTBase)new NBTTagDouble(pos.func_150309_d(0) + (double)this.startPos.x));
            pos.func_150304_a(1, (NBTBase)new NBTTagDouble(pos.func_150309_d(1) + (double)this.startPos.y));
            pos.func_150304_a(2, (NBTBase)new NBTTagDouble(pos.func_150309_d(2) + (double)this.startPos.z));
            entity.func_74782_a("Pos", (NBTBase)pos);
            Entity newEntity = EntityList.func_75615_a((NBTTagCompound)entity, (World)this.getWorld());
            this.getWorld().func_72838_d(newEntity);
        }
        String message = "schematica.command.generate.succeeded";
        this.tellSender("schematica.command.generate.succeeded", this.fileName);
    }
}

