/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.world.schematic;

import com.github.lunatrius.schematica.api.ISchematic;
import com.github.lunatrius.schematica.api.event.PreSchematicSaveEvent;
import com.github.lunatrius.schematica.reference.Reference;
import com.github.lunatrius.schematica.world.schematic.SchematicFormat;
import com.github.lunatrius.schematica.world.schematic.SchematicUtil;
import com.github.lunatrius.schematica.world.storage.Schematic;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameData;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;

public class SchematicAlpha
extends SchematicFormat {
    private static final FMLControlledNamespacedRegistry<Block> BLOCK_REGISTRY = GameData.getBlockRegistry();

    @Override
    public ISchematic readFromNBT(NBTTagCompound tagCompound) {
        ItemStack icon = SchematicUtil.getIconFromNBT(tagCompound);
        byte[] localBlocks = tagCompound.func_74770_j("Blocks");
        byte[] localMetadata = tagCompound.func_74770_j("Data");
        boolean extra = false;
        byte[] extraBlocks = null;
        byte[] extraBlocksNibble = null;
        if (tagCompound.func_74764_b("AddBlocks")) {
            extra = true;
            extraBlocksNibble = tagCompound.func_74770_j("AddBlocks");
            extraBlocks = new byte[extraBlocksNibble.length * 2];
            for (int i = 0; i < extraBlocksNibble.length; ++i) {
                extraBlocks[i * 2 + 0] = (byte)(extraBlocksNibble[i] >> 4 & 0xF);
                extraBlocks[i * 2 + 1] = (byte)(extraBlocksNibble[i] & 0xF);
            }
        } else if (tagCompound.func_74764_b("Add")) {
            extra = true;
            extraBlocks = tagCompound.func_74770_j("Add");
        }
        int width = tagCompound.func_74765_d("Width");
        int length = tagCompound.func_74765_d("Length");
        int height = tagCompound.func_74765_d("Height");
        Short id = null;
        HashMap<Short, Short> oldToNew = new HashMap<Short, Short>();
        if (tagCompound.func_74764_b("SchematicaMapping")) {
            NBTTagCompound mapping = tagCompound.func_74775_l("SchematicaMapping");
            Set names = mapping.func_150296_c();
            for (String name : names) {
                oldToNew.put(mapping.func_74765_d(name), (short)BLOCK_REGISTRY.getId(name));
            }
        }
        Schematic schematic = new Schematic(icon, width, height, length);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    int index = x + (y * length + z) * width;
                    int blockID = localBlocks[index] & 0xFF | (extra ? (extraBlocks[index] & 0xFF) << 8 : 0);
                    int meta = localMetadata[index] & 0xFF;
                    id = (Short)oldToNew.get((short)blockID);
                    if (id != null) {
                        blockID = id.shortValue();
                    }
                    schematic.setBlock(x, y, z, (Block)BLOCK_REGISTRY.func_148754_a(blockID), meta);
                }
            }
        }
        NBTTagList entitiesList = tagCompound.func_150295_c("Entities", 10);
        for (int i = 0; i < entitiesList.func_74745_c(); ++i) {
            schematic.addEntityData(entitiesList.func_150305_b(i));
        }
        NBTTagList tileEntitiesList = tagCompound.func_150295_c("TileEntities", 10);
        for (int i = 0; i < tileEntitiesList.func_74745_c(); ++i) {
            try {
                TileEntity tileEntity = TileEntity.func_145827_c((NBTTagCompound)tileEntitiesList.func_150305_b(i));
                if (tileEntity == null) continue;
                schematic.setTileEntity(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e, tileEntity);
                continue;
            }
            catch (Exception e) {
                Reference.logger.error("TileEntity failed to load properly!", (Throwable)e);
            }
        }
        return schematic;
    }

    @Override
    public boolean writeToNBT(NBTTagCompound tagCompound, ISchematic schematic) {
        NBTTagCompound tagCompoundIcon = new NBTTagCompound();
        ItemStack icon = schematic.getIcon();
        icon.func_77955_b(tagCompoundIcon);
        tagCompound.func_74782_a("Icon", (NBTBase)tagCompoundIcon);
        tagCompound.func_74777_a("Width", (short)schematic.getWidth());
        tagCompound.func_74777_a("Length", (short)schematic.getLength());
        tagCompound.func_74777_a("Height", (short)schematic.getHeight());
        int size = schematic.getWidth() * schematic.getLength() * schematic.getHeight();
        byte[] localBlocks = new byte[size];
        byte[] localMetadata = new byte[size];
        byte[] extraBlocks = new byte[size];
        byte[] extraBlocksNibble = new byte[(int)Math.ceil((double)size / 2.0)];
        boolean extra = false;
        HashMap<String, Short> mappings = new HashMap<String, Short>();
        for (int x = 0; x < schematic.getWidth(); ++x) {
            for (int y = 0; y < schematic.getHeight(); ++y) {
                for (int z = 0; z < schematic.getLength(); ++z) {
                    String name;
                    int index = x + (y * schematic.getLength() + z) * schematic.getWidth();
                    Block block = schematic.getBlock(x, y, z);
                    int blockId = BLOCK_REGISTRY.getId((Object)block);
                    localBlocks[index] = (byte)blockId;
                    localMetadata[index] = (byte)schematic.getBlockMetadata(x, y, z);
                    extraBlocks[index] = (byte)(blockId >> 8);
                    if (extraBlocks[index] > 0) {
                        extra = true;
                    }
                    if (mappings.containsKey(name = BLOCK_REGISTRY.func_148750_c((Object)block))) continue;
                    mappings.put(name, (short)blockId);
                }
            }
        }
        int count = 20;
        NBTTagList tileEntitiesList = new NBTTagList();
        for (TileEntity tileEntity : schematic.getTileEntities()) {
            NBTTagCompound tileEntityTagCompound = new NBTTagCompound();
            try {
                tileEntity.func_145841_b(tileEntityTagCompound);
                tileEntitiesList.func_74742_a((NBTBase)tileEntityTagCompound);
            }
            catch (Exception e) {
                int pos = tileEntity.field_145851_c + (tileEntity.field_145848_d * schematic.getLength() + tileEntity.field_145849_e) * schematic.getWidth();
                if (--count > 0) {
                    Block block = schematic.getBlock(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
                    Reference.logger.error(String.format("Block %s[%s] with TileEntity %s failed to save! Replacing with bedrock...", block, block != null ? BLOCK_REGISTRY.func_148750_c((Object)block) : "?", tileEntity.getClass().getName()), (Throwable)e);
                }
                localBlocks[pos] = (byte)BLOCK_REGISTRY.getId((Object)Blocks.field_150357_h);
                localMetadata[pos] = 0;
                extraBlocks[pos] = 0;
            }
        }
        NBTTagList entitiesList = new NBTTagList();
        for (NBTTagCompound entity : schematic.getEntityData()) {
            entitiesList.func_74742_a((NBTBase)entity);
        }
        for (int i = 0; i < extraBlocksNibble.length; ++i) {
            extraBlocksNibble[i] = i * 2 + 1 < extraBlocks.length ? (byte)(extraBlocks[i * 2 + 0] << 4 | extraBlocks[i * 2 + 1]) : (byte)(extraBlocks[i * 2 + 0] << 4);
        }
        PreSchematicSaveEvent event = new PreSchematicSaveEvent(mappings);
        MinecraftForge.EVENT_BUS.post((Event)event);
        NBTTagCompound nbtMapping = new NBTTagCompound();
        for (Map.Entry entry : mappings.entrySet()) {
            nbtMapping.func_74777_a((String)entry.getKey(), ((Short)entry.getValue()).shortValue());
        }
        tagCompound.func_74778_a("Materials", "Alpha");
        tagCompound.func_74773_a("Blocks", localBlocks);
        tagCompound.func_74773_a("Data", localMetadata);
        if (extra) {
            tagCompound.func_74773_a("AddBlocks", extraBlocksNibble);
        }
        tagCompound.func_74782_a("Entities", (NBTBase)entitiesList);
        tagCompound.func_74782_a("TileEntities", (NBTBase)tileEntitiesList);
        tagCompound.func_74782_a("SchematicaMapping", (NBTBase)nbtMapping);
        NBTTagCompound extendedMetadata = event.extendedMetadata;
        if (!extendedMetadata.func_82582_d()) {
            tagCompound.func_74782_a("ExtendedMetadata", (NBTBase)extendedMetadata);
        }
        return true;
    }
}

