/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.world.storage;

import com.github.lunatrius.schematica.api.ISchematic;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class Schematic
implements ISchematic {
    private static final ItemStack DEFAULT_ICON = new ItemStack((Block)Blocks.field_150349_c);
    private static final FMLControlledNamespacedRegistry<Block> BLOCK_REGISTRY = GameData.getBlockRegistry();
    private ItemStack icon;
    private final short[][][] blocks;
    private final byte[][][] metadata;
    private final List<TileEntity> tileEntities = new ArrayList<TileEntity>();
    private final List<NBTTagCompound> entityData = new ArrayList<NBTTagCompound>();
    private final int width;
    private final int height;
    private final int length;

    public Schematic(ItemStack icon, int width, int height, int length) {
        this.icon = icon;
        this.blocks = new short[width][height][length];
        this.metadata = new byte[width][height][length];
        this.width = width;
        this.height = height;
        this.length = length;
    }

    @Override
    public Block getBlock(int x, int y, int z) {
        if (!this.isValid(x, y, z)) {
            return Blocks.field_150350_a;
        }
        return (Block)BLOCK_REGISTRY.func_148754_a((int)this.blocks[x][y][z]);
    }

    @Override
    public boolean setBlock(int x, int y, int z, Block block) {
        return this.setBlock(x, y, z, block, 0);
    }

    @Override
    public boolean setBlock(int x, int y, int z, Block block, int metadata) {
        if (!this.isValid(x, y, z)) {
            return false;
        }
        int id = BLOCK_REGISTRY.getId((Object)block);
        if (id == -1) {
            return false;
        }
        this.blocks[x][y][z] = (short)id;
        this.setBlockMetadata(x, y, z, metadata);
        return true;
    }

    @Override
    public TileEntity getTileEntity(int x, int y, int z) {
        for (TileEntity tileEntity : this.tileEntities) {
            if (tileEntity.field_145851_c != x || tileEntity.field_145848_d != y || tileEntity.field_145849_e != z) continue;
            return tileEntity;
        }
        return null;
    }

    @Override
    public List<TileEntity> getTileEntities() {
        return this.tileEntities;
    }

    @Override
    public void setTileEntity(int x, int y, int z, TileEntity tileEntity) {
        if (!this.isValid(x, y, z)) {
            return;
        }
        this.removeTileEntity(x, y, z);
        this.tileEntities.add(tileEntity);
    }

    @Override
    public void removeTileEntity(int x, int y, int z) {
        Iterator<TileEntity> iterator = this.tileEntities.iterator();
        while (iterator.hasNext()) {
            TileEntity tileEntity = iterator.next();
            if (tileEntity.field_145851_c != x || tileEntity.field_145848_d != y || tileEntity.field_145849_e != z) continue;
            iterator.remove();
        }
    }

    @Override
    public List<NBTTagCompound> getEntityData() {
        return this.entityData;
    }

    @Override
    public void addEntity(Entity entity) {
        if (!this.isValid((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v)) {
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        if (entity.func_70039_c(tag)) {
            this.entityData.add(tag);
        }
    }

    @Override
    public void addEntityData(NBTTagCompound data) {
        this.entityData.add(data);
    }

    @Override
    public int getBlockMetadata(int x, int y, int z) {
        if (!this.isValid(x, y, z)) {
            return 0;
        }
        return this.metadata[x][y][z];
    }

    @Override
    public boolean setBlockMetadata(int x, int y, int z, int metadata) {
        if (!this.isValid(x, y, z)) {
            return false;
        }
        this.metadata[x][y][z] = (byte)(metadata & 0xF);
        return true;
    }

    @Override
    public ItemStack getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(ItemStack icon) {
        this.icon = icon != null ? icon : DEFAULT_ICON.func_77946_l();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    private boolean isValid(int x, int y, int z) {
        return x >= 0 && y >= 0 && z >= 0 && x < this.width && y < this.height && z < this.length;
    }
}

