/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont;

import bre.smoothfont.FontRasterizer;
import bre.smoothfont.FontRendererHook;
import bre.smoothfont.FontRendererHookList;
import bre.smoothfont.FontTextureManager;
import bre.smoothfont.FontUtils;
import bre.smoothfont.config.CommonConfig;
import bre.smoothfont.config.GlobalConfig;
import bre.smoothfont.util.Logger;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.util.EnumChatFormatting;

public class CommandSfont
extends CommandBase {
    private final String COMMAND_NAME = "sfont";
    private final String COMMAND_USAGE = "/sfont <renderers | precision | disable | enable | page> ...";
    private final String CMD_PRECISION_USAGE = "/sfont precision <high | normal | vanilla> <renderer number>";
    private final String CMD_PRECISION_USAGE2 = "/sfont precision <high | normal | vanilla> <renderer number>";
    private final String CMD_DISABLE_USAGE = "/sfont disable <renderer number>";
    private final String CMD_ENABLE_USAGE = "/sfont enable <renderer number>";
    private final String CMD_PAGE_USAGE = "/sfont page <glyph page number>";
    private final String[] COMPLETION_WORDS = new String[]{"renderers", "precision", "disable", "enable", "page"};
    public static final CommandSfont INSTANCE = new CommandSfont();
    private Minecraft mc = Minecraft.func_71410_x();

    public String func_71517_b() {
        return "sfont";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/sfont <renderers | precision | disable | enable | page> ...";
    }

    public boolean func_71519_b(ICommandSender sender) {
        return true;
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        List compList = args.length == 1 ? CommandSfont.func_71530_a((String[])args, (String[])this.COMPLETION_WORDS) : Collections.emptyList();
        return compList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) throw new WrongUsageException("/sfont <renderers | precision | disable | enable | page> ...", new Object[0]);
        switch (SubCmd.getEnum(args[0])) {
            case RENDERERS: {
                List<String> rendererNameList = args.length >= 2 ? this.getRendererNameList(args[1]) : this.getRendererNameList("");
                Logger.printChatMessage("List of font renderers");
                int i = 0;
                for (String rendererName : rendererNameList) {
                    Logger.printChatMessage(i + " : " + (this.getRendererDisable(i) ? "Off" : "On") + " : " + (this.getRendererFontType(i) ? "CHG" : "N/C") + " : " + (this.getRendererPrecisionMode(i) == 0 ? "High   " : (this.getRendererPrecisionMode(i) == 1 ? "Normal " : "Vanilla")) + " : " + rendererName);
                    ++i;
                }
                return;
            }
            case PRECISION: {
                if (args.length < 2) throw new WrongUsageException("/sfont precision <high | normal | vanilla> <renderer number>", new Object[0]);
                if ("high".equals(args[1])) {
                    if (args.length < 3 || !this.setRendererPrecisionMode(Integer.parseInt(args[2]), 0)) throw new WrongUsageException("/sfont precision <high | normal | vanilla> <renderer number>", new Object[0]);
                    Logger.printChatMessage("Renderer-" + args[2] + " set to high precision.");
                    this.saveHighPrecisionConfig();
                    this.saveVanillaPrecisionConfig();
                    return;
                }
                if ("normal".equals(args[1])) {
                    if (args.length < 3 || !this.setRendererPrecisionMode(Integer.parseInt(args[2]), 1)) throw new WrongUsageException("/sfont precision <high | normal | vanilla> <renderer number>", new Object[0]);
                    Logger.printChatMessage("Renderer-" + args[2] + " set to normal precision.");
                    this.saveHighPrecisionConfig();
                    this.saveVanillaPrecisionConfig();
                    return;
                }
                if (!"vanilla".equals(args[1])) throw new WrongUsageException("/sfont precision <high | normal | vanilla> <renderer number>", new Object[0]);
                if (args.length < 3 || !this.setRendererPrecisionMode(Integer.parseInt(args[2]), 2)) throw new WrongUsageException("/sfont precision <high | normal | vanilla> <renderer number>", new Object[0]);
                Logger.printChatMessage("Renderer-" + args[2] + " set to vanilla precision.");
                this.saveHighPrecisionConfig();
                this.saveVanillaPrecisionConfig();
                return;
            }
            case DISABLE: {
                if (args.length < 2 || !this.setRendererDisable(Integer.parseInt(args[1]), true)) throw new WrongUsageException("/sfont disable <renderer number>", new Object[0]);
                Logger.printChatMessage("Renderer-" + args[1] + " set to disabled.");
                return;
            }
            case ENABLE: {
                if (args.length < 2 || !this.setRendererDisable(Integer.parseInt(args[1]), false)) throw new WrongUsageException("/sfont enable <renderer number>", new Object[0]);
                Logger.printChatMessage("Renderer-" + args[1] + " set to enabled.");
                return;
            }
            case PAGE: {
                if (args.length < 2) throw new WrongUsageException("/sfont page <glyph page number>", new Object[0]);
                if (args.length >= 3) {
                    this.showTexture(Integer.parseInt(args[1]), true);
                    return;
                }
                this.showTexture(Integer.parseInt(args[1]), false);
                return;
            }
            case DEBUG: {
                if (args.length >= 2) {
                    GlobalConfig.debug = "on".equals(args[1]);
                    Logger.printChatMessage("Set debug=" + GlobalConfig.debug);
                    return;
                }
                Logger.printChatMessage("debug=" + GlobalConfig.debug);
                return;
            }
            default: {
                throw new WrongUsageException("/sfont <renderers | precision | disable | enable | page> ...", new Object[0]);
            }
        }
    }

    private List<String> getRendererNameList(final String option) {
        final ArrayList<String> rendererNameList = new ArrayList<String>();
        FontRendererHookList hookList = new FontRendererHookList(){

            @Override
            public boolean process(FontRendererHook frh) {
                String rendererName = "path".equals(option) ? frh.fontRenderer.getClass().getName() + "\n      (" + frh.fontRenderer.field_111273_g.func_110624_b() + ":" + frh.fontRenderer.field_111273_g.func_110623_a() + ")" : ("reason".equals(option) ? (frh.reasonForDisable != null ? EnumChatFormatting.YELLOW + frh.fontRenderer.getClass().getName() + "\n      (Reason for disabling: " + frh.reasonForDisable + ")" + EnumChatFormatting.RESET : frh.fontRenderer.getClass().getName()) : (frh.reasonForDisable != null ? EnumChatFormatting.YELLOW + frh.fontRenderer.getClass().getName() + EnumChatFormatting.RESET : (frh.fontRenderer == ((CommandSfont)CommandSfont.this).mc.field_71466_p ? EnumChatFormatting.AQUA + frh.fontRenderer.getClass().getName() + EnumChatFormatting.RESET : frh.fontRenderer.getClass().getName())));
                rendererNameList.add(rendererName);
                return true;
            }
        };
        hookList.executeAll();
        return rendererNameList;
    }

    private int getRendererPrecisionMode(int rendererNo) {
        int curPrecision = 0;
        int maxIndex = FontRendererHookList.size() - 1;
        if (rendererNo < 0 || rendererNo > maxIndex) {
            Logger.printChatMessage("Illegal renderer number.");
            return -1;
        }
        FontRendererHook frh = FontRendererHookList.get(rendererNo);
        if (frh != null) {
            curPrecision = frh.precisionMode;
        } else {
            Logger.printChatMessage("Unexpected error: Renderer is null.");
        }
        return curPrecision;
    }

    private boolean setRendererPrecisionMode(int rendererNo, final int precision) {
        int maxIndex = FontRendererHookList.size() - 1;
        if (rendererNo < 0 || rendererNo > maxIndex) {
            Logger.printChatMessage("Illegal renderer number.");
            return false;
        }
        FontRendererHook frh = FontRendererHookList.get(rendererNo);
        if (frh == null) {
            Logger.printChatMessage("Unexpected error: Renderer is null.");
            return false;
        }
        final String targetClassName = frh.fontRenderer.getClass().getName();
        FontRendererHookList hookList = new FontRendererHookList(){

            @Override
            public boolean process(FontRendererHook frh) {
                String className = frh.fontRenderer.getClass().getName();
                if (className.equals(targetClassName)) {
                    if ((precision == 1 || precision == 2) && frh.precisionMode == 0 && frh.fontRenderer == ((CommandSfont)CommandSfont.this).mc.field_71466_p) {
                        CommonConfig.globalConfig.setMcRendererToHighPRC = false;
                        CommonConfig.globalConfig.saveConfig();
                    }
                    frh.precisionMode = precision;
                }
                return true;
            }
        };
        hookList.executeAll();
        return true;
    }

    private void saveHighPrecisionConfig() {
        final ArrayList<String> configList = new ArrayList<String>();
        configList.addAll(Arrays.asList(CommonConfig.globalConfig.highPrecisionClasses));
        final Iterator iter = configList.iterator();
        while (iter.hasNext()) {
            final String configRendererName = (String)iter.next();
            FontRendererHookList hookList = new FontRendererHookList(){

                @Override
                public boolean process(FontRendererHook frh) {
                    String className;
                    if (frh.precisionMode != 0 && (className = frh.fontRenderer.getClass().getName()).equals(configRendererName)) {
                        iter.remove();
                        return false;
                    }
                    return true;
                }
            };
            hookList.executeAll();
        }
        FontRendererHookList hookList = new FontRendererHookList(){

            @Override
            public boolean process(FontRendererHook frh) {
                if (frh.precisionMode == 0) {
                    boolean classFound = false;
                    String rendererClassName = frh.fontRenderer.getClass().getName();
                    for (String configRendererName : configList) {
                        if (!configRendererName.equals(rendererClassName)) continue;
                        classFound = true;
                        break;
                    }
                    if (!classFound) {
                        configList.add(rendererClassName);
                    }
                }
                return true;
            }
        };
        hookList.executeAll();
        CommonConfig.globalConfig.highPrecisionClasses = configList.toArray(new String[configList.size()]);
        CommonConfig.globalConfig.saveConfig();
        Logger.printChatMessage("highPrecisionClasses config saved.");
    }

    private void saveVanillaPrecisionConfig() {
        final ArrayList<String> configList = new ArrayList<String>();
        configList.addAll(Arrays.asList(CommonConfig.globalConfig.vanillaPrecisionClasses));
        final Iterator iter = configList.iterator();
        while (iter.hasNext()) {
            final String configRendererName = (String)iter.next();
            FontRendererHookList hookList = new FontRendererHookList(){

                @Override
                public boolean process(FontRendererHook frh) {
                    String className;
                    if (frh.precisionMode != 2 && (className = frh.fontRenderer.getClass().getName()).equals(configRendererName)) {
                        iter.remove();
                        return false;
                    }
                    return true;
                }
            };
            hookList.executeAll();
        }
        FontRendererHookList hookList = new FontRendererHookList(){

            @Override
            public boolean process(FontRendererHook frh) {
                if (frh.precisionMode == 2) {
                    boolean classFound = false;
                    String rendererClassName = frh.fontRenderer.getClass().getName();
                    for (String configRendererName : configList) {
                        if (!configRendererName.equals(rendererClassName)) continue;
                        classFound = true;
                        break;
                    }
                    if (!classFound) {
                        configList.add(rendererClassName);
                    }
                }
                return true;
            }
        };
        hookList.executeAll();
        CommonConfig.globalConfig.vanillaPrecisionClasses = configList.toArray(new String[configList.size()]);
        CommonConfig.globalConfig.saveConfig();
        Logger.printChatMessage("vanillaPrecisionClasses config saved.");
    }

    private boolean getRendererDisable(int rendererNo) {
        int maxIndex = FontRendererHookList.size() - 1;
        if (rendererNo < 0 || rendererNo > maxIndex) {
            Logger.printChatMessage("Illegal renderer number.");
            return false;
        }
        FontRendererHook frh = FontRendererHookList.get(rendererNo);
        if (frh != null) {
            return frh.disableAllFeatures;
        }
        Logger.printChatMessage("Unexpected error: Renderer is null.");
        return false;
    }

    private boolean setRendererDisable(int rendererNo, boolean flag) {
        int maxIndex = FontRendererHookList.size() - 1;
        if (rendererNo < 0 || rendererNo > maxIndex) {
            Logger.printChatMessage("Illegal renderer number.");
            return false;
        }
        FontRendererHook frh = FontRendererHookList.get(rendererNo);
        if (frh == null) {
            Logger.printChatMessage("Unexpected error: Renderer is null.");
            return false;
        }
        frh.disableAllFeatures = flag;
        Logger.printChatMessage("This change is temporary and NOT saved to the config file.");
        FontTextureManager.getInstance().func_110549_a(this.mc.func_110442_L());
        return true;
    }

    private boolean getRendererFontType(int rendererNo) {
        boolean curFontType = false;
        int maxIndex = FontRendererHookList.size() - 1;
        if (rendererNo < 0 || rendererNo > maxIndex) {
            Logger.printChatMessage("Illegal renderer number.");
            return false;
        }
        FontRendererHook frh = FontRendererHookList.get(rendererNo);
        if (frh != null) {
            curFontType = frh.changeFont;
        } else {
            Logger.printChatMessage("Unexpected error: Renderer is null.");
        }
        return curFontType;
    }

    private void showTexture(int page, boolean separation) {
        int borderWidth;
        BufferedImage img = FontRasterizer.getInstance().getFontImage(page);
        int fontRes = FontTextureManager.getInstance().getUnicodeFontRes(true);
        if ((fontRes + (borderWidth = FontUtils.getBorderWidth(fontRes, true))) * 16 < img.getWidth()) {
            FontUtils.showFontImage(img, fontRes * 2, borderWidth * 2, separation);
        } else {
            FontUtils.showFontImage(img, fontRes, borderWidth, separation);
        }
    }

    private static enum SubCmd {
        RENDERERS,
        PRECISION,
        DISABLE,
        ENABLE,
        PAGE,
        DEBUG,
        UNKNOWN;


        public static SubCmd getEnum(String cmdstr) {
            try {
                return SubCmd.valueOf(cmdstr.toUpperCase());
            }
            catch (Exception e) {
                return UNKNOWN;
            }
        }
    }
}

