/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont;

import bre.smoothfont.FontPixels;
import bre.smoothfont.FontRendererHook;
import bre.smoothfont.FontRendererHookList;
import bre.smoothfont.FontTextureManager;
import bre.smoothfont.FontUtils;
import bre.smoothfont.config.CommonConfig;
import bre.smoothfont.config.GlobalConfig;
import bre.smoothfont.util.Logger;
import bre.smoothfont.util.ModLib;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.CharUtils;

public class FontRasterizer {
    private static FontRasterizer INSTANCE = new FontRasterizer();
    private int fontRes;
    private int fontGap;
    private Font font;
    private boolean antiAlias;
    private boolean fractionalMetrics;
    private int fontDouble;
    private Font secondaryFont;
    private Font defaultFont;
    private boolean primaryFontAvailable = true;
    private boolean secondaryFontAvailable = true;
    public boolean glyphsGenerationError = false;
    public String glyphsGenerationErrorMessage;
    public int[] charWidthInt = new int[256];
    public byte[] glyphWidthByte = new byte[65536];
    private int[] charWidthOrig = null;
    private byte[] glyphWidthOrig = null;
    public float[] charWidthFloat = new float[256];
    public float[] glyphWidthFloat = new float[65536];
    public float[] glyphBaselineGap = new float[65536];
    private BufferedImage[] fontImageCache = new BufferedImage[257];
    private byte[][] fontCompressedImageCache = new byte[257][];
    private BufferedImage blankImage;
    private boolean allFontCacheAvailable = false;
    public boolean grayScale = false;
    private boolean compressImage = false;
    private int[] imageSize = new int[257];
    public long totalImageSize;
    public static final float fontSizeAdjustmentRate = 0.05f;
    public int autoBrightnessValue = 3;
    public float brightnessBoundaryScaleFactor = 4.0f;

    public FontRasterizer() {
        try {
            if (CommonConfig.currentConfig.fontResIndex > FontUtils.getMaxFontSizeIndex()) {
                CommonConfig.currentConfig.fontResIndex = FontUtils.getMaxFontSizeIndex();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean initFontCache() {
        boolean result = true;
        if (CommonConfig.currentConfig.useOSFont && !this.allFontCacheAvailable) {
            result = this.setFontSafely(CommonConfig.currentConfig.fontName, CommonConfig.currentConfig.secondaryFontName, FontUtils.getFontRes(CommonConfig.currentConfig.fontResIndex), CommonConfig.currentConfig.fontGap, CommonConfig.currentConfig.fontSizeAdjustment, CommonConfig.currentConfig.fontAntiAlias, CommonConfig.currentConfig.fontEmphasis);
        }
        return result;
    }

    public boolean setFontSafely(String fontName, String secondaryFontName, int fontRes, int fontGap, int fontSizeAdjustment, int antiAlias, int fontDouble) {
        try {
            this.glyphsGenerationError = false;
            this.glyphsGenerationErrorMessage = "";
            this.setFont(fontName, secondaryFontName, fontRes, fontGap, fontSizeAdjustment, antiAlias, fontDouble);
        }
        catch (Throwable throwable) {
            this.glyphsGenerationError = true;
            this.glyphsGenerationErrorMessage = throwable.toString();
            Logger.error("***** Caught the exception during setFont(). Abort changing fonts. *****");
            throwable.printStackTrace();
            return false;
        }
        return true;
    }

    public void setFont(String fontName, String secondaryFontName, int fontRes, int fontGap, int fontSizeAdjustment, int antiAlias, int fontDouble) {
        int CPU_NUM;
        this.compressImage = CommonConfig.globalConfig.compressImage | CommonConfig.currentConfig.saveMemory >= 1;
        if (this.compressImage && CommonConfig.globalConfig.compressImageRequiredCPUs >= 1 && CommonConfig.globalConfig.compressImageRequiredCPUs > (CPU_NUM = Runtime.getRuntime().availableProcessors())) {
            this.compressImage = false;
        }
        this.grayScale = CommonConfig.globalConfig.useGrayscaleImage | CommonConfig.currentConfig.saveMemory >= 1;
        if (this.grayScale) {
            CommonConfig.currentConfig.enablePremultipliedAlpha = false;
            CommonConfig.saveCurrentConfig();
        }
        this.antiAlias = antiAlias >= 1;
        this.fractionalMetrics = antiAlias >= 2;
        this.fontDouble = fontDouble;
        this.fontGap = fontGap;
        this.fontRes = fontRes;
        this.font = new Font(fontName, 0, fontRes);
        float pointSize = this.getMaxPointSize(this.font, fontRes);
        pointSize += pointSize * 0.05f * (float)fontSizeAdjustment;
        this.font = this.font.deriveFont(pointSize);
        this.primaryFontAvailable = FontUtils.isFontAvailable(this.font);
        this.secondaryFont = new Font(secondaryFontName, 0, fontRes);
        pointSize = this.getMaxPointSize(this.secondaryFont, fontRes);
        pointSize += pointSize * 0.05f * (float)fontSizeAdjustment;
        this.secondaryFont = this.secondaryFont.deriveFont(pointSize);
        this.secondaryFontAvailable = FontUtils.isFontAvailable(this.secondaryFont);
        this.defaultFont = new Font("SansSerif", 0, fontRes);
        pointSize = this.getMaxPointSize(this.defaultFont, fontRes);
        pointSize += pointSize * 0.05f * (float)fontSizeAdjustment;
        this.defaultFont = this.defaultFont.deriveFont(pointSize);
        int border = FontUtils.getBorderWidth(fontRes, true);
        int imageWidth = (fontRes + border) * 16;
        this.blankImage = this.grayScale ? new BufferedImage(imageWidth, imageWidth, 10) : new BufferedImage(imageWidth, imageWidth, 6);
        this.autoBrightnessValue = 255;
        this.brightnessBoundaryScaleFactor = 4.0f;
        this.clearFontCache();
        FontTextureManager.getInstance().clearMapTextureObjects();
        this.createFontCacheAll();
    }

    public void clearFontCache() {
        for (int i = 0; i < 257; ++i) {
            this.fontImageCache[i] = null;
            this.fontCompressedImageCache[i] = null;
            this.imageSize[i] = 0;
        }
        this.totalImageSize = 0L;
        this.allFontCacheAvailable = false;
    }

    public void createFontCacheAll() {
        int i;
        this.clearFontCache();
        ModLib.startCounter("All images generation time");
        switch (GlobalConfig.multiThread) {
            case 0: {
                for (i = 0; i < 257; ++i) {
                    this.getFontImage(i);
                }
                break;
            }
            case 1: {
                int i2;
                CreateFontImageThread[] thread = new CreateFontImageThread[257];
                for (i2 = 0; i2 < 256; ++i2) {
                    thread[i2] = new CreateFontImageThread(i2);
                    thread[i2].start();
                }
                for (i2 = 0; i2 < 256; ++i2) {
                    try {
                        thread[i2].join();
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.getFontImage(256);
                break;
            }
            default: {
                int CPU_NUM = Runtime.getRuntime().availableProcessors();
                ExecutorService threadPool = Executors.newFixedThreadPool(CPU_NUM);
                for (int i3 = 0; i3 < 256; ++i3) {
                    threadPool.submit(new CreateFontImageThread(i3));
                }
                threadPool.shutdown();
                try {
                    threadPool.awaitTermination(10L, TimeUnit.MINUTES);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.getFontImage(256);
            }
        }
        ModLib.stopCounterMs("All images generation time");
        this.totalImageSize = 0L;
        for (i = 0; i < 257; ++i) {
            this.totalImageSize += (long)this.imageSize[i];
        }
        if (!this.compressImage) {
            this.totalImageSize += (long)FontUtils.getBytesFromImage(this.blankImage).length;
        }
        Logger.info("Total memory used for the current platform font images: " + this.totalImageSize / 1024L / 1024L + "MB");
        this.allFontCacheAvailable = true;
    }

    public static FontRasterizer getInstance() {
        return INSTANCE;
    }

    private float getMaxPointSize(Font font, int pixelSize) {
        float pointSize;
        if (CommonConfig.currentConfig.fontAutoSizing) {
            BufferedImage testImage = new BufferedImage(128, 128, 6);
            Graphics2D g2 = testImage.createGraphics();
            g2.setFont(font);
            FontMetrics fm = g2.getFontMetrics();
            FontPixels fp = new FontPixels(font, fm, this.antiAlias, this.fractionalMetrics);
            pointSize = fp.getFittedSize(pixelSize, 0.0f, 1.0f);
            pointSize = fp.getFittedSize(pixelSize, pointSize, 0.1f);
            Logger.info("Suitable font size is " + pointSize + " (" + font.getFontName() + ")");
            g2.dispose();
        } else {
            pointSize = pixelSize;
        }
        return pointSize;
    }

    private BufferedImage getEmptyFontImage(int width, int height) {
        BufferedImage fontImage = this.grayScale ? new BufferedImage(width, height, 10) : new BufferedImage(width, height, 6);
        return fontImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getFontImage(int page) {
        if (!this.compressImage) {
            if (this.fontImageCache[page] != null) {
                return this.fontImageCache[page];
            }
        } else if (this.fontCompressedImageCache[page] != null) {
            byte[] gunzipBytes = FontUtils.gunzipBytes(this.fontCompressedImageCache[page]);
            BufferedImage image = this.grayScale ? FontUtils.getABGRImageFromGrayBytes(gunzipBytes) : FontUtils.getABGRImageFromABGRBytes(gunzipBytes);
            return image;
        }
        float scaleFactor = (float)this.fontRes / 16.0f;
        int border = FontUtils.getBorderWidth(this.fontRes, true);
        int imageWidth = (this.fontRes + border) * 16;
        BufferedImage fontImage = this.getEmptyFontImage(imageWidth, imageWidth);
        Graphics2D g2 = fontImage.createGraphics();
        if (this.grayScale) {
            FontUtils.clearGraphics2DGray(g2, 0, 0, imageWidth, imageWidth);
        } else {
            FontUtils.clearGraphics2D(g2, 0, 0, imageWidth, imageWidth);
        }
        BufferedImage chImage = this.getEmptyFontImage(this.fontRes + border - 2, this.fontRes + border - 2);
        Graphics2D g2ch = chImage.createGraphics();
        this.setAntiAlias(g2);
        this.setAntiAlias(g2ch);
        g2.setFont(this.secondaryFont);
        FontMetrics secondaryFontMetrics = g2.getFontMetrics();
        FontPixels secondaryFp = new FontPixels(this.secondaryFont, secondaryFontMetrics, this.antiAlias, this.fractionalMetrics);
        float secondaryBaseY = (float)secondaryFp.getAscent();
        float secondaryHeight = (float)secondaryFp.getHeight();
        g2.setFont(this.defaultFont);
        FontMetrics defaultFontMetrics = g2.getFontMetrics();
        FontPixels defaultFp = new FontPixels(this.defaultFont, defaultFontMetrics, this.antiAlias, this.fractionalMetrics);
        float defaultBaseY = (float)defaultFp.getAscent();
        float defaultHeight = (float)defaultFp.getHeight();
        g2.setFont(this.font);
        FontMetrics fm = g2.getFontMetrics();
        FontPixels fp = new FontPixels(this.font, fm, this.antiAlias, this.fractionalMetrics);
        float baseY = (float)fp.getAscent();
        float baseHeight = (float)fp.getHeight();
        int leftPos = 0;
        int startColumn = 0;
        int endColumn = 0;
        int originMargin = border / 2;
        float sizeAdjY = (float)(this.fontRes * CommonConfig.currentConfig.fontSizeAdjustment) * 0.05f / 2.0f;
        float fontGapAdjWidth = (float)(-this.fontGap) * (float)this.fontRes / 16.0f;
        int noFontCnt = 0;
        AffineTransform affinetransform = new AffineTransform();
        FontRenderContext frc = new FontRenderContext(affinetransform, this.antiAlias, this.fractionalMetrics);
        int chBase = page == 256 ? 0 : page << 8;
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                GlyphMetrics gm;
                float chWidth;
                float posY = baseY;
                float fontHeight = baseHeight;
                g2.setFont(this.font);
                char ch = page == 256 ? FontUtils.asciiSheetChars[y * 16 + x] : (char)(chBase + y * 16 + x);
                Font fontWork = this.font;
                if (!this.primaryFontAvailable || !this.font.canDisplay(ch)) {
                    if (this.secondaryFontAvailable && this.secondaryFont.canDisplay(ch)) {
                        g2.setFont(this.secondaryFont);
                        posY = secondaryBaseY;
                        fontHeight = secondaryHeight;
                        fontWork = this.secondaryFont;
                    } else {
                        g2.setFont(this.defaultFont);
                        posY = defaultBaseY;
                        fontHeight = defaultHeight;
                        fontWork = this.defaultFont;
                        if (!this.defaultFont.canDisplay(ch)) {
                            ++noFontCnt;
                        }
                    }
                }
                if ((chWidth = (gm = fontWork.createGlyphVector(frc, String.valueOf(ch)).getGlyphMetrics(0)).getAdvanceX()) != 0.0f) {
                    if ((chWidth -= fontGapAdjWidth) < 0.01f) {
                        chWidth = 0.01f;
                    }
                    leftPos = chWidth > 5.3333335f * scaleFactor ? 0 : this.fontRes / 2;
                    if (this.grayScale) {
                        FontUtils.clearGraphics2DGray(g2ch, 0, 0, this.fontRes + border - 2, this.fontRes + border - 2);
                    } else {
                        FontUtils.clearGraphics2D(g2ch, 0, 0, this.fontRes + border - 2, this.fontRes + border - 2);
                    }
                    g2ch.setFont(fontWork);
                    g2ch.drawString(String.valueOf(ch), (float)originMargin - 1.0f + (float)leftPos - (float)Math.round(fontGapAdjWidth / 2.0f - (this.fontRes == 8 ? 0.1f : 0.0f)), (float)originMargin - 1.0f + posY - sizeAdjY);
                    if (this.fontDouble == 1 && CharUtils.isAscii((char)ch) || this.fontDouble == 2 && !CharUtils.isAscii((char)ch) || this.fontDouble == 3) {
                        g2ch.drawString(String.valueOf(ch), (float)originMargin - 1.0f + (float)leftPos - (float)Math.round(fontGapAdjWidth / 2.0f - (this.fontRes == 8 ? 0.1f : 0.0f)), (float)originMargin - 1.0f + posY - sizeAdjY);
                    }
                    g2.drawImage((Image)chImage, (this.fontRes + border) * x + 1, (this.fontRes + border) * y + 1, null);
                    if (GlobalConfig.debug) {
                        g2.setColor(Color.lightGray);
                        g2.drawRect(leftPos + (this.fontRes + border) * x + originMargin, (this.fontRes + border) * y + originMargin - (int)sizeAdjY, (int)chWidth, this.fontRes + (int)(sizeAdjY * 2.0f));
                        g2.setColor(Color.RED);
                        g2.drawLine(leftPos + (this.fontRes + border) * x + originMargin, (int)(posY + (float)((this.fontRes + border) * y) + (float)originMargin - sizeAdjY), leftPos + (this.fontRes + border) * x + originMargin, (int)(posY + (float)((this.fontRes + border) * y) + (float)originMargin - sizeAdjY));
                        g2.setColor(Color.GREEN);
                        g2.drawLine(leftPos + (this.fontRes + border) * x + originMargin + (int)chWidth, (int)(posY + (float)((this.fontRes + border) * y) + (float)originMargin - sizeAdjY), leftPos + (this.fontRes + border) * x + originMargin + (int)chWidth, (int)(posY + (float)((this.fontRes + border) * y) + (float)originMargin - sizeAdjY));
                        g2.setColor(Color.WHITE);
                    }
                    startColumn = (int)((float)leftPos / scaleFactor);
                    endColumn = (int)(((float)leftPos + chWidth) / scaleFactor);
                    startColumn = startColumn < 0 ? 0 : startColumn;
                    endColumn = endColumn > 15 ? 15 : endColumn;
                    this.glyphWidthByte[ch] = (byte)(startColumn << 4 | endColumn & 0xF);
                    if (page == 256) {
                        this.charWidthFloat[y * 16 + x] = (chWidth / scaleFactor + 1.0f) / 2.0f + 1.0f;
                        this.charWidthInt[y * 16 + x] = (int)this.charWidthFloat[y * 16 + x];
                    }
                    this.glyphWidthFloat[ch] = chWidth / scaleFactor;
                    this.glyphBaselineGap[ch] = (float)Math.round(defaultBaseY - posY + (float)this.fontRes / 16.0f) * 8.0f / (float)this.fontRes;
                    if (ch != '1' && ch != 'I') continue;
                    int opacity = this.grayScale ? FontUtils.getTotalOpacityPosYGray(chImage, (int)(posY / 2.0f) + originMargin - 1) : FontUtils.getTotalOpacityPosY(chImage, (int)(posY / 2.0f) + originMargin - 1);
                    int estimatedBrightnessValue = FontUtils.getEstimatedBrightness(this.fontRes, opacity);
                    this.brightnessBoundaryScaleFactor = Math.max(this.brightnessBoundaryScaleFactor, FontUtils.getEstimatedBrightnessBoundaryScaleFactor(this.fontRes, opacity));
                    FontRasterizer fontRasterizer = this;
                    synchronized (fontRasterizer) {
                        this.autoBrightnessValue = Math.min(this.autoBrightnessValue, estimatedBrightnessValue);
                        if (CommonConfig.currentConfig.autoBrightness) {
                            CommonConfig.currentConfig.brightness = this.autoBrightnessValue;
                        }
                    }
                    Logger.debug("Auto-brightness for OS font = " + this.autoBrightnessValue + ", Boundary scaleFactor = " + this.brightnessBoundaryScaleFactor);
                    continue;
                }
                this.glyphWidthByte[ch] = 0;
                this.glyphWidthFloat[ch] = 0.0f;
                this.glyphBaselineGap[ch] = 0.0f;
                if (page != 256) continue;
                this.charWidthInt[y * 16 + x] = 0;
                this.charWidthFloat[y * 16 + x] = 0.0f;
            }
        }
        g2ch.dispose();
        g2.dispose();
        if (CommonConfig.currentConfig.enablePremultipliedAlpha) {
            fontImage = FontUtils.convertToPremultipliedAlpha(fontImage);
        }
        if (noFontCnt == 256) {
            fontImage = this.blankImage;
        }
        if (!this.compressImage) {
            this.fontImageCache[page] = fontImage;
            this.imageSize[page] = fontImage == this.blankImage ? 0 : FontUtils.getBytesFromImage(fontImage).length;
        } else {
            this.fontCompressedImageCache[page] = FontUtils.getBytesFromImage(fontImage);
            this.fontCompressedImageCache[page] = FontUtils.gzipBytes(this.fontCompressedImageCache[page]);
            this.imageSize[page] = this.fontCompressedImageCache[page].length;
        }
        Logger.debug("Font cache page-" + page + " was generated.[" + this.imageSize[page] / 1024 + "KB]" + (noFontCnt == 256 ? "(blank)" : ""));
        return fontImage;
    }

    private void setAntiAlias(Graphics2D g2) {
        if (this.antiAlias) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            if (this.fractionalMetrics) {
                g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            } else {
                g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            }
        } else {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        }
    }

    public void saveCharWidthOrig(int[] cw) {
        if (this.charWidthOrig == null) {
            int i;
            int totalCharWidth = 0;
            for (i = 0; i < cw.length; ++i) {
                totalCharWidth += cw[i];
            }
            if (totalCharWidth > 0) {
                this.charWidthOrig = new int[256];
                for (i = 0; i < cw.length; ++i) {
                    this.charWidthOrig[i] = cw[i];
                }
            }
        }
    }

    public void saveGlyphWidthOrig(byte[] gw) {
        if (this.glyphWidthOrig == null) {
            this.glyphWidthOrig = new byte[65536];
            for (int i = 0; i < gw.length; ++i) {
                this.glyphWidthOrig[i] = gw[i];
            }
        }
    }

    public void restoreGlyphWidthAll() {
        FontRendererHookList hookList = new FontRendererHookList(){

            @Override
            public boolean process(FontRendererHook frh) {
                if (!frh.disableAllFeatures && frh.changeFont) {
                    FontRasterizer.this.restoreCharWidth(frh);
                    FontRasterizer.this.restoreGlyphWidth(frh);
                    if (frh.optifineCharWidthFloat != null) {
                        FontRasterizer.this.restoreCharWidthFloat(frh);
                    }
                }
                return true;
            }
        };
        hookList.executeAll();
    }

    public void restoreCharWidth(FontRendererHook frh) {
        int i;
        if (this.charWidthOrig != null) {
            for (i = 0; i < 256; ++i) {
                if (this.charWidthOrig[i] != 0) continue;
                this.charWidthInt[i] = 0;
            }
        }
        if (frh.keepMcFontWidth) {
            return;
        }
        if (this.charWidthInt != null) {
            for (i = 0; i < 256; ++i) {
                frh.mcCharWidth[i] = this.charWidthInt[i];
            }
        }
    }

    public void restoreCharWidthFloat(FontRendererHook frh) {
        int i;
        if (this.charWidthOrig != null) {
            for (i = 0; i < 256; ++i) {
                if (this.charWidthOrig[i] != 0) continue;
                this.charWidthFloat[i] = 0.0f;
            }
        }
        if (frh.keepMcFontWidth) {
            return;
        }
        if (this.charWidthFloat != null) {
            for (i = 0; i < 256; ++i) {
                frh.optifineCharWidthFloat[i] = this.charWidthFloat[i];
            }
        }
    }

    public void restoreGlyphWidth(FontRendererHook frh) {
        int i;
        if (this.glyphWidthOrig != null) {
            for (i = 0; i < 65536; ++i) {
                if (this.glyphWidthOrig[i] != 0) continue;
                this.glyphWidthByte[i] = 0;
            }
        }
        if (frh.keepMcFontWidth) {
            return;
        }
        if (this.glyphWidthByte != null) {
            for (i = 0; i < 65536; ++i) {
                frh.fontRenderer.field_78287_e[i] = this.glyphWidthByte[i];
            }
        }
    }

    class CreateFontImageThread
    extends Thread {
        int codePage;

        private CreateFontImageThread(int page) {
            this.codePage = page;
        }

        @Override
        public void run() {
            FontRasterizer.this.getFontImage(this.codePage);
        }
    }
}

