/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont;

import bre.smoothfont.FontRasterizer;
import bre.smoothfont.FontTextureManager;
import bre.smoothfont.FontUtils;
import bre.smoothfont.config.CommonConfig;
import bre.smoothfont.config.GlobalConfig;
import bre.smoothfont.util.GLUtils;
import bre.smoothfont.util.Logger;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.TextureMetadataSection;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL30;

public class FontTexture
extends AbstractTexture {
    public int fontRes;
    public float borderWidthRate;
    public float blankSpaceRate;
    public int texFilterSetting;
    public boolean anisotropicFilterSetting;
    protected final ResourceLocation textureLocation;
    protected final int page;
    private FontTextureManager fontTextureManager;

    public FontTexture(ResourceLocation resourceLoc, int page) {
        this.textureLocation = resourceLoc;
        this.page = page;
        this.fontTextureManager = FontTextureManager.getInstance();
        this.fontRes = 0;
        this.borderWidthRate = 0.0f;
        this.blankSpaceRate = 0.0f;
        this.texFilterSetting = 0;
        this.anisotropicFilterSetting = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_110551_a(IResourceManager iResMgr) throws IOException {
        this.func_147631_c();
        IResource iresource = null;
        InputStream inputStream = null;
        try {
            BufferedImage borderedImage;
            boolean flagBlur = false;
            boolean flagClamp = false;
            if ("smoothfont".equals(this.textureLocation.func_110624_b())) {
                borderedImage = FontRasterizer.getInstance().getFontImage(this.page);
                if (borderedImage.getType() == 10) {
                    borderedImage = FontUtils.convertDataBufferGrayToABGR(borderedImage);
                }
                this.fontRes = FontTextureManager.getInstance().getUnicodeFontRes(true);
                int texBorderWidth = FontUtils.getBorderWidth(this.fontRes, true);
                this.borderWidthRate = (float)(texBorderWidth * 16) / (float)this.fontRes;
            } else {
                iresource = iResMgr.func_110536_a(this.textureLocation);
                inputStream = iresource.func_110527_b();
                BufferedImage bufferedimage = ImageIO.read(inputStream);
                borderedImage = this.addTextureBorder(bufferedimage);
                if (iresource.func_110528_c()) {
                    try {
                        TextureMetadataSection texturemetadatasection = (TextureMetadataSection)iresource.func_110526_a("texture");
                        if (texturemetadatasection != null) {
                            flagBlur = texturemetadatasection.func_110479_a();
                            flagClamp = texturemetadatasection.func_110480_b();
                        }
                    }
                    catch (RuntimeException runtimeexception) {
                        Logger.warn("Failed reading metadata of: " + this.textureLocation);
                    }
                }
            }
            float actualFontRes = this.fontRes;
            if (this.fontRes <= CommonConfig.currentConfig.blurReduction) {
                int scaleFactor = 2;
                borderedImage = FontUtils.resizeImageABGR(borderedImage, scaleFactor, false);
                actualFontRes = this.fontRes * scaleFactor;
            }
            if (CommonConfig.currentConfig.saveMemory >= 1 && this.fontRes >= 256 || CommonConfig.currentConfig.saveMemory >= 2 && this.fontRes >= 128) {
                float scaleFactor = (float)(this.fontRes * 16) / (float)borderedImage.getWidth();
                borderedImage = FontUtils.resizeImageABGR(borderedImage, scaleFactor, true);
                actualFontRes = (float)this.fontRes * scaleFactor;
            }
            this.blankSpaceRate = 0.0f;
            if (!CommonConfig.currentConfig.allowNPOTTexture && !FontUtils.isPOT(borderedImage.getWidth())) {
                int width = borderedImage.getWidth();
                int potWidth = FontUtils.nearPOT(width);
                this.blankSpaceRate = (float)(potWidth - width) * 16.0f / actualFontRes;
                borderedImage = FontUtils.expandFrame(borderedImage, potWidth, potWidth);
            }
            this.uploadTextureImageAllocate(this.func_110552_b(), borderedImage, flagBlur, flagClamp);
            Logger.debug("Loaded page-" + this.page + " texture " + borderedImage.getWidth() + "x" + borderedImage.getHeight());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private void uploadTextureImageAllocate(int textureId, BufferedImage texture, boolean blur, boolean clamp) {
        TextureUtil.func_147946_a((int)textureId, (int)CommonConfig.currentConfig.mipmapLevel, (int)texture.getWidth(), (int)texture.getHeight(), (float)1.0f);
        if (GlobalConfig.textureLoading == 1) {
            GLUtils.uploadTextureImage(textureId, texture, 0, 0, blur, clamp);
        } else {
            TextureUtil.func_110995_a((int)textureId, (BufferedImage)texture, (int)0, (int)0, (boolean)blur, (boolean)clamp);
        }
        GL30.glGenerateMipmap((int)3553);
    }

    protected BufferedImage addTextureBorder(BufferedImage origImg) {
        int textureSize;
        int width = origImg.getWidth();
        int height = origImg.getHeight();
        this.fontRes = width / 16;
        int texBorderWidth = FontUtils.getBorderWidth(this.fontRes, false);
        this.borderWidthRate = (float)(texBorderWidth * 16) / (float)this.fontRes;
        int newWidth = textureSize = (this.fontRes + texBorderWidth) * 16;
        int newHeight = textureSize;
        BufferedImage newImg = new BufferedImage(newWidth, newHeight, 6);
        Graphics2D g2 = newImg.createGraphics();
        FontUtils.clearGraphics2D(g2, 0, 0, newImg.getWidth(), newImg.getHeight());
        int originMargin = texBorderWidth / 2;
        if (origImg.getType() == 12) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    int alpha = origImg.getRGB(x, y) >>> 24;
                    if (alpha != 255) continue;
                    newImg.setRGB(x + x / this.fontRes * texBorderWidth + originMargin, y + y / this.fontRes * texBorderWidth + originMargin, -1);
                }
            }
        } else {
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    BufferedImage charImage = origImg.getSubimage(i * this.fontRes, j * this.fontRes, this.fontRes, this.fontRes);
                    g2.drawImage((Image)charImage, i * (this.fontRes + texBorderWidth) + originMargin, j * (this.fontRes + texBorderWidth) + originMargin, null);
                }
            }
        }
        g2.dispose();
        return newImg;
    }

    private int[][] generateMipmapData(BufferedImage texture, int level) {
        int width = texture.getWidth();
        int height = texture.getHeight();
        int[] aint = new int[width * height];
        Object mipmap = new int[level + 1][];
        texture.getRGB(0, 0, width, height, aint, 0, width);
        mipmap[0] = aint;
        mipmap = TextureUtil.func_147949_a((int)level, (int)width, (int[][])mipmap);
        return mipmap;
    }
}

