/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont.util;

import bre.smoothfont.compat.GlStateManager;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Hashtable;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class GLUtils {
    private static void setTextureBlur(boolean blur, boolean mipmap) {
        if (blur) {
            GlStateManager.glTexParameteri(3553, 10241, mipmap ? 9987 : 9729);
            GlStateManager.glTexParameteri(3553, 10240, 9729);
        } else {
            GlStateManager.glTexParameteri(3553, 10241, mipmap ? 9986 : 9728);
            GlStateManager.glTexParameteri(3553, 10240, 9728);
        }
    }

    private static void setTextureClamp(boolean clamp) {
        if (clamp) {
            GlStateManager.glTexParameteri(3553, 10242, 10496);
            GlStateManager.glTexParameteri(3553, 10243, 10496);
        } else {
            GlStateManager.glTexParameteri(3553, 10242, 10497);
            GlStateManager.glTexParameteri(3553, 10243, 10497);
        }
    }

    public static int uploadTextureImage(int textureId, BufferedImage image, int xOffset, int yOffset, boolean blur, boolean clamp) {
        GlStateManager.bindTexture(textureId);
        GLUtils.uploadTextureImage(image, xOffset, yOffset, blur, clamp);
        return textureId;
    }

    private static void uploadTextureImage(BufferedImage image, int xOffset, int yOffset, boolean blur, boolean clamp) {
        int width = image.getWidth();
        int height = image.getHeight();
        WritableRaster raster = Raster.createInterleavedRaster(0, width, height, 4, null);
        ColorModel colorModel = image.getColorModel();
        BufferedImage texImage = new BufferedImage(colorModel, raster, false, new Hashtable());
        DataBufferByte imageBuffer = (DataBufferByte)texImage.getRaster().getDataBuffer();
        ByteBuffer byteBuf = ByteBuffer.allocateDirect(imageBuffer.getSize());
        int[] bytes = new int[4];
        byteBuf.order(ByteOrder.nativeOrder());
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                image.getRaster().getPixel(x, y, bytes);
                byteBuf.put((byte)bytes[2]);
                byteBuf.put((byte)bytes[1]);
                byteBuf.put((byte)bytes[0]);
                byteBuf.put((byte)bytes[3]);
            }
        }
        byteBuf.flip();
        GLUtils.setTextureBlur(blur, false);
        GLUtils.setTextureClamp(clamp);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)xOffset, (int)yOffset, (int)width, (int)height, (int)32993, (int)5121, (ByteBuffer)byteBuf);
    }

    public static boolean checkAnisotropicFilterSupport() throws RuntimeException {
        ContextCapabilities capabilities = GLContext.getCapabilities();
        return capabilities.GL_EXT_texture_filter_anisotropic;
    }
}

