/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.tcbotaniaexoflame.core;

import de.matthiasmann.tcbotaniaexoflame.core.ObfSafeName;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;

public class PatchBlockCake
extends ClassVisitor
implements Opcodes {
    private String owner;
    private boolean hasComparatorSupport;
    private static final ObfSafeName hasComparatorInputOverride = new ObfSafeName("hasComparatorInputOverride", "func_149740_M");
    private static final ObfSafeName getComparatorInputOverride = new ObfSafeName("getComparatorInputOverride", "func_149736_g");
    private static final ObfSafeName getBlockMetadata = new ObfSafeName("getBlockMetadata", "func_72805_g");
    private static final ObfSafeName setBlockMetadataWithNotify = new ObfSafeName("setBlockMetadataWithNotify", "func_72921_c");

    public PatchBlockCake(ClassVisitor cv) {
        super(327680, cv);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.owner = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public void visitEnd() {
        if (!this.hasComparatorSupport) {
            MethodVisitor gv = this.cv.visitMethod(1, hasComparatorInputOverride.getName(), "()Z", null, null);
            gv.visitInsn(4);
            gv.visitInsn(172);
            gv.visitMaxs(2, 1);
            gv.visitEnd();
            gv = this.cv.visitMethod(1, getComparatorInputOverride.getName(), "(Lnet/minecraft/world/World;IIII)I", null, null);
            gv.visitIntInsn(16, 14);
            gv.visitVarInsn(25, 1);
            gv.visitVarInsn(21, 2);
            gv.visitVarInsn(21, 3);
            gv.visitVarInsn(21, 4);
            gv.visitMethodInsn(182, "net/minecraft/world/World", getBlockMetadata.getName(), "(III)I", false);
            gv.visitInsn(5);
            gv.visitInsn(104);
            gv.visitInsn(100);
            gv.visitIntInsn(16, 15);
            gv.visitInsn(126);
            gv.visitInsn(172);
            gv.visitMaxs(6, 1);
            gv.visitEnd();
        } else {
            LogManager.getLogger((String)"TCBotaniaExoflame").info("'BlockCake' already has Redstone Comparator support");
        }
        super.visitEnd();
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (hasComparatorInputOverride.matches(name) && "()Z".equals(desc) || getComparatorInputOverride.matches(name) && "(Lnet/minecraft/world/World;IIII)I".equals(desc)) {
            this.hasComparatorSupport = true;
        }
        if ("func_150036_b".equals(name) && "(Lnet/minecraft/world/World;IIILnet/minecraft/entity/player/EntityPlayer;)V".equals(desc)) {
            LogManager.getLogger((String)"TCBotaniaExoflame").info("Trying to patch 'eatCake' method");
            return new EatCakeMethodPatcher(this.cv, access, name, desc, signature, exceptions);
        }
        return this.cv.visitMethod(access, name, desc, signature, exceptions);
    }

    static class EatCakeMethodPatcher
    extends MethodNode
    implements Opcodes {
        private final ClassVisitor cv;

        EatCakeMethodPatcher(ClassVisitor cv, int access, String name, String desc, String signature, String[] exceptions) {
            super(327680, access, name, desc, signature, exceptions);
            this.cv = cv;
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            AbstractInsnNode last;
            if (setBlockMetadataWithNotify.matches(name) && "(IIIII)Z".equals(desc) && (last = this.instructions.getLast()) != null && last.getOpcode() == 5) {
                this.instructions.set(last, (AbstractInsnNode)new InsnNode(6));
                LogManager.getLogger((String)"TCBotaniaExoflame").info("patched flags for setBlockMetadataWithNotify call");
            }
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }

        public void visitEnd() {
            super.visitEnd();
            this.accept(this.cv);
        }
    }
}

