/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.tcbotaniaexoflame.core;

import de.matthiasmann.tcbotaniaexoflame.core.ObfSafeName;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class PatchTileResearchTable
extends ClassVisitor
implements Opcodes {
    private String owner;
    private static final ObfSafeName bookshelf = new ObfSafeName("bookshelf", "field_150342_X");

    public PatchTileResearchTable(ClassVisitor cv) {
        super(327680, cv);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.owner = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ("recalculateBonus".equals(name) && "()V".equals(desc)) {
            LogManager.getLogger((String)"TCBotaniaExoflame").info("Trying to patch 'recalculateBonus' method");
            return new RecalcBonusPatcher(this.cv, access, name, desc, signature, exceptions);
        }
        return this.cv.visitMethod(access, name, desc, signature, exceptions);
    }

    static class RecalcBonusPatcher
    extends MethodNode
    implements Opcodes {
        private final ClassVisitor cv;

        RecalcBonusPatcher(ClassVisitor cv, int access, String name, String desc, String signature, String[] exceptions) {
            super(327680, access, name, desc, signature, exceptions);
            this.cv = cv;
        }

        public void visitJumpInsn(int opcode, Label label) {
            AbstractInsnNode last = this.instructions.getLast();
            if (opcode == 166 && last != null && last.getOpcode() == 178) {
                FieldInsnNode lastFIN = (FieldInsnNode)last;
                if (bookshelf.matches(lastFIN.name) && "net/minecraft/init/Blocks".equals(lastFIN.owner)) {
                    this.instructions.set(last, (AbstractInsnNode)new MethodInsnNode(184, "de/matthiasmann/tcbotaniaexoflame/helper/Callouts", "isBookshelf", "(Lnet/minecraft/block/Block;)Z", false));
                    opcode = 153;
                    LogManager.getLogger((String)"TCBotaniaExoflame").info("patched check for BlockBookshelf");
                }
            }
            super.visitJumpInsn(opcode, label);
        }

        public void visitEnd() {
            super.visitEnd();
            this.accept(this.cv);
        }
    }
}

