/*
 * Decompiled with CFR 0.152.
 */
package darkevilmac.archimedes.common.entity;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import darkevilmac.archimedes.ArchimedesShipMod;
import darkevilmac.archimedes.client.control.ShipControllerClient;
import darkevilmac.archimedes.common.control.ShipControllerCommon;
import darkevilmac.archimedes.common.entity.EntityParachute;
import darkevilmac.archimedes.common.entity.EntitySeat;
import darkevilmac.archimedes.common.entity.ShipAssemblyInteractor;
import darkevilmac.archimedes.common.entity.ShipCapabilities;
import darkevilmac.archimedes.common.entity.ShipHandlerClient;
import darkevilmac.archimedes.common.entity.ShipHandlerServer;
import darkevilmac.archimedes.common.object.block.AnchorPointLocation;
import darkevilmac.archimedes.common.tileentity.TileEntityEngine;
import darkevilmac.archimedes.common.tileentity.TileEntityHelm;
import darkevilmac.movingworld.common.chunk.assembly.AssembleResult;
import darkevilmac.movingworld.common.chunk.assembly.ChunkDisassembler;
import darkevilmac.movingworld.common.chunk.assembly.MovingWorldAssemblyInteractor;
import darkevilmac.movingworld.common.entity.EntityMovingWorld;
import darkevilmac.movingworld.common.entity.MovingWorldCapabilities;
import darkevilmac.movingworld.common.entity.MovingWorldHandlerCommon;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;

public class EntityShip
extends EntityMovingWorld {
    public static final float BASE_FORWARD_SPEED = 0.005f;
    public static final float BASE_TURN_SPEED = 0.5f;
    public static final float BASE_LIFT_SPEED = 0.004f;
    public ShipCapabilities capabilities = new ShipCapabilities(this, true);
    private ShipControllerCommon controller;
    private MovingWorldHandlerCommon handler;
    private ShipAssemblyInteractor shipAssemblyInteractor;
    private boolean submerge;

    public EntityShip(World world) {
        super(world);
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.field_70170_p != null) {
            if (!this.field_70170_p.field_72995_K) {
                boolean hasEngines = false;
                if (this.capabilities.getEngines() != null) {
                    if (this.capabilities.getEngines().isEmpty()) {
                        hasEngines = false;
                    } else {
                        boolean bl = hasEngines = this.capabilities.getEnginePower() > 0.0f;
                    }
                }
                if (ArchimedesShipMod.instance.modConfig.enginesMandatory) {
                    this.func_70096_w().func_75692_b(28, (Object)new Byte(hasEngines ? (byte)1 : 0));
                } else {
                    this.func_70096_w().func_75692_b(28, (Object)new Byte(1));
                }
            } else if (this.field_70180_af != null && !this.field_70180_af.func_92085_d() && this.field_70180_af.func_75684_a()) {
                this.submerge = this.field_70180_af.func_75683_a(26) == new Byte(1).byteValue();
            }
        }
    }

    public boolean getSubmerge() {
        return !this.field_70180_af.func_92085_d() ? this.field_70180_af.func_75683_a(26) == 1 : false;
    }

    public void setSubmerge(boolean submerge) {
        this.submerge = submerge;
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(26, (Object)(submerge ? new Byte(1) : new Byte(0)));
            if (this.getMobileChunk().marker != null && this.getMobileChunk().marker.tileEntity != null && this.getMobileChunk().marker.tileEntity instanceof TileEntityHelm) {
                TileEntityHelm helm = (TileEntityHelm)this.getMobileChunk().marker.tileEntity;
                helm.submerge = submerge;
            }
        }
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return entity instanceof EntitySeat || entity.field_70154_o instanceof EntitySeat || entity instanceof EntityLiving ? null : entity.field_70121_D;
    }

    public int getBelowWater() {
        int belowWater;
        int b0 = 5;
        int blocksPerMeter = (int)((double)b0 * (this.func_70046_E().field_72337_e - this.func_70046_E().field_72338_b));
        AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        for (belowWater = 0; belowWater < blocksPerMeter; ++belowWater) {
            double d1 = this.func_70046_E().field_72338_b + (this.func_70046_E().field_72337_e - this.func_70046_E().field_72338_b) * (double)belowWater / (double)blocksPerMeter;
            double d2 = this.func_70046_E().field_72338_b + (this.func_70046_E().field_72337_e - this.func_70046_E().field_72338_b) * (double)(belowWater + 1) / (double)blocksPerMeter;
            axisalignedbb.func_72324_b(this.field_70121_D.field_72340_a, d1, this.field_70121_D.field_72339_c, this.field_70121_D.field_72336_d, d2, this.field_70121_D.field_72334_f);
            if (!EntityShip.isAABBInLiquidNotFall((World)this.field_70170_p, (AxisAlignedBB)axisalignedbb)) break;
        }
        return belowWater;
    }

    public boolean areSubmerged() {
        int belowWater = this.getBelowWater();
        return this.getSubmerge() && belowWater > 0;
    }

    public boolean isFlying() {
        return this.capabilities.canFly() && (this.isFlying || this.controller.getShipControl() == 2) || this.getSubmerge();
    }

    public MovingWorldHandlerCommon getHandler() {
        if (this.handler == null) {
            if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
                this.handler = new ShipHandlerClient(this);
                this.handler.setMovingWorld((EntityMovingWorld)this);
            } else {
                this.handler = new ShipHandlerServer(this);
                this.handler.setMovingWorld((EntityMovingWorld)this);
            }
        }
        return this.handler;
    }

    public void initMovingWorld() {
        this.getCapabilities();
        this.field_70180_af.func_75682_a(29, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(28, (Object)new Byte(0));
        this.field_70180_af.func_75682_a(27, (Object)new Byte(0));
        this.field_70180_af.func_75682_a(26, (Object)new Byte(0));
    }

    @SideOnly(value=Side.CLIENT)
    public void initMovingWorldClient() {
        this.handler = new ShipHandlerClient(this);
        this.controller = new ShipControllerClient();
    }

    public void initMovingWorldCommon() {
        this.handler = new ShipHandlerServer(this);
        this.controller = new ShipControllerCommon();
    }

    public MovingWorldCapabilities getCapabilities() {
        return this.capabilities == null ? new ShipCapabilities(this, true) : this.capabilities;
    }

    public void setCapabilities(MovingWorldCapabilities capabilities) {
        if (capabilities != null && capabilities instanceof ShipCapabilities) {
            this.capabilities = (ShipCapabilities)capabilities;
        }
    }

    public boolean alignToAnchor() {
        if (this.capabilities.findClosestValidAnchor(16) != null) {
            AnchorPointLocation anchorPointLocation = this.capabilities.findClosestValidAnchor(16);
            ChunkPosition chunkAnchorPos = anchorPointLocation.shipAnchor.coords;
            ChunkPosition worldAnchorPos = anchorPointLocation.worldAnchor.coords;
            Vec3 worldPosForAnchor = Vec3.func_72443_a((double)worldAnchorPos.field_151329_a, (double)(worldAnchorPos.field_151327_b + 2), (double)worldAnchorPos.field_151328_c);
            worldPosForAnchor = worldPosForAnchor.func_72441_c((double)this.getMobileChunk().getCenterX(), (double)this.getMobileChunk().minY(), (double)this.getMobileChunk().getCenterZ());
            worldPosForAnchor = Vec3.func_72443_a((double)(worldPosForAnchor.field_72450_a - (double)chunkAnchorPos.field_151329_a), (double)worldPosForAnchor.field_72448_b, (double)(worldPosForAnchor.field_72449_c - (double)chunkAnchorPos.field_151328_c));
            this.func_70107_b(worldPosForAnchor.field_72450_a, worldPosForAnchor.field_72448_b, worldPosForAnchor.field_72449_c);
        }
        this.alignToGrid();
        return false;
    }

    public boolean isBraking() {
        return this.controller.getShipControl() == 3;
    }

    public MovingWorldAssemblyInteractor getNewAssemblyInteractor() {
        return new ShipAssemblyInteractor();
    }

    public void writeMovingWorldNBT(NBTTagCompound compound) {
        compound.func_74757_a("submerge", this.submerge);
    }

    public void readMovingWorldNBT(NBTTagCompound compound) {
        this.setSubmerge(compound.func_74767_n("submerge"));
    }

    public void writeMovingWorldSpawnData(ByteBuf data) {
    }

    public void handleControl(double horizontalVelocity) {
        this.capabilities.updateEngines();
        if (this.field_70153_n == null && this.prevRiddenByEntity != null) {
            EntityParachute parachute;
            if (ArchimedesShipMod.instance.modConfig.disassembleOnDismount) {
                this.alignToAnchor();
                this.updateRiderPosition(this.prevRiddenByEntity, this.riderDestinationX, this.riderDestinationY, this.riderDestinationZ, 1);
                this.disassemble(false);
            } else if (!this.field_70170_p.field_72995_K && this.isFlying() && this.field_70170_p.func_72838_d((Entity)(parachute = new EntityParachute(this.field_70170_p, this, this.riderDestinationX, this.riderDestinationY, this.riderDestinationZ)))) {
                this.prevRiddenByEntity.func_70078_a((Entity)parachute);
                this.prevRiddenByEntity.func_70095_a(false);
            }
            this.prevRiddenByEntity = null;
        }
        if (this.field_70153_n == null || !this.capabilities.canMove()) {
            if (this.isFlying()) {
                this.field_70181_x -= 8.00000037997961E-4;
            }
        } else {
            this.handlePlayerControl();
            this.prevRiddenByEntity = this.field_70153_n;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(double horvel) {
        if (this.capabilities.getEngines() != null) {
            Vec3 vec = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
            float yaw = (float)Math.toRadians(this.field_70177_z);
            for (TileEntityEngine engine : this.capabilities.getEngines()) {
                if (!engine.isRunning()) continue;
                vec.field_72450_a = (float)engine.field_145851_c - this.getMovingWorldChunk().getCenterX() + 0.5f;
                vec.field_72448_b = engine.field_145848_d;
                vec.field_72449_c = (float)engine.field_145849_e - this.getMovingWorldChunk().getCenterZ() + 0.5f;
                vec.func_72442_b(yaw);
                this.field_70170_p.func_72869_a("smoke", this.field_70165_t + vec.field_72450_a, this.field_70163_u + vec.field_72448_b + 1.0, this.field_70161_v + vec.field_72449_c, 0.0, 0.0, 0.0);
            }
        }
    }

    public void handleServerUpdate(double horizontalVelocity) {
        int belowWater;
        boolean submergeMode = this.getSubmerge();
        int b0 = 5;
        int blocksPerMeter = (int)((double)b0 * (this.func_70046_E().field_72337_e - this.func_70046_E().field_72338_b));
        float waterVolume = 0.0f;
        AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        for (belowWater = 0; belowWater < blocksPerMeter; ++belowWater) {
            double d1 = this.func_70046_E().field_72338_b + (this.func_70046_E().field_72337_e - this.func_70046_E().field_72338_b) * (double)belowWater / (double)blocksPerMeter;
            double d2 = this.func_70046_E().field_72338_b + (this.func_70046_E().field_72337_e - this.func_70046_E().field_72338_b) * (double)(belowWater + 1) / (double)blocksPerMeter;
            axisalignedbb.func_72324_b(this.func_70046_E().field_72340_a, d1, this.func_70046_E().field_72339_c, this.func_70046_E().field_72336_d, d2, this.func_70046_E().field_72334_f);
            if (!EntityShip.isAABBInLiquidNotFall((World)this.field_70170_p, (AxisAlignedBB)axisalignedbb)) break;
        }
        if (belowWater > 0 && this.layeredBlockVolumeCount != null) {
            int k = belowWater / b0;
            for (int y = 0; y <= k && y < this.layeredBlockVolumeCount.length; ++y) {
                if (y == k) {
                    waterVolume += (float)(this.layeredBlockVolumeCount[y] * (belowWater % b0)) * 1.0f / (float)b0;
                    continue;
                }
                waterVolume += (float)this.layeredBlockVolumeCount[y] * 1.0f;
            }
        }
        if (this.field_70122_E) {
            this.isFlying = false;
        }
        float gravity = 0.05f;
        if (waterVolume > 0.0f && !submergeMode) {
            this.isFlying = false;
            float buoyancyforce = 1.0f * waterVolume * gravity;
            float mass = this.getCapabilities().getMass();
            this.field_70181_x += (double)(buoyancyforce / mass);
        }
        if (!this.isFlying() || submergeMode && belowWater <= this.getMobileChunk().maxY() * 5 / 3 * 2) {
            this.field_70181_x -= (double)gravity;
        }
        super.handleServerUpdate(horizontalVelocity);
    }

    public void handleServerUpdatePreRotation() {
        if (ArchimedesShipMod.instance.modConfig.shipControlType == 0) {
            double maxyawspeed;
            double deltayaw;
            double newyaw = this.field_70177_z;
            double dx = this.field_70169_q - this.field_70165_t;
            double dz = this.field_70166_s - this.field_70161_v;
            if (this.field_70153_n != null && !this.isBraking() && dx * dx + dz * dz > 0.01) {
                newyaw = 270.0 - Math.toDegrees(Math.atan2(dz, dx)) + (double)((float)this.frontDirection * 90.0f);
            }
            if ((deltayaw = MathHelper.func_76138_g((double)(newyaw - (double)this.field_70177_z))) > (maxyawspeed = 2.0)) {
                deltayaw = maxyawspeed;
            }
            if (deltayaw < -maxyawspeed) {
                deltayaw = -maxyawspeed;
            }
            this.field_70177_z = (float)((double)this.field_70177_z + deltayaw);
        }
    }

    public void updateRiderPosition(Entity entity, int x, int y, int z, int flags) {
        super.updateRiderPosition(entity, x, y, z, flags);
        if (this.submerge && entity != null && entity instanceof EntityLivingBase && this.field_70170_p != null && !this.field_70170_p.field_72995_K && !((EntityLivingBase)entity).func_70644_a(Potion.field_76427_o)) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76427_o.field_76415_H, 20, 1));
        }
    }

    public boolean disassemble(boolean overwrite) {
        TileEntity te;
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        this.alignToGrid();
        this.func_70043_V();
        ChunkDisassembler disassembler = this.getDisassembler();
        disassembler.overwrite = overwrite;
        if (!disassembler.canDisassemble(this.getNewAssemblyInteractor())) {
            if (this.prevRiddenByEntity instanceof EntityPlayer) {
                ChatComponentText c = new ChatComponentText("Cannot disassemble ship here");
                ((EntityPlayer)this.prevRiddenByEntity).func_145747_a((IChatComponent)c);
            }
            return false;
        }
        AssembleResult result = disassembler.doDisassemble(this.getNewAssemblyInteractor());
        if (result.getShipMarker() != null && (te = result.getShipMarker().tileEntity) instanceof TileEntityHelm) {
            ((TileEntityHelm)te).setAssembleResult(result);
            ((TileEntityHelm)te).setInfo(this.getInfo());
        }
        return true;
    }

    private void handlePlayerControl() {
        if (this.field_70153_n instanceof EntityLivingBase && ((ShipCapabilities)this.getCapabilities()).canMove()) {
            double throttle = ((EntityLivingBase)this.field_70153_n).field_70701_bs;
            if (this.isFlying()) {
                throttle *= 0.5;
            }
            if (ArchimedesShipMod.instance.modConfig.shipControlType == 1) {
                Vec3 vec = Vec3.func_72443_a((double)this.field_70153_n.field_70159_w, (double)0.0, (double)this.field_70153_n.field_70179_y);
                vec.func_72442_b((float)Math.toRadians(this.field_70153_n.field_70177_z));
                double steer = ((EntityLivingBase)this.field_70153_n).field_70702_br;
                this.motionYaw = (float)((double)this.motionYaw + steer * 0.5 * (double)this.capabilities.getRotationMult() * (double)ArchimedesShipMod.instance.modConfig.turnSpeed);
                float yaw = (float)Math.toRadians(180.0f - this.field_70177_z + (float)this.frontDirection * 90.0f);
                vec.field_72450_a = this.field_70159_w;
                vec.field_72449_c = this.field_70179_y;
                vec.func_72442_b(yaw);
                vec.field_72450_a *= 0.9;
                vec.field_72449_c -= throttle * (double)0.005f * (double)this.capabilities.getSpeedMult();
                vec.func_72442_b(-yaw);
                this.field_70159_w = vec.field_72450_a;
                this.field_70179_y = vec.field_72449_c;
            } else if (ArchimedesShipMod.instance.modConfig.shipControlType == 0 && throttle > 0.0) {
                double dsin = -Math.sin(Math.toRadians(this.field_70153_n.field_70177_z));
                double dcos = Math.cos(Math.toRadians(this.field_70153_n.field_70177_z));
                this.field_70159_w += dsin * (double)0.005f * (double)this.capabilities.speedMultiplier;
                this.field_70179_y += dcos * (double)0.005f * (double)this.capabilities.speedMultiplier;
            }
        }
        if (this.controller.getShipControl() != 0) {
            if (this.controller.getShipControl() == 4) {
                this.alignToAnchor();
            } else if (this.isBraking()) {
                this.field_70159_w *= (double)this.capabilities.brakeMult;
                this.field_70179_y *= (double)this.capabilities.brakeMult;
                if (this.isFlying()) {
                    this.field_70181_x *= (double)this.capabilities.brakeMult;
                }
            } else if (this.controller.getShipControl() < 3 && this.capabilities.canFly()) {
                int i;
                if (this.controller.getShipControl() == 2) {
                    this.isFlying = true;
                    i = 1;
                } else {
                    i = -1;
                }
                this.field_70181_x += (double)((float)i * 0.004f * this.capabilities.getLiftMult());
            }
        }
    }

    public void readMovingWorldSpawnData(ByteBuf data) {
    }

    public float getXRenderScale() {
        return 1.000001f;
    }

    public float getYRenderScale() {
        return 1.000001f;
    }

    public float getZRenderScale() {
        return 1.000001f;
    }

    public MovingWorldAssemblyInteractor getAssemblyInteractor() {
        return this.shipAssemblyInteractor;
    }

    public void setAssemblyInteractor(MovingWorldAssemblyInteractor interactor) {
    }

    public void fillAirBlocks(Set<ChunkPosition> set, int x, int y, int z) {
        super.fillAirBlocks(set, x, y, z);
    }

    public ShipControllerCommon getController() {
        return this.controller;
    }

    public boolean canSubmerge() {
        return !this.field_70180_af.func_92085_d() ? this.field_70180_af.func_75683_a(27) == new Byte(1).byteValue() : false;
    }
}

