/*
 * Decompiled with CFR 0.152.
 */
package darkevilmac.archimedes.common.entity;

import darkevilmac.archimedes.ArchimedesShipMod;
import darkevilmac.archimedes.common.entity.EntitySeat;
import darkevilmac.archimedes.common.entity.EntityShip;
import darkevilmac.archimedes.common.object.ArchimedesObjects;
import darkevilmac.archimedes.common.object.block.AnchorPointLocation;
import darkevilmac.archimedes.common.tileentity.TileEntityAnchorPoint;
import darkevilmac.archimedes.common.tileentity.TileEntityEngine;
import darkevilmac.archimedes.common.tileentity.TileEntityHelm;
import darkevilmac.movingworld.common.chunk.LocatedBlock;
import darkevilmac.movingworld.common.entity.EntityMovingWorld;
import darkevilmac.movingworld.common.entity.MovingWorldCapabilities;
import darkevilmac.movingworld.common.util.FloodFiller;
import darkevilmac.movingworld.common.util.LocatedBlockList;
import darkevilmac.movingworld.common.util.MaterialDensity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;

public class ShipCapabilities
extends MovingWorldCapabilities {
    private final EntityShip ship;
    public float speedMultiplier;
    public float rotationMultiplier;
    public float liftMultiplier;
    public float brakeMult;
    private List<LocatedBlock> anchorPoints;
    private List<EntitySeat> seats;
    private List<TileEntityEngine> engines;
    private int balloonCount;
    private int floaters;
    private int blockCount;
    private int nonAirBlockCount;
    private float mass;
    private boolean canSubmerge = false;
    private boolean submerseFound = false;

    public ShipCapabilities(EntityMovingWorld movingWorld, boolean autoCalcMass) {
        super(movingWorld, autoCalcMass);
        this.ship = (EntityShip)movingWorld;
    }

    public float getSpeedMult() {
        return this.speedMultiplier + this.getEnginePower() * 0.5f;
    }

    public float getRotationMult() {
        return this.rotationMultiplier + this.getEnginePower() * 0.25f;
    }

    public float getLiftMult() {
        return this.liftMultiplier + this.getEnginePower() * 0.5f;
    }

    public float getEnginePower() {
        return this.ship.func_70096_w().func_111145_d(29);
    }

    public AnchorPointLocation findClosestValidAnchor(int range) {
        if (this.ship != null && this.ship.field_70170_p != null && !this.ship.field_70170_p.field_72995_K && this.anchorPoints != null) {
            AnchorPointLocation apLoc = new AnchorPointLocation(null, null);
            ArrayList<AnchorPointLocation> validAnchorPoints = new ArrayList<AnchorPointLocation>();
            ArrayList<Integer> validAnchorPointsDistance = new ArrayList<Integer>();
            for (LocatedBlock anchorPointLB : this.anchorPoints) {
                int i;
                TileEntityAnchorPoint.AnchorPointInfo anchorPointInfo = ((TileEntityAnchorPoint)anchorPointLB.tileEntity).anchorPointInfo;
                int infoPosX = anchorPointInfo.x;
                int infoPosY = anchorPointInfo.y;
                int infoPosZ = anchorPointInfo.z;
                int differenceX = 0;
                int differenceY = 0;
                int differenceZ = 0;
                boolean validXDistance = false;
                boolean validYDistance = false;
                boolean validZDistance = false;
                boolean validDistance = false;
                if ((double)infoPosX > this.ship.field_70165_t) {
                    for (i = 1; i < range; ++i) {
                        if (!(this.ship.field_70165_t + (double)i >= (double)infoPosX)) continue;
                        validXDistance = true;
                        differenceX = i;
                    }
                } else {
                    for (i = 1; i < range; ++i) {
                        if (!((double)(infoPosX + i) >= this.ship.field_70165_t)) continue;
                        validXDistance = true;
                        differenceX = i;
                    }
                }
                if ((double)infoPosY > this.ship.field_70163_u) {
                    for (i = 1; i < range; ++i) {
                        if (!(this.ship.field_70163_u + (double)i >= (double)infoPosY)) continue;
                        validYDistance = true;
                        differenceY = i;
                    }
                } else {
                    for (i = 1; i < range; ++i) {
                        if (!((double)(infoPosY + i) >= this.ship.field_70163_u)) continue;
                        validYDistance = true;
                        differenceY = i;
                    }
                }
                if ((double)infoPosZ > this.ship.field_70161_v) {
                    for (i = 1; i < range; ++i) {
                        if (!(this.ship.field_70161_v + (double)i >= (double)infoPosZ)) continue;
                        validZDistance = true;
                        differenceZ = i;
                    }
                } else {
                    for (i = 1; i < range; ++i) {
                        if (!((double)(infoPosZ + i) >= this.ship.field_70161_v)) continue;
                        validZDistance = true;
                        differenceZ = i;
                    }
                }
                if (!(validDistance = validXDistance && validYDistance && validZDistance) || this.ship.field_70170_p.func_147438_o(infoPosX, infoPosY, infoPosZ) == null || !(this.ship.field_70170_p.func_147438_o(infoPosX, infoPosY, infoPosZ) instanceof TileEntityAnchorPoint)) continue;
                TileEntityAnchorPoint anchorPoint = (TileEntityAnchorPoint)this.ship.field_70170_p.func_147438_o(infoPosX, infoPosY, infoPosZ);
                if (anchorPoint.anchorPointInfo == null || anchorPoint.anchorPointInfo.forShip) continue;
                AnchorPointLocation anchorPointLocation = new AnchorPointLocation(null, null);
                World anchorPointWorld = anchorPoint.func_145831_w();
                ChunkPosition anchorPointCoords = new ChunkPosition(anchorPoint.field_145851_c, anchorPoint.field_145848_d, anchorPoint.field_145849_e);
                anchorPointLocation.worldAnchor = new LocatedBlock(anchorPointWorld.func_147439_a(anchorPointCoords.field_151329_a, anchorPointCoords.field_151327_b, anchorPointCoords.field_151328_c), anchorPointWorld.func_72805_g(anchorPointCoords.field_151329_a, anchorPointCoords.field_151327_b, anchorPointCoords.field_151328_c), anchorPointCoords);
                anchorPointLocation.shipAnchor = anchorPointLB;
                validAnchorPoints.add(anchorPointLocation);
                validAnchorPointsDistance.add(differenceX + differenceY + differenceZ);
            }
            AnchorPointLocation shortestAnchorLocation = null;
            if (validAnchorPoints != null && !validAnchorPoints.isEmpty()) {
                int shortestIndex = 0;
                for (int index = 0; index < validAnchorPoints.size(); ++index) {
                    if ((Integer)validAnchorPointsDistance.get(index) >= (Integer)validAnchorPointsDistance.get(shortestIndex)) continue;
                    shortestIndex = index;
                }
                shortestAnchorLocation = (AnchorPointLocation)validAnchorPoints.get(shortestIndex);
            }
            return shortestAnchorLocation;
        }
        return null;
    }

    public void updateEngines() {
        float ePower = 0.0f;
        if (this.engines != null) {
            for (TileEntityEngine te : this.engines) {
                te.updateRunning();
                if (!te.isRunning()) continue;
                ePower += te.enginePower;
            }
        }
        if (!this.ship.field_70170_p.field_72995_K) {
            this.ship.func_70096_w().func_75692_b(29, (Object)Float.valueOf(ePower));
        }
    }

    public boolean canFly() {
        return ArchimedesShipMod.instance.modConfig.enableAirShips && (float)this.getBalloonCount() >= (float)this.blockCount * ArchimedesShipMod.instance.modConfig.flyBalloonRatio || this.ship.areSubmerged();
    }

    public boolean canSubmerge() {
        if (!this.submerseFound) {
            FloodFiller floodFiller = new FloodFiller();
            LocatedBlockList filledBlocks = floodFiller.floodFillMobileChunk(this.ship.getMobileChunk());
            int filledBlockCount = filledBlocks.size();
            this.canSubmerge = false;
            if (ArchimedesShipMod.instance.modConfig.enableSubmersibles) {
                this.canSubmerge = (float)filledBlockCount < (float)this.nonAirBlockCount * ArchimedesShipMod.instance.modConfig.submersibleFillRatio;
            }
            this.submerseFound = true;
        }
        return this.canSubmerge;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public int getBalloonCount() {
        return this.balloonCount;
    }

    public void setBalloonCount(int balloonCount) {
        this.balloonCount = balloonCount;
    }

    public int getFloaterCount() {
        return this.floaters;
    }

    public float getMass() {
        return this.mass;
    }

    public void setMass(float mass) {
        this.mass = mass;
    }

    public void addAttachments(EntitySeat entity) {
        if (this.seats == null) {
            this.seats = new ArrayList<EntitySeat>();
        }
        if (entity != null && entity instanceof EntitySeat) {
            this.seats.add(entity);
        }
    }

    public boolean canMove() {
        return this.ship.func_70096_w().func_75683_a(28) == 1;
    }

    public List<EntitySeat> getAttachments() {
        return this.seats;
    }

    public List<TileEntityEngine> getEngines() {
        return this.engines;
    }

    public List<LocatedBlock> getAnchorPoints() {
        return this.anchorPoints;
    }

    public void postBlockAdding() {
        if (this.ship.getMobileChunk() != null && this.ship.getMobileChunk().marker != null && this.ship.getMobileChunk().marker.tileEntity != null && this.ship.getMobileChunk().marker.tileEntity instanceof TileEntityHelm && ((TileEntityHelm)this.ship.getMobileChunk().marker.tileEntity).submerge && this.canSubmerge()) {
            this.ship.setSubmerge(true);
        }
    }

    public void onChunkBlockAdded(Block block, int metadata, int x, int y, int z) {
        this.mass += MaterialDensity.getDensity((Block)block);
        ++this.blockCount;
        ++this.nonAirBlockCount;
        if (block != null && block == ArchimedesObjects.blockFloater) {
            --this.nonAirBlockCount;
            return;
        }
        if (block instanceof BlockAir) {
            --this.nonAirBlockCount;
        }
        if (block == ArchimedesObjects.blockBalloon) {
            ++this.balloonCount;
        } else if (block == ArchimedesObjects.blockFloater) {
            ++this.floaters;
        } else if (block == ArchimedesObjects.blockAnchorPoint) {
            TileEntity te = this.ship.getMobileChunk().func_147438_o(x, y, z);
            if (te != null && te instanceof TileEntityAnchorPoint && ((TileEntityAnchorPoint)te).anchorPointInfo != null && ((TileEntityAnchorPoint)te).anchorPointInfo.forShip) {
                if (this.anchorPoints == null) {
                    this.anchorPoints = new ArrayList<LocatedBlock>();
                }
                this.anchorPoints.add(new LocatedBlock(block, metadata, te, new ChunkPosition(x, y, z), new ChunkPosition(0, 0, 0)));
            }
        } else if (block == ArchimedesObjects.blockEngine) {
            TileEntity te = this.ship.getMovingWorldChunk().func_147438_o(x, y, z);
            if (te instanceof TileEntityEngine) {
                if (this.engines == null) {
                    this.engines = new ArrayList<TileEntityEngine>(4);
                }
                this.engines.add((TileEntityEngine)te);
            }
        } else if ((block == ArchimedesObjects.blockSeat || ArchimedesShipMod.instance.modConfig.seats.contains(block)) && !this.ship.field_70170_p.field_72995_K) {
            int x1 = this.ship.riderDestinationX;
            int y1 = this.ship.riderDestinationY;
            int z1 = this.ship.riderDestinationZ;
            if (this.ship.frontDirection == 0) {
                --z1;
            } else if (this.ship.frontDirection == 1) {
                ++x1;
            } else if (this.ship.frontDirection == 2) {
                ++z1;
            } else if (this.ship.frontDirection == 3) {
                --x1;
            }
            if (x != x1 || y != y1 || z != z1) {
                EntitySeat seat = new EntitySeat(this.ship.field_70170_p);
                seat.setParentShip(this.ship, x, y, z);
                this.addAttachments(seat);
            }
        }
    }

    public boolean hasSeat(EntitySeat seat) {
        if (this.seats != null && !this.seats.isEmpty()) {
            return this.seats.contains((Object)seat);
        }
        return true;
    }

    public EntitySeat getAvailableSeat() {
        for (EntitySeat seat : this.seats) {
            if (seat.field_70153_n != null && (seat.field_70153_n == null || seat.field_70153_n.field_70154_o != null && (seat.field_70153_n.field_70154_o == null || seat.field_70153_n.field_70154_o == seat))) continue;
            seat.func_70078_a(null);
            return seat;
        }
        return null;
    }

    public boolean mountEntity(Entity entity) {
        if (this.seats == null) {
            return false;
        }
        for (EntitySeat seat : this.seats) {
            if (!seat.func_130002_c((EntityPlayer)entity)) continue;
            return true;
        }
        return false;
    }

    public void spawnSeatEntities() {
        if (this.seats != null && !this.seats.isEmpty()) {
            for (EntitySeat seat : this.seats) {
                this.ship.field_70170_p.func_72838_d((Entity)seat);
            }
        }
    }

    public void clearBlockCount() {
        this.liftMultiplier = 1.0f;
        this.rotationMultiplier = 1.0f;
        this.speedMultiplier = 1.0f;
        this.brakeMult = 0.9f;
        this.floaters = 0;
        this.blockCount = 0;
        this.mass = 0.0f;
        if (this.engines != null) {
            this.engines.clear();
            this.engines = null;
        }
    }

    public void clear() {
        if (this.seats != null) {
            for (EntitySeat seat : this.seats) {
                seat.func_70106_y();
            }
            this.seats = null;
        }
        if (this.engines != null) {
            this.engines.clear();
            this.engines = null;
        }
        this.submerseFound = false;
        this.canSubmerge = false;
        this.clearBlockCount();
    }

    public float getSpeedLimit() {
        return ArchimedesShipMod.instance.modConfig.speedLimit;
    }

    public float getBankingMultiplier() {
        return ArchimedesShipMod.instance.modConfig.bankingMultiplier;
    }
}

