/*
 * Decompiled with CFR 0.152.
 */
package talonos.biomescanner.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import talonos.biomescanner.BiomeScanner;
import talonos.biomescanner.client.GaugeBlockModel;
import talonos.biomescanner.map.Zone;
import talonos.biomescanner.tileentity.TileEntityGauge;

@SideOnly(value=Side.CLIENT)
public class TileEntityGaugeRenderer
extends TileEntitySpecialRenderer {
    private GaugeBlockModel block = new GaugeBlockModel();

    public void func_147500_a(TileEntity entity, double x, double y, double z, float par8) {
        TextureManager renderEngine;
        TileEntityGauge tileEntityGauge = (TileEntityGauge)entity;
        boolean shouldMixIcon = Math.abs(tileEntityGauge.getCompletion() - 1.0f) < 0.001f;
        float tickCycle = 0.0f;
        if (shouldMixIcon) {
            tickCycle = entity.func_145831_w().func_72820_D() % 40L;
            if ((tickCycle = Math.abs(tickCycle / 20.0f - 1.0f)) < 0.01f) {
                shouldMixIcon = false;
            }
        }
        if ((renderEngine = Minecraft.func_71410_x().field_71446_o) == null) {
            return;
        }
        if (BiomeScanner.disableEverything) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        renderEngine.func_110577_a(new ResourceLocation("biomescanner", this.getIcon(tileEntityGauge.getTargetZone())));
        this.block.render();
        if (shouldMixIcon) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)tickCycle);
            renderEngine.func_110577_a(new ResourceLocation("biomescanner", this.getEmptyIcon(tileEntityGauge.getTargetZone())));
            this.block.render();
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glPopMatrix();
    }

    private String getIcon(Zone targetZone) {
        String prefix = "textures/blocks/biomeMon-";
        return prefix + targetZone.toString() + ".png";
    }

    private String getEmptyIcon(Zone targetZone) {
        String prefix = "textures/blocks/biomeMon-empty";
        return prefix + Integer.toString(targetZone.ordinal() / 6) + ".png";
    }
}

