/*
 * Decompiled with CFR 0.152.
 */
package talonos.biomescanner.map;

public class BiomeMapColors {
    public static int[] colors = new int[256];
    public static int[] biomeLookup = new int[256];
    public static double FLASH_DIVISOR = 6.0;

    public static void initColors() {
        int x;
        for (x = 0; x < 256; ++x) {
            BiomeMapColors.biomeLookup[x] = 48;
        }
        BiomeMapColors.biomeLookup[0] = 0;
        BiomeMapColors.biomeLookup[1] = 1;
        BiomeMapColors.biomeLookup[2] = 2;
        BiomeMapColors.biomeLookup[3] = 6;
        BiomeMapColors.biomeLookup[4] = 8;
        BiomeMapColors.biomeLookup[5] = 9;
        BiomeMapColors.biomeLookup[6] = 10;
        BiomeMapColors.biomeLookup[7] = 11;
        BiomeMapColors.biomeLookup[8] = 12;
        BiomeMapColors.biomeLookup[9] = -1;
        BiomeMapColors.biomeLookup[10] = 13;
        BiomeMapColors.biomeLookup[11] = 13;
        BiomeMapColors.biomeLookup[12] = 14;
        BiomeMapColors.biomeLookup[13] = 15;
        BiomeMapColors.biomeLookup[14] = 16;
        BiomeMapColors.biomeLookup[15] = 17;
        BiomeMapColors.biomeLookup[16] = 18;
        BiomeMapColors.biomeLookup[17] = 19;
        BiomeMapColors.biomeLookup[18] = 20;
        BiomeMapColors.biomeLookup[19] = 21;
        BiomeMapColors.biomeLookup[20] = 3;
        BiomeMapColors.biomeLookup[21] = 22;
        BiomeMapColors.biomeLookup[22] = 23;
        BiomeMapColors.biomeLookup[23] = 51;
        BiomeMapColors.biomeLookup[27] = 52;
        BiomeMapColors.biomeLookup[28] = 20;
        BiomeMapColors.biomeLookup[132] = 52;
        BiomeMapColors.biomeLookup[45] = 24;
        BiomeMapColors.biomeLookup[46] = 26;
        BiomeMapColors.biomeLookup[47] = 28;
        BiomeMapColors.biomeLookup[48] = 5;
        BiomeMapColors.biomeLookup[49] = 4;
        BiomeMapColors.biomeLookup[50] = 7;
        BiomeMapColors.biomeLookup[51] = 29;
        BiomeMapColors.biomeLookup[52] = 31;
        BiomeMapColors.biomeLookup[53] = 32;
        BiomeMapColors.biomeLookup[54] = 30;
        BiomeMapColors.biomeLookup[55] = 33;
        BiomeMapColors.biomeLookup[56] = 34;
        BiomeMapColors.biomeLookup[57] = 31;
        BiomeMapColors.biomeLookup[58] = 33;
        BiomeMapColors.biomeLookup[59] = 33;
        BiomeMapColors.biomeLookup[60] = 34;
        BiomeMapColors.biomeLookup[61] = 33;
        BiomeMapColors.biomeLookup[62] = 31;
        BiomeMapColors.biomeLookup[63] = 35;
        BiomeMapColors.biomeLookup[64] = 36;
        BiomeMapColors.biomeLookup[65] = 38;
        BiomeMapColors.biomeLookup[66] = 37;
        BiomeMapColors.biomeLookup[67] = 41;
        BiomeMapColors.biomeLookup[68] = 40;
        BiomeMapColors.biomeLookup[69] = 39;
        BiomeMapColors.biomeLookup[70] = 42;
        BiomeMapColors.biomeLookup[71] = 43;
        BiomeMapColors.biomeLookup[72] = 44;
        BiomeMapColors.biomeLookup[73] = 45;
        BiomeMapColors.biomeLookup[74] = 25;
        BiomeMapColors.biomeLookup[75] = 27;
        BiomeMapColors.biomeLookup[76] = 7;
        BiomeMapColors.biomeLookup[77] = 0;
        BiomeMapColors.biomeLookup[78] = 2;
        BiomeMapColors.biomeLookup[79] = 19;
        BiomeMapColors.biomeLookup[80] = 18;
        BiomeMapColors.biomeLookup[81] = 0;
        BiomeMapColors.biomeLookup[82] = 11;
        BiomeMapColors.biomeLookup[83] = 49;
        BiomeMapColors.biomeLookup[194] = 46;
        BiomeMapColors.biomeLookup[193] = 47;
        BiomeMapColors.biomeLookup[140] = 50;
        BiomeMapColors.biomeLookup[35] = 53;
        BiomeMapColors.biomeLookup[36] = 54;
        BiomeMapColors.colors[0] = 0x3333FF;
        BiomeMapColors.colors[1] = 12110930;
        BiomeMapColors.colors[2] = 0xFFCC33;
        BiomeMapColors.colors[3] = 7034902;
        BiomeMapColors.colors[4] = 8613414;
        BiomeMapColors.colors[5] = 10323772;
        BiomeMapColors.colors[6] = 12231768;
        BiomeMapColors.colors[7] = 13942905;
        BiomeMapColors.colors[8] = 2541606;
        BiomeMapColors.colors[9] = 30464;
        BiomeMapColors.colors[10] = 7575884;
        BiomeMapColors.colors[11] = 52428;
        BiomeMapColors.colors[12] = 0x999977;
        BiomeMapColors.colors[13] = 0xA8FFFA;
        BiomeMapColors.colors[14] = 0xCCCCCC;
        BiomeMapColors.colors[15] = 0xAAAAAA;
        BiomeMapColors.colors[16] = 9327037;
        BiomeMapColors.colors[17] = 9793458;
        BiomeMapColors.colors[18] = 0xFFFF00;
        BiomeMapColors.colors[19] = 13213992;
        BiomeMapColors.colors[20] = 39168;
        BiomeMapColors.colors[21] = 13107;
        BiomeMapColors.colors[22] = 1613096;
        BiomeMapColors.colors[23] = 944152;
        BiomeMapColors.colors[24] = 14793546;
        BiomeMapColors.colors[25] = 8297788;
        BiomeMapColors.colors[26] = 11061093;
        BiomeMapColors.colors[27] = 40606;
        BiomeMapColors.colors[28] = 0x777777;
        BiomeMapColors.colors[29] = 61132;
        BiomeMapColors.colors[30] = 0xCCAA22;
        BiomeMapColors.colors[31] = 8415766;
        BiomeMapColors.colors[32] = 0x4D400D;
        BiomeMapColors.colors[33] = 10059802;
        BiomeMapColors.colors[34] = 12503078;
        BiomeMapColors.colors[35] = 16737433;
        BiomeMapColors.colors[36] = 8308774;
        BiomeMapColors.colors[37] = 28264;
        BiomeMapColors.colors[38] = 41368;
        BiomeMapColors.colors[39] = 34687;
        BiomeMapColors.colors[40] = 47791;
        BiomeMapColors.colors[41] = 58583;
        BiomeMapColors.colors[42] = 0x999977;
        BiomeMapColors.colors[43] = 0xFF0000;
        BiomeMapColors.colors[44] = 8685595;
        BiomeMapColors.colors[45] = 0x99FF00;
        BiomeMapColors.colors[46] = 0x442222;
        BiomeMapColors.colors[47] = 1179571;
        BiomeMapColors.colors[48] = 15335679;
        BiomeMapColors.colors[49] = 556312;
        BiomeMapColors.colors[50] = 10022890;
        BiomeMapColors.colors[51] = 10022890;
        BiomeMapColors.colors[52] = 3586102;
        BiomeMapColors.colors[53] = 13159490;
        BiomeMapColors.colors[54] = 11054130;
        for (x = 0; x < 54; ++x) {
            BiomeMapColors.colors[x + 64] = BiomeMapColors.halveColor(colors[x]);
        }
    }

    private static int halveColor(int i) {
        int r = i >> 16;
        int g = (i & 0xFF00) >> 8;
        int b = i & 0xFF;
        return ((r /= 2) << 16) + ((g /= 2) << 8) + (b /= 2);
    }

    public static void updateFlash(long worldTime) {
        int x;
        double sinish = (Math.sin((double)worldTime / FLASH_DIVISOR) + 1.0) / 2.0;
        for (x = 0; x < 54; ++x) {
            BiomeMapColors.colors[x + 128] = BiomeMapColors.addRed(colors[x], sinish);
        }
        for (x = 0; x < 54; ++x) {
            BiomeMapColors.colors[x + 192] = BiomeMapColors.halveColor(colors[x + 64]);
        }
    }

    private static int addRed(int i, double sinish) {
        int r = i >> 16;
        int g = (i & 0xFF00) >> 8;
        int b = i & 0xFF;
        int newr = 255;
        boolean newg = false;
        int newb = 150;
        r = (int)((double)r * (1.0 - sinish) + (double)newr * sinish);
        g = (int)((double)g * (1.0 - sinish) + (double)newg * sinish);
        b = (int)((double)b * (1.0 - sinish) + (double)newb * sinish);
        return (r << 16) + (g << 8) + b;
    }
}

