/*
 * Decompiled with CFR 0.152.
 */
package talonos.biomescanner.map;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventBus;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraftforge.event.world.WorldEvent;
import talonos.biomescanner.BiomeScanner;
import talonos.biomescanner.map.BiomeMapColors;
import talonos.biomescanner.map.RegionMap;
import talonos.biomescanner.map.Zone;
import talonos.biomescanner.map.event.UpdateMapEvent;
import talonos.biomescanner.network.BiomeScannerNetwork;
import talonos.biomescanner.network.UpdateMapPacket;
import thaumcraft.common.config.ConfigBlocks;

public class MapScanner {
    public static MapScanner instance = new MapScanner();
    public int chunkX = -62;
    public int chunkZ = -64;
    public World world;
    public static final int mapWidthChunks = 110;
    public static final int blockWidth = 176;
    public static final int blockHeight = 180;
    private final RegionMap regionMap = new RegionMap();
    private int lastScannedChunk = 0;
    private final byte[][] mapPixels = new byte[1260][880];
    private final EventBus eventBus = new EventBus();

    public EventBus bus() {
        return this.eventBus;
    }

    public void initMap() {
        for (int y = 0; y < 1260; ++y) {
            for (int x = 0; x < 880; ++x) {
                int usByte = 0 | this.mapPixels[y][x];
                if (usByte >= 64 && (usByte < 128 || usByte >= 192)) continue;
                this.mapPixels[y][x] = (byte)(usByte + 64);
            }
        }
        this.bus().post((Event)new UpdateMapEvent(0, 0, 880, 1260));
    }

    public RegionMap getRegionMap() {
        return this.regionMap;
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        this.world = event.world;
        if (event.world.field_73011_w.field_76574_g == 0 && !event.world.field_72995_K) {
            this.loadData(event.world.func_72860_G());
            this.bus().post((Event)this.regionMap.getUpdateEvent(Arrays.asList(Zone.values())));
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        if (event.world.field_73011_w.field_76574_g == 0 && !event.world.field_72995_K) {
            this.saveData(new File(event.world.func_72860_G().func_75765_b(), "scanner.dat"));
        }
    }

    private void loadData(ISaveHandler saveHandler) {
        File worldScannerFile = new File(saveHandler.func_75765_b(), "scanner.dat");
        if (this.loadDataFile(worldScannerFile) || BiomeScanner.baselineFile != null && this.loadDataFile(BiomeScanner.baselineFile)) {
            return;
        }
        if (!this.loadDataFile(worldScannerFile, true)) {
            this.fillRandomData();
        }
    }

    private boolean loadDataFile(File loadFile) {
        return this.loadDataFile(loadFile, false);
    }

    private boolean loadDataFile(File loadFile, boolean forceLoad) {
        if (!loadFile.exists()) {
            return false;
        }
        try {
            NBTTagCompound loadedData = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(loadFile));
            return this.readNBT(loadedData, forceLoad);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private void saveData(File saveFile) {
        NBTTagCompound compound = new NBTTagCompound();
        this.writeNBT(compound);
        try {
            CompressedStreamTools.func_74799_a((NBTTagCompound)compound, (OutputStream)new FileOutputStream(saveFile));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void fillRandomData() {
        this.lastScannedChunk = 0;
        Random r = new Random();
        for (int y = 0; y < 1260; ++y) {
            r.nextBytes(this.mapPixels[y]);
        }
    }

    private boolean readNBT(NBTTagCompound tag, boolean forceLoad) {
        this.lastScannedChunk = tag.func_74762_e("LastScannedChunk");
        NBTTagCompound dataTag = tag.func_74775_l("Data");
        for (int y = 0; y < 1260; ++y) {
            this.mapPixels[y] = dataTag.func_74770_j(Integer.toString(y));
        }
        if (this.regionMap.read(tag.func_74775_l("RegionMap"))) {
            if (!forceLoad) {
                return false;
            }
            this.lastScannedChunk = 0;
        }
        return true;
    }

    private void writeNBT(NBTTagCompound tag) {
        tag.func_74768_a("LastScannedChunk", this.lastScannedChunk);
        NBTTagCompound dataTag = new NBTTagCompound();
        tag.func_74782_a("Data", (NBTBase)dataTag);
        for (int y = 0; y < 1260; ++y) {
            dataTag.func_74773_a(Integer.toString(y), this.mapPixels[y]);
        }
        NBTTagCompound regionMapTag = new NBTTagCompound();
        this.regionMap.write(regionMapTag);
        tag.func_74782_a("RegionMap", (NBTBase)regionMapTag);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (BiomeScanner.disableEverything) {
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e != null) {
            BiomeMapColors.updateFlash(Minecraft.func_71410_x().field_71441_e.func_72820_D());
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (BiomeScanner.disableEverything || event.phase == TickEvent.Phase.END) {
            return;
        }
        if (event.world.field_73011_w.field_76574_g == 0 && !event.world.field_72995_K) {
            if (this.lastScannedChunk == 0) {
                this.regionMap.wipeData();
                this.bus().post((Event)this.regionMap.getUpdateEvent(Arrays.asList(Zone.values())));
                this.initMap();
            }
            if (this.lastScannedChunk != -1 && !event.world.field_72995_K) {
                this.scanSomeChunks(event.world);
            }
        }
    }

    private void scanSomeChunks(World worldObj) {
        int chunkX = this.lastScannedChunk % 22 * 5;
        int chunkZ = this.lastScannedChunk / 22 * 1;
        BiomeGenBase[] biomesForGeneration = worldObj.func_72959_q().func_76933_b(null, chunkX * 16, chunkZ * 16, 80, 16);
        LinkedList<Zone> updatedZones = new LinkedList<Zone>();
        for (int xInChunk = 0; xInChunk < 80; xInChunk += 2) {
            int x = chunkX * 16 + xInChunk;
            for (int zInChunk = 0; zInChunk < 16; zInChunk += 2) {
                int z = chunkZ * 16 + zInChunk;
                int biomeIndex = zInChunk * 80 + xInChunk;
                if (biomesForGeneration != null && biomesForGeneration[biomeIndex] != null) {
                    int biomeID = biomesForGeneration[biomeIndex].field_76756_M;
                    int color = BiomeMapColors.biomeLookup[biomeID];
                    if (this.getTaintAt(x, z, worldObj)) {
                        color += 128;
                        updatedZones.add(this.regionMap.incrementBlock(x, z, false));
                    } else {
                        updatedZones.add(this.regionMap.incrementBlock(x, z, true));
                    }
                    int newx = 1760 - x - 1;
                    int xPix = newx / 2;
                    int yPix = z / 2;
                    this.setColor(xPix, yPix, (byte)color);
                    continue;
                }
                System.out.println("Error!");
                System.out.println(biomesForGeneration != null);
                System.out.println(biomesForGeneration[biomeIndex] != null);
            }
        }
        this.bus().post((Event)this.regionMap.getUpdateEvent(updatedZones));
        int minX = 880 - chunkX * 8 - 40;
        int minY = chunkZ * 8;
        this.bus().post((Event)new UpdateMapEvent(minX, minY, 40, 8));
        ++this.lastScannedChunk;
        if (this.lastScannedChunk >= 2970) {
            this.regionMap.updateData();
            this.lastScannedChunk = -1;
        }
    }

    private boolean getTaintAt(int x, int z, World worldObj) {
        for (int y = 0; y <= 255; ++y) {
            Block northwest = worldObj.func_147439_a(x, y, z);
            int northwestMeta = worldObj.func_72805_g(x, y, z);
            Block northeast = worldObj.func_147439_a(x + 1, y, z);
            int northeastMeta = worldObj.func_72805_g(x + 1, y, z);
            Block southwest = worldObj.func_147439_a(x, y, z + 1);
            int southwestMeta = worldObj.func_72805_g(x, y, z + 1);
            Block southeast = worldObj.func_147439_a(x + 1, y, z + 1);
            int southeastMeta = worldObj.func_72805_g(x + 1, y, z + 1);
            if (!(northwest == ConfigBlocks.blockTaint && northwestMeta != 2 || northeast == ConfigBlocks.blockTaint && northeastMeta != 2 || southwest == ConfigBlocks.blockTaint && southwestMeta != 2 || southeast == ConfigBlocks.blockTaint && southeastMeta != 2 || northwest == ConfigBlocks.blockTaintFibres || northeast == ConfigBlocks.blockTaintFibres || southwest == ConfigBlocks.blockTaintFibres) && southeast != ConfigBlocks.blockTaintFibres) continue;
            return true;
        }
        return false;
    }

    public boolean isActive() {
        return this.lastScannedChunk >= 0;
    }

    public void activate() {
        this.lastScannedChunk = 0;
    }

    public void setColor(int x, int y, byte color) {
        this.mapPixels[y][x] = color;
    }

    public int getColor(int x, int y) {
        byte b0 = this.mapPixels[y][x];
        int b = b0 & 0xFF;
        return BiomeMapColors.colors[b];
    }

    public byte getRawColorByte(int x, int y) {
        return this.mapPixels[y][x];
    }

    public void updateFromNetwork(int minX, int minY, int width, int height, byte[] data) {
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.setColor(x + minX, y + minY, data[y * width + x]);
            }
        }
        this.bus().post((Event)new UpdateMapEvent(minX, minY, width, height));
    }

    public void sendEntireMap(EntityPlayerMP entityPlayer) {
        int width = 880;
        int height = 1260;
        byte[] data = new byte[1108800];
        for (int y = 0; y < 1260; ++y) {
            for (int x = 0; x < 880; ++x) {
                data[y * 880 + x] = instance.getRawColorByte(x, y);
            }
        }
        BiomeScannerNetwork.sendToPlayer(new UpdateMapPacket(0, 0, 880, 1260, data), entityPlayer);
    }
}

