/*
 * Decompiled with CFR 0.152.
 */
package talonos.biomescanner.map;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import talonos.biomescanner.BiomeScanner;
import talonos.biomescanner.map.Zone;
import talonos.biomescanner.map.event.UpdateCompletionEvent;

public class RegionMap {
    Map<Zone, Integer> totalBlocksCount = new HashMap<Zone, Integer>();
    Map<Zone, Integer> baselineCleanBlocksCount = new HashMap<Zone, Integer>();
    Map<Zone, Integer> cleanBlocksCount = new HashMap<Zone, Integer>();
    boolean buildingBaseline = true;
    Zone[][] zoneMap = null;
    Map<Integer, Zone> colorToZone = new HashMap<Integer, Zone>();

    public RegionMap() {
        for (Zone zone : Zone.values()) {
            this.colorToZone.put(zone.getImageColor(), zone);
        }
        try {
            BufferedImage image = ImageIO.read(RegionMap.class.getResourceAsStream("/assets/biomescanner/textures/regionmap.png"));
            this.zoneMap = new Zone[image.getHeight()][image.getWidth()];
            for (int y = 0; y < image.getHeight(); ++y) {
                for (int x = 0; x < image.getWidth(); ++x) {
                    this.zoneMap[y][x] = this.colorToZone.get(image.getRGB(x, y) & 0xFF);
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void resetBaseline() {
        this.totalBlocksCount.clear();
        this.cleanBlocksCount.clear();
        this.baselineCleanBlocksCount.clear();
        this.buildingBaseline = true;
    }

    public boolean read(NBTTagCompound tag) {
        NBTTagCompound totals = tag.func_74775_l("TotalBlocks");
        NBTTagCompound baseline = tag.func_74775_l("BaselineBlocks");
        NBTTagCompound clean = tag.func_74775_l("CleanBlocks");
        this.buildingBaseline = tag.func_74767_n("BuildingBaseline");
        boolean forceRescan = false;
        for (Zone zone : Zone.values()) {
            String ordinal = Integer.toString(zone.ordinal());
            if (totals.func_74764_b(ordinal)) {
                this.totalBlocksCount.put(zone, totals.func_74762_e(ordinal));
            }
            if (BiomeScanner.zoneBaselines[zone.ordinal()] != null) {
                int mapBaseline;
                int configBaseline = BiomeScanner.zoneBaselines[zone.ordinal()];
                if (configBaseline != (mapBaseline = baseline.func_74762_e(ordinal))) {
                    forceRescan = true;
                }
                this.baselineCleanBlocksCount.put(zone, BiomeScanner.zoneBaselines[zone.ordinal()]);
            } else if (baseline.func_74764_b(ordinal)) {
                this.baselineCleanBlocksCount.put(zone, baseline.func_74762_e(ordinal));
            }
            if (!clean.func_74764_b(ordinal)) continue;
            this.cleanBlocksCount.put(zone, clean.func_74762_e(ordinal));
        }
        if (forceRescan) {
            for (Zone zone : this.cleanBlocksCount.keySet()) {
                this.cleanBlocksCount.put(zone, 0);
            }
        }
        return forceRescan;
    }

    public void write(NBTTagCompound tag) {
        NBTTagCompound totals = new NBTTagCompound();
        tag.func_74782_a("TotalBlocks", (NBTBase)totals);
        NBTTagCompound baseline = new NBTTagCompound();
        tag.func_74782_a("BaselineBlocks", (NBTBase)baseline);
        NBTTagCompound clean = new NBTTagCompound();
        tag.func_74782_a("CleanBlocks", (NBTBase)clean);
        tag.func_74757_a("BuildingBaseline", this.buildingBaseline);
        for (Zone zone : Zone.values()) {
            String ordinal = Integer.toString(zone.ordinal());
            if (this.totalBlocksCount.containsKey((Object)zone)) {
                totals.func_74768_a(ordinal, this.totalBlocksCount.get((Object)zone).intValue());
            }
            if (this.baselineCleanBlocksCount.containsKey((Object)zone)) {
                baseline.func_74768_a(ordinal, this.baselineCleanBlocksCount.get((Object)zone).intValue());
            }
            if (!this.cleanBlocksCount.containsKey((Object)zone)) continue;
            clean.func_74768_a(ordinal, this.cleanBlocksCount.get((Object)zone).intValue());
        }
    }

    public Zone incrementBlock(int x, int y, boolean isClean) {
        Zone zone = this.zoneMap[y / 2][x / 2];
        if (this.buildingBaseline) {
            this.increment(this.totalBlocksCount, zone);
            if (isClean) {
                this.increment(this.baselineCleanBlocksCount, zone);
            }
        }
        if (isClean) {
            this.increment(this.cleanBlocksCount, zone);
        }
        return zone;
    }

    public UpdateCompletionEvent getUpdateEvent(List<Zone> updatedZones) {
        HashMap<Zone, Float> completion = new HashMap<Zone, Float>();
        for (Zone zone : updatedZones) {
            completion.put(zone, Float.valueOf(this.getZoneCompletion(zone)));
        }
        return new UpdateCompletionEvent(completion, this.getCompletion());
    }

    public void wipeData() {
        this.cleanBlocksCount.clear();
    }

    public void updateData() {
        this.buildingBaseline = false;
    }

    public float getZoneCompletion(Zone zone) {
        int baseline = this.get(this.baselineCleanBlocksCount, zone);
        int total = this.get(this.totalBlocksCount, zone);
        int clean = this.get(this.cleanBlocksCount, zone);
        return this.calculateCompletion(baseline, clean, total);
    }

    public float getCompletion() {
        int baseline = 0;
        int total = 0;
        int clean = 0;
        for (Zone zone : Zone.values()) {
            baseline += this.get(this.baselineCleanBlocksCount, zone);
            total += this.get(this.totalBlocksCount, zone);
            clean += this.get(this.cleanBlocksCount, zone);
        }
        return this.calculateCompletion(baseline, clean, total);
    }

    private float calculateCompletion(int baseline, int clean, int total) {
        if (total == 0) {
            return 0.0f;
        }
        total -= baseline;
        if ((clean -= baseline) < 0) {
            clean = 0;
        }
        if (clean > total) {
            clean = total;
        }
        return (float)clean / (float)total;
    }

    private void increment(Map<Zone, Integer> map, Zone zone) {
        if (!map.containsKey((Object)zone)) {
            map.put(zone, 1);
        } else {
            map.put(zone, map.get((Object)zone) + 1);
        }
    }

    private int get(Map<Zone, Integer> map, Zone zone) {
        if (!map.containsKey((Object)zone)) {
            return 0;
        }
        return map.get((Object)zone);
    }
}

