/*
 * Decompiled with CFR 0.152.
 */
package talonos.biomescanner.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;

public class UpdateMapPacket
implements IMessage {
    private int mapX;
    private int mapY;
    private int updateWidth;
    private int updateHeight;
    private byte[] updateData;

    public UpdateMapPacket() {
    }

    public UpdateMapPacket(int mapX, int mapY, int width, int height, byte[] data) {
        this.mapX = mapX;
        this.mapY = mapY;
        this.updateWidth = width;
        this.updateHeight = height;
        this.updateData = data;
    }

    public void fromBytes(ByteBuf in) {
        this.mapX = in.readInt();
        this.mapY = in.readInt();
        this.updateWidth = in.readInt();
        this.updateHeight = in.readInt();
        this.updateData = new byte[this.updateWidth * this.updateHeight];
        in.readBytes(this.updateData, 0, this.updateData.length);
    }

    public void toBytes(ByteBuf out) {
        out.writeInt(this.mapX);
        out.writeInt(this.mapY);
        out.writeInt(this.updateWidth);
        out.writeInt(this.updateHeight);
        out.writeBytes(this.updateData);
    }

    public int getMapX() {
        return this.mapX;
    }

    public int getMapY() {
        return this.mapY;
    }

    public int getUpdateHeight() {
        return this.updateHeight;
    }

    public int getUpdateWidth() {
        return this.updateWidth;
    }

    public byte[] getUpdateData() {
        return this.updateData;
    }
}

