/*
 * Decompiled with CFR 0.152.
 */
package talonos.biomescanner.tileentity;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import talonos.biomescanner.block.BSBlock;
import talonos.biomescanner.map.MapScanner;
import talonos.biomescanner.map.Zone;
import talonos.biomescanner.map.event.UpdateCompletionEvent;

public class TileEntityGauge
extends TileEntity {
    private Zone targetZone = Zone.SwampBay;
    private float completion = 0.0f;

    public TileEntityGauge() {
        this.register();
        this.completion = MapScanner.instance.getRegionMap().getZoneCompletion(this.targetZone);
    }

    public Zone getTargetZone() {
        return this.targetZone;
    }

    public float getCompletion() {
        return this.completion;
    }

    public void onChunkUnload() {
        this.unregister();
    }

    protected void register() {
        MapScanner.instance.bus().register((Object)this);
    }

    public void unregister() {
        MapScanner.instance.bus().unregister((Object)this);
    }

    public void cycleZone() {
        if (!this.field_145850_b.field_72995_K) {
            int ordinal = this.targetZone.ordinal();
            int newOrdinal = ordinal + 1;
            newOrdinal = newOrdinal >= Zone.values().length ? 0 : newOrdinal;
            this.targetZone = Zone.values()[newOrdinal];
            this.updateZone(MapScanner.instance.getRegionMap().getZoneCompletion(this.targetZone));
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
        }
    }

    @SubscribeEvent
    public void onCompletionUpdate(UpdateCompletionEvent event) {
        if (!event.hasZone(this.targetZone)) {
            return;
        }
        this.updateZone(event.getZoneCompletion(this.targetZone));
    }

    protected void updateZone(float completion) {
        this.completion = completion;
        this.updateGauge();
    }

    private void updateGauge() {
        int totalStages;
        if (this.field_145850_b == null) {
            return;
        }
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 3, this.field_145849_e) != BSBlock.gaugeBot) {
            return;
        }
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e) != BSBlock.gaugeMid) {
            return;
        }
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) != BSBlock.gaugeTop) {
            return;
        }
        int currentStage = totalStages = 43;
        if (this.completion != 1.0f) {
            currentStage = (int)Math.floor((float)totalStages * this.completion);
        }
        if (this.completion != 0.0f && currentStage == 0) {
            currentStage = 1;
        }
        int targetBottom = currentStage < 14 ? currentStage : 13;
        int targetMid = Math.max((currentStage -= 14) < 16 ? currentStage : 15, 0);
        int targetTop = Math.max(currentStage -= 16, 0);
        if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d - 3, this.field_145849_e) != targetBottom) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d - 3, this.field_145849_e, targetBottom, 3);
        }
        if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e) != targetMid) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e, targetMid, 3);
        }
        if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) != targetTop) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, targetTop, 3);
        }
    }

    public void func_145839_a(NBTTagCompound par1) {
        super.func_145839_a(par1);
        int ordinal = par1.func_74762_e("Zone");
        this.targetZone = Zone.values()[ordinal];
        this.completion = MapScanner.instance.getRegionMap().getZoneCompletion(this.targetZone);
    }

    public void func_145841_b(NBTTagCompound par1) {
        super.func_145841_b(par1);
        par1.func_74768_a("Zone", this.targetZone.ordinal());
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }
}

