/*
 * Decompiled with CFR 0.152.
 */
package talonos.biomescanner.tileentity;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import talonos.biomescanner.BSItems;
import talonos.biomescanner.map.MapScanner;
import talonos.biomescanner.map.Zone;
import talonos.biomescanner.map.event.UpdateCompletionEvent;

public class TileEntityIslandScanner
extends TileEntity
implements ISidedInventory {
    private ItemStack[] tempInventory;
    private boolean hasScanned = false;
    private int[] noSlots = new int[0];
    private int[] allSlots;

    public TileEntityIslandScanner() {
        this.tempInventory = new ItemStack[this.func_70302_i_()];
        MapScanner.instance.bus().register((Object)this);
        int size = this.func_70302_i_();
        this.allSlots = new int[size];
        for (int i = 0; i < size; ++i) {
            this.allSlots[i] = i;
        }
        this.updateTotalCompletion(MapScanner.instance.getRegionMap().getCompletion());
        for (Zone zone : Zone.values()) {
            this.updateZoneCompletion(zone.ordinal(), MapScanner.instance.getRegionMap().getZoneCompletion(zone));
        }
        this.updateSlot(Zone.values().length * 3 + 1, this.hasScanned);
    }

    public void scanOrdered() {
        this.hasScanned = true;
        this.func_70296_d();
        this.updateSlot(Zone.values().length * 3 + 1, true);
    }

    public void onChunkUnload() {
        this.unregister();
    }

    public void unregister() {
        MapScanner.instance.bus().unregister((Object)this);
    }

    public int func_70302_i_() {
        return Zone.values().length * 3 + 2;
    }

    public ItemStack func_70301_a(int slot) {
        return this.tempInventory[slot];
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.tempInventory[slot] = stack;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.func_70301_a(slot);
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public String func_145825_b() {
        return "gui.inventory.scanner";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_102007_a(int slot, ItemStack itemStack, int side) {
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack itemStack, int side) {
        return side == 3;
    }

    public int[] func_94128_d(int side) {
        if (side == 3) {
            return this.allSlots;
        }
        return this.noSlots;
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        return false;
    }

    @SubscribeEvent
    public void onCompletionUpdate(UpdateCompletionEvent event) {
        this.updateTotalCompletion(event.getTotalCompletion());
        for (Zone zone : Zone.values()) {
            if (!event.hasZone(zone)) continue;
            this.updateZoneCompletion(zone.ordinal(), event.getZoneCompletion(zone));
        }
    }

    private void updateTotalCompletion(float completion) {
        boolean complete = completion >= 0.9999f;
        this.updateSlot(Zone.values().length * 3, complete);
    }

    private void updateZoneCompletion(int zoneOrdinal, float completion) {
        boolean bronzeCompletion = completion >= 0.1999f;
        boolean silverCompletion = completion >= 0.4999f;
        boolean goldCompletion = completion >= 0.9999f;
        this.updateSlot(zoneOrdinal * 3, bronzeCompletion);
        this.updateSlot(zoneOrdinal * 3 + 1, silverCompletion);
        this.updateSlot(zoneOrdinal * 3 + 2, goldCompletion);
    }

    private void updateSlot(int slot, boolean complete) {
        boolean update;
        boolean bl = update = complete != (this.tempInventory[slot] != null);
        if (update) {
            this.tempInventory[slot] = complete ? new ItemStack((Item)BSItems.badge, 1, slot) : null;
        }
    }

    public void func_145839_a(NBTTagCompound par1) {
        super.func_145839_a(par1);
        this.hasScanned = par1.func_74767_n("HasScanned");
        this.updateSlot(Zone.values().length * 3 + 1, this.hasScanned);
    }

    public void func_145841_b(NBTTagCompound par1) {
        super.func_145841_b(par1);
        par1.func_74757_a("HasScanned", this.hasScanned);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }
}

