/*
 * Decompiled with CFR 0.152.
 */
package talonos.blightbuster;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import talonos.blightbuster.AddedResearch;
import talonos.blightbuster.BlightbusterConfig;
import talonos.blightbuster.CommonProxy;
import talonos.blightbuster.blocks.BBBlock;
import talonos.blightbuster.entities.EntitySilverPotion;
import talonos.blightbuster.handlers.PurityFocusEventHandler;
import talonos.blightbuster.items.BBItems;
import talonos.blightbuster.network.BlightbusterNetwork;
import talonos.blightbuster.rituals.RitualDawnMachine;
import talonos.blightbuster.tileentity.DawnMachineSpoutTileEntity;
import talonos.blightbuster.tileentity.dawnmachine.DawnMachineChunkLoader;
import thaumicenergistics.api.ThEApi;

@Mod(modid="blightbuster", name="BlightBuster", version="2.1.0", dependencies="before:UndergroundBiomes;after:ThermalFoundation;after:appliedenergistics2;after:Thaumcraft")
public class BlightBuster {
    public static final String MODID = "blightbuster";
    public static final String MODNAME = "BlightBuster";
    public static final String VERSION = "2.1.0";
    public static final String DEPS = "before:UndergroundBiomes;after:ThermalFoundation;after:appliedenergistics2;after:Thaumcraft";
    public static final String COMMONPROXYLOCATION = "talonos.blightbuster.CommonProxy";
    public static final String CLIENTPROXYLOCATION = "talonos.blightbuster.ClientProxy";
    @SidedProxy(clientSide="talonos.blightbuster.ClientProxy", serverSide="talonos.blightbuster.CommonProxy")
    public static CommonProxy proxy;
    public static Logger logger;
    public static BlightBuster instance;
    private DawnMachineChunkLoader dawnMachineChunkLoader;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        BlightbusterConfig.load(config);
        instance = this;
        BBBlock.init();
        BBItems.init();
        proxy.registerTileEntities();
        if (BlightbusterConfig.enableSilverPotion) {
            EntityRegistry.registerModEntity(EntitySilverPotion.class, (String)"silverPotion", (int)0, (Object)MODID, (int)250, (int)5, (boolean)true);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        BlightbusterNetwork.init();
        if (BlightbusterConfig.enablePurityFocus) {
            MinecraftForge.EVENT_BUS.register((Object)new PurityFocusEventHandler());
            FMLCommonHandler.instance().bus().register((Object)new PurityFocusEventHandler());
        }
        if (BlightbusterConfig.enableDawnMachine) {
            this.dawnMachineChunkLoader = new DawnMachineChunkLoader();
            ForgeChunkManager.setForcedChunkLoadingCallback((Object)this, (ForgeChunkManager.LoadingCallback)this.dawnMachineChunkLoader);
        }
        if (BlightbusterConfig.enableThaumicEnergistics && ThEApi.instance() != null) {
            ThEApi.instance().transportPermissions().addAspectContainerTileToInjectPermissions(DawnMachineSpoutTileEntity.class, 320);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (BlightbusterConfig.registerResearch) {
            AddedResearch.initResearch();
        }
        AddedResearch.initWandHandler();
        proxy.registerRenderers();
        if (BlightbusterConfig.enableBlood) {
            RitualDawnMachine.init();
        }
        BlightbusterConfig.init_mappings();
    }

    static {
        logger = LogManager.getLogger((String)MODID);
    }
}

