/*
 * Decompiled with CFR 0.152.
 */
package talonos.blightbuster.items;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import talonos.blightbuster.lib.CleansingHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.nodes.NodeType;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.utils.EntityUtils;
import thaumcraft.common.tiles.TileNode;

public class ItemPurityFocus
extends ItemFocusBasic {
    private static final AspectList cost = new AspectList().add(Aspect.EARTH, 10).add(Aspect.ORDER, 15);
    private static final AspectList auraCost = new AspectList().add(Aspect.EARTH, 10000).add(Aspect.ORDER, 15000);

    public ItemPurityFocus() {
        this.func_77655_b("blightbuster_purityFocus");
        GameRegistry.registerItem((Item)this, (String)"purityFocus");
        this.func_77637_a(Thaumcraft.tabTC);
        this.func_111206_d("blightbuster:purityFocus");
    }

    public String getSortingHelper(ItemStack itemstack) {
        return "PU" + super.getSortingHelper(itemstack);
    }

    public boolean isVisCostPerTick() {
        return false;
    }

    public ItemStack onFocusRightClick(ItemStack itemstack, World world, EntityPlayer p, MovingObjectPosition mop) {
        int potency;
        ItemWandCasting wand = (ItemWandCasting)itemstack.func_77973_b();
        if (!wand.consumeAllVis(itemstack, p, this.getBigVisCost(potency = wand.getFocusEnlarge(itemstack) + 1), false, false)) {
            return itemstack;
        }
        Entity pointedEntity = EntityUtils.getPointedEntity((World)p.field_70170_p, (Entity)p, (double)0.0, (double)32.0, (float)32.0f);
        if (pointedEntity != null && !world.field_72995_K) {
            CleansingHelper.cleanseMobFromMapping(pointedEntity, pointedEntity.field_70170_p);
            wand.consumeAllVis(itemstack, p, this.getVisCost(itemstack), true, false);
        }
        boolean consumeVis = false;
        if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            for (int xOffset = -potency; xOffset < 1 + potency; ++xOffset) {
                for (int zOffset = -potency; zOffset < 1 + potency; ++zOffset) {
                    consumeVis = this.cleanUpLand(mop.field_72311_b + xOffset, mop.field_72309_d + zOffset, world, p) || consumeVis;
                }
            }
        }
        if (consumeVis) {
            wand.consumeAllVis(itemstack, p, this.getVisCost(itemstack), true, false);
        }
        return itemstack;
    }

    public boolean onFocusBlockStartBreak(ItemStack itemstack, int x, int y, int z, EntityPlayer player) {
        ItemWandCasting wand = (ItemWandCasting)itemstack.func_77973_b();
        TileEntity tile = player.func_130014_f_().func_147438_o(x, y, z);
        if (tile instanceof TileNode) {
            TileNode node = (TileNode)tile;
            if (node.getNodeType() == NodeType.TAINTED && wand.consumeAllVis(itemstack, player, this.getNodeVisCost(), true, false)) {
                node.setNodeType(NodeType.NORMAL);
                node.func_70296_d();
                player.func_130014_f_().func_147471_g(x, y, z);
            }
            return true;
        }
        return false;
    }

    private AspectList getBigVisCost(int potency) {
        return new AspectList().add(Aspect.EARTH, 10 * (potency * 2 + 1) * (potency * 2 + 1)).add(Aspect.ORDER, 15 * (potency * 2 + 1) * (potency * 2 + 1));
    }

    private boolean cleanUpLand(int x, int z, World world, EntityPlayer p) {
        boolean consumeVis = false;
        if (!p.field_70170_p.field_72995_K) {
            for (int y = 0; y < 256; ++y) {
                consumeVis = CleansingHelper.cleanBlock(x, y, z, world) || consumeVis;
            }
            consumeVis = CleansingHelper.cleanseBiome(x, z, world) || consumeVis;
        }
        return consumeVis;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a(this.func_111208_A());
        this.icon = register.func_94245_a(this.func_111208_A());
    }

    public int getFocusColor(ItemStack arg0) {
        return 3340485;
    }

    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack itemstack, int rank) {
        switch (rank) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge};
            }
        }
        return null;
    }

    public AspectList getVisCost(ItemStack arg0) {
        return cost;
    }

    public AspectList getNodeVisCost() {
        return auraCost;
    }
}

