/*
 * Decompiled with CFR 0.152.
 */
package talonos.blightbuster.lib;

import cpw.mods.fml.common.registry.VillagerRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import noppes.npcs.entity.EntityCustomNpc;
import talonos.blightbuster.BlightBuster;
import talonos.blightbuster.BlightbusterConfig;
import talonos.blightbuster.network.BlightbusterNetwork;
import thaumcraft.common.blocks.BlockFluxGoo;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigBlocks;

public class CleansingHelper {
    public static boolean cleanseMobFromMapping(Entity entity, World world) {
        Class<?> clazz = entity.getClass();
        if (BlightbusterConfig.purifiedMappings.containsKey(clazz)) {
            try {
                CleansingHelper.cleanseSingleMob(entity, (EntityLivingBase)BlightbusterConfig.purifiedMappings.get(clazz).newInstance(world));
                return true;
            }
            catch (Exception e) {
                BlightBuster.logger.error("Failed to cleanse entity from mapping: " + clazz.getName(), (Throwable)e);
            }
        }
        if (BlightbusterConfig.customNpcSupport && entity instanceof EntityCustomNpc) {
            EntityCustomNpc npc = (EntityCustomNpc)entity;
            if (BlightbusterConfig.customNpcMappings.containsKey(npc.linkedName)) {
                try {
                    CleansingHelper.cleanseSingleMob(entity, (EntityLivingBase)BlightbusterConfig.customNpcMappings.get(npc.linkedName).newInstance(world));
                    return true;
                }
                catch (Exception e) {
                    BlightBuster.logger.error("Failed to cleanse entity from mapping: " + npc.linkedName, (Throwable)e);
                }
            }
        }
        return false;
    }

    private static void cleanseSingleMob(Entity tainted, EntityLivingBase cleansed) {
        cleansed.func_82149_j(tainted);
        tainted.field_70170_p.func_72838_d((Entity)cleansed);
        cleansed.field_70170_p.func_72900_e(tainted);
        if (cleansed instanceof EntityVillager) {
            EntityVillager villager = (EntityVillager)cleansed;
            VillagerRegistry.applyRandomTrade((EntityVillager)villager, (Random)villager.field_70170_p.field_73012_v);
        }
    }

    public static boolean cleanseBiome(int x, int z, World world) {
        BiomeGenBase[] genBiomes = world.func_72959_q().func_76933_b(null, x, z, 1, 1);
        BiomeGenBase biome = world.func_72807_a(x, z);
        if ((biome.field_76756_M == Config.biomeTaintID || biome.field_76756_M == Config.biomeEerieID || biome.field_76756_M == Config.biomeMagicalForestID) && genBiomes != null && genBiomes.length > 0 && genBiomes[0] != null) {
            if (genBiomes[0].field_76756_M == Config.biomeTaintID) {
                BlightbusterNetwork.setBiomeAt(world, x, z, BlightbusterConfig.defaultBiome);
                return true;
            }
            if ((genBiomes[0].field_76756_M == Config.biomeEerieID || genBiomes[0].field_76756_M == Config.biomeMagicalForestID) && genBiomes[0].field_76756_M == biome.field_76756_M) {
                return false;
            }
            BlightbusterNetwork.setBiomeAt(world, x, z, genBiomes[0]);
            return true;
        }
        return false;
    }

    public static boolean cleanBlock(int x, int y, int z, World world) {
        boolean didSomething = false;
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (block == ConfigBlocks.blockTaintFibres) {
            world.func_147468_f(x, y, z);
            didSomething = true;
        } else if (block == ConfigBlocks.blockTaint) {
            if (meta == 2) {
                return didSomething;
            }
            if (meta == 0) {
                world.func_147465_d(x, y, z, ConfigBlocks.blockFluxGoo, ((BlockFluxGoo)ConfigBlocks.blockFluxGoo).getQuanta(), 3);
                didSomething = true;
            } else if (meta == 1) {
                world.func_147465_d(x, y, z, Blocks.field_150346_d, 0, 3);
                didSomething = true;
            } else {
                world.func_147468_f(x, y, z);
                didSomething = true;
            }
        }
        if (didSomething) {
            world.func_147471_g(x, y, z);
        }
        return didSomething;
    }
}

