/*
 * Decompiled with CFR 0.152.
 */
package talonos.blightbuster.rituals;

import WayofTime.alchemicalWizardry.api.renderer.MRSRenderer;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.rituals.Rituals;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.renderer.AlchemyCircleRenderer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import talonos.blightbuster.tileentity.DawnMachineTileEntity;
import thaumcraft.common.tiles.TileEtherealBloom;

public class RitualDawnMachine
extends RitualEffect {
    DawnMachineTileEntity dawnMachine;
    final int[][] bloomOffsets = new int[][]{{7, 3, 0}, {-7, 3, 0}, {5, 3, -5}, {5, 3, 5}, {0, 3, 7}, {0, 3, -7}, {-5, 3, -5}, {-5, 3, 5}};
    boolean going = false;

    public boolean startRitual(IMasterRitualStone ritualStone, EntityPlayer player) {
        if (!this.checkBlooms(ritualStone)) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("gui.ritual.missingBlooms", new Object[0]));
            return false;
        }
        this.going = true;
        return true;
    }

    public void performEffect(IMasterRitualStone ritualStone) {
        int z;
        int y;
        int x;
        this.going = this.checkBlooms(ritualStone);
        if (!this.going) {
            return;
        }
        String owner = ritualStone.getOwner();
        int currentEssence = SoulNetworkHandler.getCurrentEssence((String)owner);
        World world = ritualStone.getWorld();
        if (!(world.func_147438_o(x = ritualStone.getXCoord(), (y = ritualStone.getYCoord()) + 2, z = ritualStone.getZCoord()) instanceof DawnMachineTileEntity)) {
            return;
        }
        this.dawnMachine = (DawnMachineTileEntity)world.func_147438_o(x, y + 2, z);
        int bloodToAdd = Math.min(currentEssence, this.getCostPerRefresh());
        int actuallyAdd = this.dawnMachine.addBlood(bloodToAdd, true);
        if (currentEssence < actuallyAdd) {
            SoulNetworkHandler.causeNauseaToPlayer((String)owner);
            return;
        }
        this.dawnMachine.addBlood(actuallyAdd, false);
        SoulNetworkHandler.syphonFromNetwork((String)owner, (int)actuallyAdd);
    }

    public int getCostPerRefresh() {
        return 500;
    }

    public List<RitualComponent> getRitualComponentList() {
        ArrayList<RitualComponent> dawnMachineRitual = new ArrayList<RitualComponent>();
        dawnMachineRitual.add(new RitualComponent(1, 0, 0, 3));
        dawnMachineRitual.add(new RitualComponent(2, 0, 0, 1));
        dawnMachineRitual.add(new RitualComponent(4, 0, 0, 4));
        dawnMachineRitual.add(new RitualComponent(5, 1, 0, 6));
        dawnMachineRitual.add(new RitualComponent(7, 1, 0, 4));
        dawnMachineRitual.add(new RitualComponent(7, 2, 0, 5));
        dawnMachineRitual.add(new RitualComponent(0, 0, -1, 3));
        dawnMachineRitual.add(new RitualComponent(4, 0, -1, 0));
        dawnMachineRitual.add(new RitualComponent(6, 0, 0, 1));
        dawnMachineRitual.add(new RitualComponent(0, 0, -2, 1));
        dawnMachineRitual.add(new RitualComponent(2, 0, -2, 4));
        dawnMachineRitual.add(new RitualComponent(4, 0, -2, 2));
        dawnMachineRitual.add(new RitualComponent(3, 1, -3, 6));
        dawnMachineRitual.add(new RitualComponent(0, 0, -4, 4));
        dawnMachineRitual.add(new RitualComponent(1, 0, -4, 0));
        dawnMachineRitual.add(new RitualComponent(2, 0, -4, 2));
        dawnMachineRitual.add(new RitualComponent(0, 1, -5, 6));
        dawnMachineRitual.add(new RitualComponent(5, 1, -5, 2));
        dawnMachineRitual.add(new RitualComponent(5, 2, -5, 5));
        dawnMachineRitual.add(new RitualComponent(1, 0, -6, 3));
        dawnMachineRitual.add(new RitualComponent(0, 1, -7, 4));
        dawnMachineRitual.add(new RitualComponent(0, 2, -7, 5));
        dawnMachineRitual.add(new RitualComponent(0, 0, 1, 3));
        dawnMachineRitual.add(new RitualComponent(4, 0, 1, 0));
        dawnMachineRitual.add(new RitualComponent(6, 0, 0, 1));
        dawnMachineRitual.add(new RitualComponent(0, 0, 2, 1));
        dawnMachineRitual.add(new RitualComponent(2, 0, 2, 4));
        dawnMachineRitual.add(new RitualComponent(4, 0, 2, 2));
        dawnMachineRitual.add(new RitualComponent(3, 1, 3, 6));
        dawnMachineRitual.add(new RitualComponent(0, 0, 4, 4));
        dawnMachineRitual.add(new RitualComponent(1, 0, 4, 0));
        dawnMachineRitual.add(new RitualComponent(2, 0, 4, 2));
        dawnMachineRitual.add(new RitualComponent(0, 1, 5, 6));
        dawnMachineRitual.add(new RitualComponent(5, 1, 5, 2));
        dawnMachineRitual.add(new RitualComponent(5, 2, 5, 5));
        dawnMachineRitual.add(new RitualComponent(1, 0, 6, 3));
        dawnMachineRitual.add(new RitualComponent(0, 1, 7, 4));
        dawnMachineRitual.add(new RitualComponent(0, 2, 7, 5));
        dawnMachineRitual.add(new RitualComponent(-1, 0, 0, 3));
        dawnMachineRitual.add(new RitualComponent(-2, 0, 0, 1));
        dawnMachineRitual.add(new RitualComponent(-4, 0, 0, 4));
        dawnMachineRitual.add(new RitualComponent(-5, 1, 0, 6));
        dawnMachineRitual.add(new RitualComponent(-7, 1, 0, 4));
        dawnMachineRitual.add(new RitualComponent(-7, 2, 0, 5));
        dawnMachineRitual.add(new RitualComponent(-4, 0, -1, 0));
        dawnMachineRitual.add(new RitualComponent(-6, 0, 0, 1));
        dawnMachineRitual.add(new RitualComponent(-2, 0, -2, 4));
        dawnMachineRitual.add(new RitualComponent(-4, 0, -2, 2));
        dawnMachineRitual.add(new RitualComponent(-3, 1, -3, 6));
        dawnMachineRitual.add(new RitualComponent(-1, 0, -4, 0));
        dawnMachineRitual.add(new RitualComponent(-2, 0, -4, 2));
        dawnMachineRitual.add(new RitualComponent(-5, 1, -5, 2));
        dawnMachineRitual.add(new RitualComponent(-5, 2, -5, 5));
        dawnMachineRitual.add(new RitualComponent(-1, 0, -6, 3));
        dawnMachineRitual.add(new RitualComponent(-4, 0, 1, 0));
        dawnMachineRitual.add(new RitualComponent(-6, 0, 0, 1));
        dawnMachineRitual.add(new RitualComponent(-2, 0, 2, 4));
        dawnMachineRitual.add(new RitualComponent(-4, 0, 2, 2));
        dawnMachineRitual.add(new RitualComponent(-3, 1, 3, 6));
        dawnMachineRitual.add(new RitualComponent(-1, 0, 4, 0));
        dawnMachineRitual.add(new RitualComponent(-2, 0, 4, 2));
        dawnMachineRitual.add(new RitualComponent(-5, 1, 5, 2));
        dawnMachineRitual.add(new RitualComponent(-5, 2, 5, 5));
        dawnMachineRitual.add(new RitualComponent(-1, 0, 6, 3));
        return dawnMachineRitual;
    }

    private boolean checkBloomExists(IMasterRitualStone ritualStone, int[] coords) {
        World world = ritualStone.getWorld();
        int x = ritualStone.getXCoord();
        int y = ritualStone.getYCoord();
        int z = ritualStone.getZCoord();
        TileEntity tile = world.func_147438_o(x + coords[0], y + coords[1], z + coords[2]);
        return tile instanceof TileEtherealBloom;
    }

    public static void init() {
        Rituals.registerRitual((String)"BBDawnMachineRitual", (int)1, (int)10000, (RitualEffect)new RitualDawnMachine(), (String)"Ritual of the New Dawn", (MRSRenderer)new AlchemyCircleRenderer(new ResourceLocation("alchemicalwizardry:textures/models/SimpleTransCircle.png"), 0, 0, 0, 255, 0.0, 0.501, 0.501, 0.0, 3.0, true));
    }

    public boolean checkBlooms(IMasterRitualStone ritualStone) {
        for (int[] offset : this.bloomOffsets) {
            if (this.checkBloomExists(ritualStone, offset)) continue;
            return false;
        }
        return true;
    }
}

