/*
 * Decompiled with CFR 0.152.
 */
package talonos.blightbuster.tileentity;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import talonos.blightbuster.blocks.BBBlock;
import talonos.blightbuster.tileentity.DawnMachineTileEntity;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;

public class DawnMachineSpoutTileEntity
extends TileEntity
implements IEssentiaTransport,
IAspectContainer {
    protected DawnMachineTileEntity getController() {
        TileEntity controller = BBBlock.dawnMachineInput.getMultiblockController(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (!(controller instanceof DawnMachineTileEntity)) {
            return null;
        }
        return (DawnMachineTileEntity)controller;
    }

    public void func_145845_h() {
        super.func_145845_h();
        DawnMachineTileEntity controller = this.getController();
        if (controller == null) {
            return;
        }
        if (!this.field_145850_b.field_72995_K && this.func_145831_w().func_72820_D() % 5L == 0L) {
            for (int i = 0; i < 6; ++i) {
                TileEntity te;
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                Aspect aspect = this.getEssentiaType(dir);
                if (aspect == null || !controller.needsMore(aspect) || (te = ThaumcraftApiHelper.getConnectableTile((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (ForgeDirection)dir)) == null) continue;
                IEssentiaTransport ic = (IEssentiaTransport)te;
                if (!ic.canOutputTo(dir.getOpposite())) {
                    return;
                }
                if (ic.getSuctionAmount(dir.getOpposite()) >= this.getSuctionAmount(dir)) continue;
                this.addToContainer(aspect, ic.takeEssentia(aspect, 1, dir.getOpposite()));
            }
        }
    }

    public AspectList getAspects() {
        DawnMachineTileEntity controller = this.getController();
        return controller == null ? new AspectList() : this.getController().getAspects();
    }

    public void setAspects(AspectList aspectList) {
        DawnMachineTileEntity controller = this.getController();
        if (controller != null) {
            controller.setAspects(aspectList);
        }
    }

    public boolean doesContainerAccept(Aspect aspect) {
        DawnMachineTileEntity controller = this.getController();
        return controller != null && controller.doesContainerAccept(aspect);
    }

    public int addToContainer(Aspect aspect, int i) {
        if (i == 0) {
            return 0;
        }
        DawnMachineTileEntity controller = this.getController();
        return controller == null ? i : controller.addToContainer(aspect, i);
    }

    public boolean takeFromContainer(Aspect aspect, int i) {
        DawnMachineTileEntity controller = this.getController();
        return controller != null && controller.takeFromContainer(aspect, i);
    }

    public boolean takeFromContainer(AspectList aspectList) {
        DawnMachineTileEntity controller = this.getController();
        return controller != null && controller.takeFromContainer(aspectList);
    }

    public boolean doesContainerContainAmount(Aspect aspect, int i) {
        DawnMachineTileEntity controller = this.getController();
        return controller != null && controller.doesContainerContainAmount(aspect, i);
    }

    public boolean doesContainerContain(AspectList aspectList) {
        DawnMachineTileEntity controller = this.getController();
        return controller != null && controller.doesContainerContain(aspectList);
    }

    public int containerContains(Aspect aspect) {
        DawnMachineTileEntity controller = this.getController();
        return controller == null ? 0 : controller.containerContains(aspect);
    }

    public boolean isConnectable(ForgeDirection forgeDirection) {
        return this.getEssentiaType(forgeDirection) != null;
    }

    public boolean canInputFrom(ForgeDirection forgeDirection) {
        return this.isConnectable(forgeDirection);
    }

    public boolean canOutputTo(ForgeDirection forgeDirection) {
        return false;
    }

    public void setSuction(Aspect aspect, int i) {
    }

    public Aspect getSuctionType(ForgeDirection forgeDirection) {
        return this.getEssentiaType(forgeDirection);
    }

    public int getSuctionAmount(ForgeDirection forgeDirection) {
        DawnMachineTileEntity controller = this.getController();
        if (controller == null) {
            return 0;
        }
        Aspect aspect = this.getEssentiaType(forgeDirection);
        return controller.needsMore(aspect) ? 256 : 0;
    }

    public int takeEssentia(Aspect aspect, int amount, ForgeDirection face) {
        return this.canOutputTo(face) && this.takeFromContainer(aspect, amount) ? amount : 0;
    }

    public int addEssentia(Aspect aspect, int amount, ForgeDirection face) {
        return this.canInputFrom(face) ? amount - this.addToContainer(aspect, amount) : 0;
    }

    public Aspect getEssentiaType(ForgeDirection forgeDirection) {
        int meta = this.func_145831_w().func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return BBBlock.dawnMachineInput.getSpoutAspect(forgeDirection.ordinal(), meta);
    }

    public int getEssentiaAmount(ForgeDirection forgeDirection) {
        DawnMachineTileEntity controller = this.getController();
        if (controller == null) {
            return 0;
        }
        return controller.containerContains(this.getEssentiaType(forgeDirection));
    }

    public int getMinimumSuction() {
        return 256;
    }

    public boolean renderExtendedTube() {
        return true;
    }
}

