/*
 * Decompiled with CFR 0.152.
 */
package talonos.blightbuster.tileentity;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import cofh.api.energy.IEnergyReceiver;
import cofh.api.energy.IEnergyStorage;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import noppes.npcs.entity.EntityCustomNpc;
import org.apache.commons.lang3.ArrayUtils;
import talonos.blightbuster.BlightBuster;
import talonos.blightbuster.BlightbusterConfig;
import talonos.blightbuster.lib.CleansingHelper;
import talonos.blightbuster.network.BlightbusterNetwork;
import talonos.blightbuster.network.packets.SpawnCleanseParticlesPacket;
import talonos.blightbuster.tileentity.dawnmachine.DawnMachineResource;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IAspectSource;
import thaumcraft.api.nodes.NodeType;
import thaumcraft.common.blocks.BlockFluxGoo;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.entities.EntityFallingTaint;
import thaumcraft.common.entities.monster.EntityTaintSporeSwarmer;
import thaumcraft.common.tiles.TileNode;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;
import vazkii.botania.api.mana.spark.SparkHelper;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.api.energy.IEnergyReceiver", modid="CoFHCore"), @Optional.Interface(iface="cofh.api.energy.IEnergyStorage", modid="CoFHCore"), @Optional.Interface(iface="vazkii.botania.api.mana.spark.ISparkAttachable", modid="Botania")})
public class DawnMachineTileEntity
extends TileEntity
implements IAspectSource,
IAspectContainer,
IEnergyReceiver,
IEnergyStorage,
ISparkAttachable,
IFluidTank,
IFluidHandler {
    public static int[] coords = null;
    private static final int MAX_BLOOD = 100000;
    private static Fluid blood = null;
    private FluidStack fluid = null;
    private FluidTankInfo tankInfo = null;
    private FluidTankInfo[] tankInfoArray = null;
    private static final int MAX_MANA = 3000000;
    private int currentMana = 0;
    private static final Function<DawnMachineTileEntity, Void> registerManaTransfer = BlightbusterConfig.enableMana ? dawnmachine -> {
        ISparkEntity spark = dawnmachine.getAttachedSpark();
        if (spark != null) {
            List sparkEntities = SparkHelper.getSparksAround((World)dawnmachine.field_145850_b, (double)((double)dawnmachine.field_145851_c + 0.5), (double)((double)dawnmachine.field_145848_d + 0.5), (double)((double)dawnmachine.field_145849_e + 0.5));
            for (ISparkEntity otherSpark : sparkEntities) {
                if (spark == otherSpark || otherSpark.getAttachedTile() == null || !(otherSpark.getAttachedTile() instanceof IManaPool)) continue;
                otherSpark.registerTransfer(spark);
            }
        }
        return null;
    } : dawnmachine -> null;
    public static final int DEAD_RF = 150;
    protected static final int MAX_RF = 1280000;
    protected static final int FULLGREEN_RF = 80000;
    protected static final int FULLYELLOW_RF = 40000;
    protected static final int FULLRED_RF = 20000;
    protected static final Vec3 COLOR_GREEN = Vec3.func_72443_a((double)0.0, (double)0.9, (double)0.0);
    protected static final Vec3 COLOR_YELLOW = Vec3.func_72443_a((double)0.9, (double)0.9, (double)0.0);
    protected static final Vec3 COLOR_RED = Vec3.func_72443_a((double)0.9, (double)0.0, (double)0.0);
    private int currentRF = 0;
    private final AspectList internalAspectList = new AspectList();
    public int chunkX = Integer.MAX_VALUE;
    public int chunkZ = Integer.MAX_VALUE;
    private int lastChunkX = Integer.MAX_VALUE;
    private int lastChunkZ = Integer.MAX_VALUE;
    private int ticksSinceLastCleanse = 0;
    int[] dawnMachineChunkCoords = null;
    int[][] scanlineCoords = null;
    int[][] scanlineAerCoords = null;
    int[] dawnMachineBlockCoords;
    int index = 0;
    int aerIndex = 0;
    private ForgeChunkManager.Ticket dawnMachineTicket;
    private boolean waiting = false;
    public final ArrayList<int[]> cleansedChunks = new ArrayList();
    public boolean isActive = false;
    Random rand = new Random(System.currentTimeMillis());
    private boolean init = true;

    public DawnMachineTileEntity() {
        if (BlightbusterConfig.enableBlood) {
            blood = AlchemicalWizardry.lifeEssenceFluid;
            this.fluid = new FluidStack(blood, 0);
            this.tankInfo = new FluidTankInfo(this.getFluid(), 100000);
            this.tankInfoArray = new FluidTankInfo[]{this.tankInfo};
        }
    }

    public void func_145845_h() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.init) {
            coords = new int[]{this.field_145851_c, this.field_145848_d, this.field_145849_e};
            this.dawnMachineBlockCoords = new int[]{this.field_145851_c, this.field_145849_e};
            this.scanlineCoords = this.generateScanlineCoords();
            this.scanlineAerCoords = this.generateScanlineAerCoords();
            this.dawnMachineChunkCoords = this.getDawnMachineChunkCoords();
            this.initializeChunkloading();
            this.init = false;
        }
        if (this.func_145831_w().func_72878_l(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1) > 0) {
            this.isActive = false;
            return;
        }
        this.isActive = true;
        registerManaTransfer.apply(this);
        int cleanseLength = this.haveEnoughFor(DawnMachineResource.MACHINA) ? 4 : 12;
        this.ticksSinceLastCleanse %= cleanseLength;
        if (this.ticksSinceLastCleanse == 0 || this.waiting) {
            Chunk chunk = this.getNextChunk();
            if (chunk == null) {
                return;
            }
            boolean anythingToDo = this.hasAnythingToCleanseHere(chunk);
            int count = 0;
            while (!anythingToDo && count <= 10 && !this.waiting && this.haveEnoughFor(DawnMachineResource.COGNITIO)) {
                this.spend(DawnMachineResource.COGNITIO);
                chunk = this.getNextChunk();
                if (chunk == null) continue;
                anythingToDo = this.hasAnythingToCleanseHere(chunk);
                ++count;
            }
            if (cleanseLength == 4) {
                this.spend(DawnMachineResource.MACHINA);
            }
            if (anythingToDo) {
                this.executeCleanse(chunk);
                try {
                    this.cleansedChunks.add(new int[]{this.chunkX, this.chunkZ});
                }
                catch (Exception e) {
                    BlightBuster.logger.error((Object)e);
                    ((EntityPlayer)this.field_145850_b.field_73010_i.get(0)).func_146105_b((IChatComponent)new ChatComponentText(e.getMessage()));
                    throw e;
                }
            }
        }
        ++this.ticksSinceLastCleanse;
    }

    private Chunk getNextChunk() {
        Chunk chunk;
        if (!this.waiting) {
            this.unloadChunk();
            this.getNewCleanseCoords();
            this.loadChunk();
        }
        this.waiting = (chunk = DawnMachineTileEntity.getChunk(this.field_145850_b, this.chunkX, this.chunkZ)) == null;
        return chunk;
    }

    protected void executeCleanse(Chunk chunk) {
        List[] entityLists;
        for (List list : entityLists = chunk.field_76645_j) {
            for (Entity entity : list) {
                if (!(entity instanceof EntityTaintSporeSwarmer) && !(entity instanceof EntityFallingTaint) || !this.haveEnoughFor(DawnMachineResource.IGNIS)) continue;
                this.spend(DawnMachineResource.IGNIS);
                if (this.haveEnoughFor(DawnMachineResource.VACUOS)) {
                    this.spend(DawnMachineResource.VACUOS);
                } else {
                    this.func_145831_w().func_147465_d((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v, ConfigBlocks.blockFluxGoo, ((BlockFluxGoo)ConfigBlocks.blockFluxGoo).getQuanta(), 3);
                }
                entity.func_70106_y();
            }
        }
        this.cleanseBiome(chunk);
        boolean didUseIgnis = this.cleanseBlocks(chunk);
        if (this.haveEnoughFor(DawnMachineResource.SANO)) {
            this.cleanseMobs(chunk);
        }
        this.sendParticlePackets(didUseIgnis);
    }

    void sendParticlePackets(boolean didUseIgnis) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                BlightbusterNetwork.sendToNearbyPlayers(new SpawnCleanseParticlesPacket(this.lastChunkX * 16 + x, this.lastChunkZ * 16 + z, didUseIgnis, true), this.field_145850_b.field_73011_w.field_76574_g, this.lastChunkX * 16 + x, 128.0f, this.lastChunkZ * 16 + z, 150.0f);
            }
        }
    }

    protected boolean hasAnythingToCleanseHere(Chunk chunk) {
        int x;
        int z2;
        BiomeGenBase[] origBiome = null;
        for (z2 = 0; z2 < 16; ++z2) {
            for (x = 0; x < 16; ++x) {
                int[] coords = this.getBlockCoordsFromChunk(chunk, x, z2);
                origBiome = this.func_145831_w().func_72959_q().func_76933_b(origBiome, coords[0], coords[1], 1, 1);
                BiomeGenBase biome = this.func_145831_w().func_72807_a(coords[0], coords[1]);
                if (biome.field_76756_M != Config.biomeTaintID && (biome.field_76756_M != Config.biomeEerieID || origBiome[0].field_76756_M == Config.biomeEerieID) && (biome.field_76756_M != Config.biomeMagicalForestID || origBiome[0].field_76756_M == Config.biomeMagicalForestID)) continue;
                return true;
            }
        }
        if (this.haveEnoughFor(DawnMachineResource.SANO)) {
            List[] z2 = chunk.field_76645_j;
            x = z2.length;
            for (int coords = 0; coords < x; ++coords) {
                List list = z2[coords];
                for (Entity entity : list) {
                    if (entity instanceof EntityCustomNpc && BlightbusterConfig.customNpcSupport && BlightbusterConfig.customNpcMappings.containsKey(((EntityCustomNpc)entity).linkedName)) {
                        return true;
                    }
                    if (!BlightbusterConfig.purifiedMappings.containsKey(entity.getClass())) continue;
                    return true;
                }
            }
        }
        for (z2 = 0; z2 < 16; ++z2) {
            for (x = 0; x < 16; ++x) {
                int[] coords = this.getBlockCoordsFromChunk(chunk, x, z2);
                int herbaTopBlock = -1;
                boolean canHerba = this.haveEnoughFor(DawnMachineResource.HERBA);
                if (canHerba) {
                    herbaTopBlock = this.func_145831_w().func_72825_h(coords[0], coords[1]);
                }
                boolean canIgnis = this.haveEnoughFor(DawnMachineResource.IGNIS);
                boolean canVacuos = this.haveEnoughFor(DawnMachineResource.VACUOS);
                boolean canAura = this.haveEnoughFor(DawnMachineResource.AURAM);
                if (!canIgnis && !canVacuos && !canHerba && !canAura) continue;
                for (int i = 0; i < 256; ++i) {
                    TileNode node;
                    Block block = this.func_145831_w().func_147439_a(coords[0], i, coords[1]);
                    int meta = this.func_145831_w().func_72805_g(coords[0], i, coords[1]);
                    if (canIgnis && block == ConfigBlocks.blockTaintFibres) {
                        return true;
                    }
                    if (canIgnis && block == ConfigBlocks.blockTaint && meta != 2) {
                        return true;
                    }
                    if (canVacuos && block == ConfigBlocks.blockFluxGoo) {
                        return true;
                    }
                    if (canHerba && i == herbaTopBlock && block == Blocks.field_150346_d) {
                        return true;
                    }
                    if (!canAura || block != ConfigBlocks.blockAiry || meta != 0 || (node = (TileNode)this.func_145831_w().func_147438_o(coords[0], i, coords[1])) == null || node.getNodeType() != NodeType.TAINTED) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void cleanseBiome(Chunk chunk) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int[] coords = this.getBlockCoordsFromChunk(chunk, x, z);
                CleansingHelper.cleanseBiome(coords[0], coords[1], this.field_145850_b);
            }
        }
    }

    public int[] getBlockCoordsFromChunk(Chunk chunk, int x, int z) {
        return new int[]{chunk.field_76635_g * 16 + x, chunk.field_76647_h * 16 + z};
    }

    protected boolean cleanseBlocks(Chunk chunk) {
        boolean haveUsedIgnis = false;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                Block block;
                int[] coords = this.getBlockCoordsFromChunk(chunk, x, z);
                boolean canArbor = this.haveEnoughFor(DawnMachineResource.ARBOR);
                boolean canHerba = this.haveEnoughFor(DawnMachineResource.HERBA);
                boolean foundTopBlock = false;
                int topBlock = -1;
                int columnCrustedTaint = 0;
                for (int y = 255; y >= 0; --y) {
                    boolean thisIsCrustedTaint;
                    Block block2 = chunk.func_150810_a(x, y, z);
                    int meta = chunk.func_76628_c(x, y, z);
                    boolean bl = thisIsCrustedTaint = block2 == ConfigBlocks.blockTaint && meta == 0;
                    if (thisIsCrustedTaint && this.haveEnoughFor(DawnMachineResource.IGNIS) && this.haveEnoughFor(DawnMachineResource.VACUOS)) {
                        ++columnCrustedTaint;
                    }
                    if (!foundTopBlock && (canHerba || canArbor) && block2.func_149662_c()) {
                        foundTopBlock = true;
                        topBlock = y;
                    }
                    boolean didUseIgnis = this.cleanseSingleBlock(coords[0], y, coords[1], block2, meta, canHerba && foundTopBlock && y == topBlock);
                    boolean bl2 = haveUsedIgnis = didUseIgnis || haveUsedIgnis;
                    if (!didUseIgnis || this.func_145831_w().func_147439_a(coords[0], y, coords[1]) == Blocks.field_150346_d) continue;
                    foundTopBlock = false;
                }
                if (columnCrustedTaint >= 3 && foundTopBlock) {
                    BiomeGenBase biome = this.func_145831_w().func_72807_a(coords[0], coords[1]);
                    int treeType = DawnMachineTileEntity.getTreeType(biome);
                    this.func_145831_w().func_147465_d(coords[0], topBlock + 1, coords[1], Blocks.field_150345_g, treeType, 3);
                    this.spend(DawnMachineResource.ARBOR);
                }
                if (!foundTopBlock || !haveUsedIgnis) continue;
                BiomeGenBase biome = this.func_145831_w().func_72807_a(coords[0], coords[1]);
                String biomeName = biome.field_76791_y.toLowerCase(Locale.ENGLISH);
                if (!biomeName.contains("desert") && !biomeName.contains("msdune") || (block = this.func_145831_w().func_147439_a(coords[0], topBlock, coords[1])) != Blocks.field_150354_m) continue;
                int chance = this.rand.nextInt(500) + 1;
                boolean blockToSet = this.rand.nextBoolean();
                if (chance != 500) continue;
                if (blockToSet) {
                    this.func_145831_w().func_147449_b(coords[0], topBlock + 1, coords[1], Blocks.field_150434_aF);
                } else {
                    this.func_145831_w().func_147465_d(coords[0], topBlock + 1, coords[1], ConfigBlocks.blockCustomPlant, 3, 3);
                }
                this.spend(DawnMachineResource.ARBOR);
            }
        }
        return haveUsedIgnis;
    }

    private static int getTreeType(BiomeGenBase biome) {
        String biomeName = biome.field_76791_y.toLowerCase(Locale.ENGLISH);
        int treeType = 0;
        if (biomeName.contains("taiga") || biomeName.contains("tundra")) {
            treeType = 1;
        } else if (biomeName.contains("birch")) {
            treeType = 2;
        } else if (biomeName.contains("jungle")) {
            treeType = 3;
        } else if (biomeName.contains("savanna")) {
            treeType = 4;
        } else if (biomeName.contains("roof")) {
            treeType = 5;
        }
        return treeType;
    }

    private boolean cleanseSingleBlock(int x, int y, int z, Block block, int meta, boolean doHerbaCheck) {
        TileNode node;
        TileEntity tile;
        boolean canIgnis = this.haveEnoughFor(DawnMachineResource.IGNIS);
        boolean canVacuos = this.haveEnoughFor(DawnMachineResource.VACUOS);
        if (canIgnis && block == ConfigBlocks.blockTaint && meta == 0) {
            this.spend(DawnMachineResource.IGNIS);
            Block replaceBlock = ConfigBlocks.blockFluxGoo;
            int replaceMeta = ((BlockFluxGoo)ConfigBlocks.blockFluxGoo).getQuanta();
            if (this.haveEnoughFor(DawnMachineResource.VACUOS)) {
                this.spend(DawnMachineResource.VACUOS);
                replaceBlock = Blocks.field_150350_a;
                replaceMeta = 0;
            }
            this.func_145831_w().func_147465_d(x, y, z, replaceBlock, replaceMeta, 3);
            return true;
        }
        if (canIgnis && block == ConfigBlocks.blockTaint && meta == 1) {
            this.spend(DawnMachineResource.IGNIS);
            Object replaceBlock = Blocks.field_150346_d;
            if (doHerbaCheck) {
                this.spend(DawnMachineResource.HERBA);
                replaceBlock = this.func_145831_w().func_72807_a((int)x, (int)z).field_76756_M == 14 || this.func_145831_w().func_72807_a((int)x, (int)z).field_76756_M == 15 ? Blocks.field_150391_bh : Blocks.field_150349_c;
            }
            this.func_145831_w().func_147449_b(x, y, z, replaceBlock);
            return true;
        }
        if (canIgnis && block == ConfigBlocks.blockTaintFibres) {
            this.spend(DawnMachineResource.IGNIS);
            this.func_145831_w().func_147449_b(x, y, z, Blocks.field_150350_a);
            return true;
        }
        if (canVacuos && block == ConfigBlocks.blockFluxGoo) {
            this.spend(DawnMachineResource.VACUOS);
            this.func_145831_w().func_147449_b(x, y, z, Blocks.field_150350_a);
            return false;
        }
        if (doHerbaCheck && block == Blocks.field_150346_d) {
            this.spend(DawnMachineResource.HERBA);
            BlockGrass replaceBlock = Blocks.field_150349_c;
            if (this.func_145831_w().func_72807_a((int)x, (int)z).field_76756_M == 14 || this.func_145831_w().func_72807_a((int)x, (int)z).field_76756_M == 15) {
                replaceBlock = Blocks.field_150391_bh;
            }
            this.func_145831_w().func_147449_b(x, y, z, (Block)replaceBlock);
            return false;
        }
        if (this.haveEnoughFor(DawnMachineResource.AURAM) && "Thaumcraft".equals(GameRegistry.findUniqueIdentifierFor((Block)block).modId) && (tile = this.func_145831_w().func_147438_o(x, y, z)) instanceof TileNode && (node = (TileNode)tile).getNodeType() == NodeType.TAINTED) {
            this.spend(DawnMachineResource.AURAM);
            node.setNodeType(NodeType.NORMAL);
            node.func_70296_d();
            this.func_145831_w().func_147471_g(x, y, z);
        }
        return false;
    }

    protected void cleanseMobs(Chunk chunk) {
        List[] entityLists = (List[])chunk.field_76645_j.clone();
        for (int i = 0; i < entityLists.length; ++i) {
            for (int j = 0; j < entityLists[i].size(); ++j) {
                boolean spend = CleansingHelper.cleanseMobFromMapping((Entity)chunk.field_76645_j[i].get(j), this.field_145850_b);
                if (spend) {
                    this.spend(DawnMachineResource.SANO);
                }
                if (this.haveEnoughFor(DawnMachineResource.SANO)) continue;
                return;
            }
        }
    }

    private void getNewCleanseCoords() {
        this.lastChunkX = this.chunkX;
        this.lastChunkZ = this.chunkZ;
        boolean usedOrdo = false;
        if (this.haveEnoughFor(DawnMachineResource.ORDO)) {
            usedOrdo = true;
            this.getNextScanlineCoords(true);
        } else {
            this.generateRandomCoords(true);
        }
        boolean haveEnoughForAer = this.haveEnoughFor(DawnMachineResource.AER, this.getAerCost(this.chunkX, this.chunkZ));
        if (!haveEnoughForAer) {
            if (usedOrdo) {
                --this.index;
                this.getNextScanlineCoords(false);
            } else {
                this.generateRandomCoords(false);
            }
        }
        if (usedOrdo) {
            this.spend(DawnMachineResource.ORDO);
        }
        if (haveEnoughForAer) {
            this.spendAer();
        }
    }

    private void getNextScanlineCoords(boolean haveEnoughForAer) {
        int[] coords;
        if (haveEnoughForAer) {
            ++this.index;
            if (this.index == this.scanlineAerCoords.length) {
                this.index = 0;
            }
            coords = this.scanlineAerCoords[this.index];
        } else {
            ++this.aerIndex;
            if (this.aerIndex == this.scanlineCoords.length) {
                this.aerIndex = 0;
            }
            coords = this.scanlineCoords[this.aerIndex];
        }
        this.chunkX = coords[0];
        this.chunkZ = coords[1];
    }

    private int[][] generateScanlineAerCoords() {
        ArrayList<int[]> coords = new ArrayList<int[]>();
        coords.add(this.getDawnMachineChunkCoords());
        int[] startCoords = this.getDawnMachineChunkCoords();
        int startX = startCoords[0];
        int startZ = startCoords[1];
        int currentLocX = startX;
        int currentLocZ = startZ;
        int dx = 0;
        int dz = -1;
        int found_corners = 0;
        List<int[]> corners = Arrays.asList(BlightbusterConfig.useCorners ? BlightbusterConfig.dawnMachineCorners : this.generateCorners());
        while (found_corners != 4) {
            int[] current = new int[]{currentLocX, currentLocZ};
            int minX = Math.min(((int[])corners.get(0))[0], ((int[])corners.get(1))[0]);
            int maxX = Math.max(((int[])corners.get(0))[0], ((int[])corners.get(1))[0]);
            int minZ = Math.min(((int[])corners.get(0))[1], ((int[])corners.get(1))[1]);
            int maxZ = Math.max(((int[])corners.get(0))[1], ((int[])corners.get(1))[1]);
            if (currentLocX >= minX && currentLocX <= maxX && currentLocZ >= minZ && currentLocZ <= maxZ) {
                coords.add(current);
            }
            if (this.doesContain(corners, current)) {
                ++found_corners;
            }
            currentLocX += dx;
            currentLocZ += dz;
            if (!(dz == -1 ? currentLocX - startX - 1 == currentLocZ - startZ : Math.abs(currentLocX - startX) == Math.abs(currentLocZ - startZ))) continue;
            int t = dz;
            dz = dx;
            dx = -t;
        }
        int[][] returnval = new int[coords.size()][];
        for (int i = 0; i < coords.size(); ++i) {
            returnval[i] = (int[])coords.get(i);
        }
        return returnval;
    }

    private int[][] generateCorners() {
        int radius = BlightbusterConfig.maxDawnMachineRadius;
        return new int[][]{{this.dawnMachineChunkCoords[0] + radius, this.dawnMachineChunkCoords[1] + radius}, {this.dawnMachineChunkCoords[0] - radius, this.dawnMachineChunkCoords[1] - radius}, {this.dawnMachineChunkCoords[0] + radius, this.dawnMachineChunkCoords[1] - radius}, {this.dawnMachineChunkCoords[0] - radius, this.dawnMachineChunkCoords[1] + radius}};
    }

    private boolean doesContain(List<int[]> corners, int[] coords) {
        for (int[] corner : corners) {
            if (!Arrays.equals(corner, coords)) continue;
            return true;
        }
        return false;
    }

    private int[][] generateScanlineCoords() {
        int[] dawnMachineChunkCoords = this.getDawnMachineChunkCoords();
        int maxWidth = dawnMachineChunkCoords[0] + BlightbusterConfig.minDawnMachineRadius;
        int minWidth = dawnMachineChunkCoords[0] - BlightbusterConfig.minDawnMachineRadius;
        int maxHeight = dawnMachineChunkCoords[1] + BlightbusterConfig.minDawnMachineRadius;
        int minHeight = dawnMachineChunkCoords[1] - BlightbusterConfig.minDawnMachineRadius;
        int x = Math.abs(maxWidth - minWidth);
        int z = Math.abs(maxHeight - minHeight);
        int maxVal = x * z;
        int[][] coords = new int[x * z][2];
        int dx = 0;
        int dz = -1;
        for (int i = 0; i < maxVal; ++i) {
            coords[i] = new int[]{(x += dx) - dawnMachineChunkCoords[0], (z += dz) - dawnMachineChunkCoords[1]};
            if (!(dz == -1 ? z == x - 1 : Math.abs(z) == Math.abs(x))) continue;
            int ndx = -dz;
            int ndz = dx;
            dx = ndx;
            dz = ndz;
        }
        return coords;
    }

    private void generateRandomCoords(boolean haveEnoughForAer) {
        if (haveEnoughForAer) {
            int[][] corners = BlightbusterConfig.useCorners ? BlightbusterConfig.dawnMachineCorners : this.generateCorners();
            int maxX = Math.max(corners[0][0], corners[1][0]);
            int maxZ = Math.max(corners[0][1], corners[1][1]);
            this.chunkX = maxX;
            this.chunkZ = maxZ;
        } else {
            this.chunkX = this.rand.nextInt(BlightbusterConfig.minDawnMachineRadius * 2 + 1) - BlightbusterConfig.minDawnMachineRadius + this.getDawnMachineChunkCoords()[0];
            this.chunkZ = this.rand.nextInt(BlightbusterConfig.minDawnMachineRadius * 2 + 1) - BlightbusterConfig.minDawnMachineRadius + this.getDawnMachineChunkCoords()[1];
        }
    }

    private void spendAer() {
        int aerCost = this.getAerCost(this.chunkX, this.chunkZ);
        this.spend(DawnMachineResource.AER, aerCost);
    }

    public int getAerCost(int x, int z) {
        int cost = (int)Math.sqrt(Math.hypot(this.dawnMachineChunkCoords[0] - x, this.dawnMachineChunkCoords[1] - z));
        return Math.max(cost, 8);
    }

    private int getDiscount(DawnMachineResource resource, boolean simulate) {
        int energyCost = resource.getEnergyCost();
        int manaCost = resource.getManaCost();
        int bloodCost = resource.getBloodCost();
        int enoughRF = this.currentRF >= energyCost ? 1 : 0;
        int enoughMana = this.currentMana >= manaCost ? 1 : 0;
        int enoughBlood = this.fluid.amount >= bloodCost ? 1 : 0;
        int discountMultiplier = 1 << enoughRF + enoughMana + enoughBlood;
        if (!simulate) {
            this.currentRF = enoughRF > 0 ? this.currentRF - energyCost : this.currentRF;
            this.currentMana = enoughMana > 0 ? this.currentMana - manaCost : this.currentMana;
            this.fluid.amount = enoughBlood > 0 ? this.fluid.amount - bloodCost : this.fluid.amount;
        }
        return discountMultiplier;
    }

    public boolean haveEnoughFor(DawnMachineResource resource) {
        return this.haveEnoughFor(resource, resource.getAspectCost());
    }

    public boolean haveEnoughFor(DawnMachineResource resource, int cost) {
        int discountMultiplier = this.getDiscount(resource, true);
        return this.internalAspectList.getAmount(resource.getAspect()) >= (cost /= discountMultiplier);
    }

    public void spend(DawnMachineResource resource) {
        this.spend(resource, resource.getAspectCost());
    }

    public void spend(DawnMachineResource resource, int cost) {
        if (!this.haveEnoughFor(resource)) {
            return;
        }
        int discountMultiplier = this.getDiscount(resource, false);
        this.internalAspectList.remove(resource.getAspect(), cost /= discountMultiplier);
        this.signalUpdate();
    }

    public boolean needsMore(Aspect aspect) {
        DawnMachineResource relevantResource = DawnMachineResource.getResourceFromAspect(aspect);
        if (relevantResource == null) {
            return false;
        }
        return relevantResource.getMaximumValue() - this.internalAspectList.getAmount(aspect) >= relevantResource.getValueMultiplier();
    }

    public static Chunk getChunk(World world, int x, int z) {
        if (world.func_72863_F().func_73149_a(x, z)) {
            return world.func_72964_e(x, z);
        }
        return null;
    }

    private int[] getDawnMachineChunkCoords() {
        return new int[]{(int)Math.floor((double)this.field_145851_c / 16.0), (int)Math.floor((double)this.field_145849_e / 16.0)};
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readCustomNBT(tag);
    }

    private void readCustomNBT(NBTTagCompound tag) {
        this.index = tag.func_74762_e("Index");
        this.aerIndex = tag.func_74762_e("AerIndex");
        this.internalAspectList.readFromNBT(tag.func_74775_l("Essentia"));
        this.currentRF = tag.func_74762_e("CurrentRF");
        this.fluid.amount = tag.func_74762_e("Blood");
        this.currentMana = tag.func_74762_e("Mana");
        int[] unpackedCoords = tag.func_74759_k("CleansedChunks");
        this.cleansedChunks.clear();
        for (int i = 0; i < unpackedCoords.length - 1; i += 2) {
            try {
                this.cleansedChunks.add(new int[]{unpackedCoords[i], unpackedCoords[i + 1]});
                continue;
            }
            catch (Exception e) {
                BlightBuster.logger.error((Object)e);
                ((EntityPlayer)this.field_145850_b.field_73010_i.get(0)).func_146105_b((IChatComponent)new ChatComponentText(e.getMessage()));
                throw e;
            }
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.writeCustomNBT(tag);
    }

    private void writeCustomNBT(NBTTagCompound tag) {
        NBTTagCompound essentia = new NBTTagCompound();
        this.internalAspectList.writeToNBT(essentia);
        tag.func_74782_a("Essentia", (NBTBase)essentia);
        tag.func_74768_a("Index", this.index);
        tag.func_74768_a("AerIndex", this.aerIndex);
        tag.func_74768_a("CurrentRF", this.currentRF);
        tag.func_74768_a("Blood", this.fluid.amount);
        tag.func_74768_a("Mana", this.currentMana);
        ArrayList<Integer> unpackedCoords = new ArrayList<Integer>();
        for (int[] coords : this.cleansedChunks) {
            unpackedCoords.add(coords[0]);
            unpackedCoords.add(coords[1]);
        }
        tag.func_74783_a("CleansedChunks", ArrayUtils.toPrimitive((Integer[])unpackedCoords.toArray(new Integer[0])));
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeCustomNBT(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -999, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.readCustomNBT(pkt.func_148857_g());
    }

    protected void signalUpdate() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    public AspectList getAspects() {
        AspectList aspectList = new AspectList();
        for (DawnMachineResource resource : DawnMachineResource.values()) {
            int value = this.internalAspectList.getAmount(resource.getAspect());
            aspectList.add(resource.getAspect(), value /= resource.getValueMultiplier());
        }
        return aspectList;
    }

    public void setAspects(AspectList aspectList) {
    }

    public boolean doesContainerAccept(Aspect aspect) {
        return DawnMachineResource.getResourceFromAspect(aspect) != null;
    }

    public int addToContainer(Aspect aspect, int i) {
        DawnMachineResource relevantResource = DawnMachineResource.getResourceFromAspect(aspect);
        if (relevantResource == null) {
            return i;
        }
        int currentValue = this.internalAspectList.getAmount(aspect);
        int remainingRoom = relevantResource.getMaximumValue() - currentValue;
        int essentiaRemaining = remainingRoom / relevantResource.getValueMultiplier();
        if (essentiaRemaining > 0) {
            int essentiaToMove = Math.min(i, essentiaRemaining);
            i -= essentiaToMove;
            this.internalAspectList.add(aspect, essentiaToMove * relevantResource.getValueMultiplier());
            this.signalUpdate();
        }
        return i;
    }

    public boolean takeFromContainer(Aspect aspect, int i) {
        return false;
    }

    public boolean takeFromContainer(AspectList aspectList) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect aspect, int i) {
        if (i == 0) {
            return true;
        }
        DawnMachineResource relevantResource = DawnMachineResource.getResourceFromAspect(aspect);
        if (relevantResource == null) {
            return false;
        }
        int currentValue = this.internalAspectList.getAmount(aspect) / relevantResource.getValueMultiplier();
        return currentValue >= i;
    }

    public boolean doesContainerContain(AspectList aspectList) {
        boolean successful = true;
        for (Aspect aspect : aspectList.getAspects()) {
            successful = this.doesContainerContainAmount(aspect, aspectList.getAmount(aspect)) && successful;
        }
        return successful;
    }

    public int containerContains(Aspect aspect) {
        DawnMachineResource relevantResource = DawnMachineResource.getResourceFromAspect(aspect);
        if (relevantResource == null) {
            return 0;
        }
        return this.internalAspectList.getAmount(aspect) / relevantResource.getValueMultiplier();
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (!BlightbusterConfig.enableRf || from != ForgeDirection.DOWN) {
            return 0;
        }
        int room = 1280000 - this.currentRF;
        int actualReceive = Math.min(maxReceive, room);
        if (!simulate) {
            this.currentRF += actualReceive;
        }
        this.signalUpdate();
        return actualReceive;
    }

    public int getEnergyStored(ForgeDirection from) {
        if (from != ForgeDirection.DOWN) {
            return 0;
        }
        return this.currentRF;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        if (from != ForgeDirection.DOWN) {
            return 0;
        }
        return 1280000;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return from == ForgeDirection.DOWN;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.receiveEnergy(ForgeDirection.DOWN, maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.currentRF;
    }

    public int getMaxEnergyStored() {
        return 1280000;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public int getFluidAmount() {
        return this.fluid.amount;
    }

    public int getCapacity() {
        return 100000;
    }

    public FluidTankInfo getInfo() {
        return this.tankInfo;
    }

    public int fill(FluidStack fluidstack, boolean simulate) {
        if (fluidstack.getFluid().getID() == blood.getID()) {
            int change = Math.max(Math.min(100000 - this.fluid.amount, fluidstack.amount), 0);
            if (!simulate) {
                this.fluid.amount += change;
            }
            return change;
        }
        return 0;
    }

    public FluidStack drain(int amount, boolean simulate) {
        return null;
    }

    public int fill(ForgeDirection direction, FluidStack fluidstack, boolean simulate) {
        return this.fill(fluidstack, simulate);
    }

    public FluidStack drain(ForgeDirection direction, FluidStack fluidstack, boolean simulate) {
        return null;
    }

    public FluidStack drain(ForgeDirection direction, int amount, boolean simulate) {
        return null;
    }

    public boolean canFill(ForgeDirection direction, Fluid fluid) {
        return BlightbusterConfig.enableBlood;
    }

    public boolean canDrain(ForgeDirection direction, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection direction) {
        return this.tankInfoArray;
    }

    public int addBlood(int bloodAmount, boolean simulate) {
        FluidStack blood = new FluidStack(DawnMachineTileEntity.blood, bloodAmount);
        return this.fill(blood, simulate);
    }

    public boolean isFull() {
        return this.currentMana >= 3000000;
    }

    public void recieveMana(int mana) {
        this.currentMana = Math.max(0, Math.min(3000000, this.currentMana + mana * 3));
        this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    public boolean canRecieveManaFromBursts() {
        return true;
    }

    public boolean canAttachSpark(ItemStack stack) {
        return BlightbusterConfig.enableMana;
    }

    public void attachSpark(ISparkEntity entity) {
    }

    public ISparkEntity getAttachedSpark() {
        List sparks = this.field_145850_b.func_72872_a(ISparkEntity.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 1)));
        if (sparks.size() == 1) {
            Entity e = (Entity)sparks.get(0);
            return (ISparkEntity)e;
        }
        return null;
    }

    public boolean areIncomingTranfersDone() {
        return this.currentMana >= 3000000;
    }

    public int getAvailableSpaceForMana() {
        return BlightbusterConfig.enableMana ? Math.max(0, (3000000 - this.currentMana) / 3) : 0;
    }

    public int getCurrentMana() {
        return this.currentMana;
    }

    private void initializeChunkloading() {
        this.dawnMachineTicket = ForgeChunkManager.requestTicket((Object)BlightBuster.instance, (World)this.func_145831_w(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (this.dawnMachineTicket == null) {
            this.releaseTickets();
            this.initializeChunkloading();
        }
        this.dawnMachineTicket.getModData().func_74778_a("id", "DawnMachine");
        int[] dawnMachineCoords = this.getDawnMachineChunkCoords();
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.dawnMachineTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(dawnMachineCoords[0], dawnMachineCoords[1]));
    }

    private void releaseTickets() {
        try {
            Field field = ForgeChunkManager.class.getDeclaredField("tickets");
            field.setAccessible(true);
            Map tickets = (Map)field.get(ForgeChunkManager.class);
            LinkedList toRelease = new LinkedList(((Multimap)tickets.get(this.field_145850_b)).get((Object)"blightbuster"));
            for (ForgeChunkManager.Ticket ticket : toRelease) {
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadChunk() {
        this.loadChunk(this.chunkX, this.chunkZ);
    }

    private void loadChunk(int x, int z) {
        if (Arrays.equals(new int[]{x, z}, this.getDawnMachineChunkCoords())) {
            return;
        }
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.dawnMachineTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(x, z));
    }

    private void unloadChunk() {
        this.unloadChunk(this.chunkX, this.chunkZ);
    }

    private void unloadChunk(int x, int z) {
        if (Arrays.equals(new int[]{x, z}, this.getDawnMachineChunkCoords()) || !this.isChunkLoaded(x, z)) {
            return;
        }
        ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.dawnMachineTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(x, z));
    }

    private boolean isChunkLoaded(int x, int z) {
        for (ChunkCoordIntPair coords : this.dawnMachineTicket.getChunkList()) {
            if (coords.field_77276_a != x || coords.field_77275_b != z) continue;
            return true;
        }
        return false;
    }

    public void func_145843_s() {
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.dawnMachineTicket);
        super.func_145843_s();
    }

    public Vec3 getGlowColor() {
        if (this.currentRF >= 80000) {
            return COLOR_GREEN;
        }
        if (this.currentRF >= 40000) {
            double progress = (double)(this.currentRF - 40000) / 40000.0;
            return this.interpColor(COLOR_GREEN, COLOR_YELLOW, progress);
        }
        if (this.currentRF >= 20000) {
            double progress = (double)(this.currentRF - 20000) / 20000.0;
            return this.interpColor(COLOR_YELLOW, COLOR_RED, progress);
        }
        if (this.currentRF > 150) {
            return COLOR_RED;
        }
        return null;
    }

    protected Vec3 interpColor(Vec3 left, Vec3 right, double progress) {
        double red = (left.field_72450_a - right.field_72450_a) * progress;
        double green = (left.field_72448_b - right.field_72448_b) * progress;
        double blue = (left.field_72449_c - right.field_72449_c) * progress;
        return Vec3.func_72443_a((double)(right.field_72450_a + red), (double)(right.field_72448_b + green), (double)(right.field_72449_c + blue));
    }

    public void updatePos() {
        this.dawnMachineChunkCoords = this.getDawnMachineChunkCoords();
    }

    public static void deconstruct(World world, int x, int y, int z) {
        coords = null;
    }
}

