/*
 * Decompiled with CFR 0.152.
 */
package talonos.blightbuster.tileentity.dawnmachine;

import thaumcraft.api.aspects.Aspect;

public enum DawnMachineResource {
    SANO(Aspect.HEAL, 2048, 8, 65536, 32, 20, 12, 0.6f, 0.5f),
    IGNIS(Aspect.FIRE, 8192, 8, 262144, 8, 20, 12, 0.0f, 0.5f),
    AER(Aspect.AIR, 512, 8, 16384, 128, 30, 37, 0.0f, 0.0f),
    COGNITIO(Aspect.MIND, 512, 256, 16384, 128, 20, 25, 0.6f, 0.0f),
    MACHINA(Aspect.MECHANISM, 512, 256, 16384, 128, 50, 25, 0.2f, 0.5f),
    AURAM(Aspect.AURA, 4, 16, 128, 16000, 1000, 50, 0.4f, 0.0f),
    VACUOS(Aspect.VOID, 2048, 8, 65536, 16, 30, 12, 0.8f, 0.5f),
    ORDO(Aspect.ORDER, 512, 256, 16384, 128, 100, 37, 0.4f, 0.5f),
    ARBOR(Aspect.TREE, 1024, 8, 32768, 32, 30, 25, 0.2f, 0.0f),
    HERBA(Aspect.PLANT, 2048, 8, 65536, 16, 50, 12, 0.8f, 0.0f);

    private final Aspect aspect;
    private final int valueMultiplier;
    private final int cost;
    private final int maximumValue;
    private final int rfDiscountCost;
    private final int manaDiscountCost;
    private final int bloodDiscountCost;
    private final float u;
    private final float v;

    private DawnMachineResource(Aspect aspect, int valueMultiplier, int cost, int maximumValue, int rfDiscountCost, int manaDiscountCost, int bloodDiscountCost, float u, float v) {
        this.aspect = aspect;
        this.valueMultiplier = valueMultiplier;
        this.cost = cost;
        this.maximumValue = maximumValue;
        this.rfDiscountCost = rfDiscountCost;
        this.manaDiscountCost = manaDiscountCost;
        this.bloodDiscountCost = bloodDiscountCost;
        this.u = u;
        this.v = v;
    }

    public Aspect getAspect() {
        return this.aspect;
    }

    public int getValueMultiplier() {
        return this.valueMultiplier;
    }

    public int getAspectCost() {
        return this.cost;
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    public int getEnergyCost() {
        return this.rfDiscountCost;
    }

    public int getManaCost() {
        return this.manaDiscountCost;
    }

    public int getBloodCost() {
        return this.bloodDiscountCost;
    }

    public float getU() {
        return this.u;
    }

    public float getV() {
        return this.v;
    }

    public static DawnMachineResource getResourceFromAspect(Aspect aspect) {
        if (aspect == Aspect.HEAL) {
            return SANO;
        }
        if (aspect == Aspect.FIRE) {
            return IGNIS;
        }
        if (aspect == Aspect.AIR) {
            return AER;
        }
        if (aspect == Aspect.MIND) {
            return COGNITIO;
        }
        if (aspect == Aspect.MECHANISM) {
            return MACHINA;
        }
        if (aspect == Aspect.AURA) {
            return AURAM;
        }
        if (aspect == Aspect.VOID) {
            return VACUOS;
        }
        if (aspect == Aspect.ORDER) {
            return ORDO;
        }
        if (aspect == Aspect.TREE) {
            return ARBOR;
        }
        if (aspect == Aspect.PLANT) {
            return HERBA;
        }
        return null;
    }
}

