/*
 * Decompiled with CFR 0.152.
 */
package midnight.filefix;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Iterator;
import java.util.List;
import midnight.filefix.FileFixWorldSavedData;
import net.fybertech.modelcitizens.TileEntityCorpse;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;

public class EnterChunkEventHandler {
    public EnterChunkEventHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        System.out.println("I am being created");
    }

    @SubscribeEvent
    public void onEnterChunk(EntityEvent.EnteringChunk event) {
        if (event.entity.field_70170_p.field_72995_K || !(event.entity instanceof EntityPlayerMP)) {
            return;
        }
        World world = event.entity.field_70170_p;
        FileFixWorldSavedData data = FileFixWorldSavedData.get(world);
        if (!data.broadswordFixed) {
            this.doSwordFix(event, world, data);
        }
        if (!data.caysykaBookFixed) {
            this.doCaysykaBookFix(event, world, data);
        }
    }

    private void doCaysykaBookFix(EntityEvent.EnteringChunk event, World world, FileFixWorldSavedData data) {
        if (event.newChunkX == -67 && event.newChunkZ == -64) {
            System.out.println("Fixing caysyka book");
            if (world.field_73011_w.field_76574_g != 0) {
                return;
            }
            String nbtString = "{id:387,Count:1,Damage:0,tag:{pages:[\"Caysyka is a great critic. While she makes sure people know she's not a designer, she speaks enough design language to intelligently and insightfully critique design decisions, making her an incredible tester. Also, she has a SA account, and posted the \",\"notification in SA that Blightfall was initially published. Given that CanVox learned about Blightfall from the SA thread, it's Caysyka's fault that Blightfall was discovered by Technic at all.\"],author:\"Talonos\",title:\"About Caysyka\"}}";
            TileEntityCorpse model = (TileEntityCorpse)world.func_147438_o(-1060, 142, -1021);
            ItemStack itemstack = new ItemStack(Items.field_151164_bB);
            NBTTagCompound tag = null;
            if (model == null) {
                System.out.println("Unable to find model");
                data.caysykaBookFixed = true;
                data.func_76185_a();
                return;
            }
            try {
                tag = (NBTTagCompound)JsonToNBT.func_150315_a((String)"{id:387,Count:1,Damage:0,tag:{pages:[\"Caysyka is a great critic. While she makes sure people know she's not a designer, she speaks enough design language to intelligently and insightfully critique design decisions, making her an incredible tester. Also, she has a SA account, and posted the \",\"notification in SA that Blightfall was initially published. Given that CanVox learned about Blightfall from the SA thread, it's Caysyka's fault that Blightfall was discovered by Technic at all.\"],author:\"Talonos\",title:\"About Caysyka\"}}");
            }
            catch (NBTException e) {
                e.printStackTrace();
                System.out.println("Error converting string to NBT");
                data.caysykaBookFixed = true;
                data.func_76185_a();
                return;
            }
            if (tag == null) {
                return;
            }
            itemstack.func_77963_c(tag);
            model.func_70299_a(1, itemstack);
            data.caysykaBookFixed = true;
            data.func_76185_a();
        }
    }

    public void doSwordFix(EntityEvent.EnteringChunk event, World world, FileFixWorldSavedData data) {
        if (event.newChunkX == 102 && event.newChunkZ == 7) {
            System.out.println("Fixing broadsword");
            if (world.field_73011_w.field_76574_g != 0) {
                return;
            }
            AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)1633.0, (double)42.0, (double)124.0, (double)1635.0, (double)44.0, (double)126.0);
            List chests = world.func_72872_a(EntityMinecartChest.class, box);
            Iterator iterator = chests.iterator();
            if (iterator.hasNext()) {
                EntityMinecartChest chest = (EntityMinecartChest)iterator.next();
                if (chest.func_70301_a(13) == null) {
                    String nbtString = "{id:4502,Count:1,Damage:0,tag:{InfiTool:{BaseDurability:405,Head:101,Tooltip1:\"\u00a7dBeheading\",ToolEXP:0l,Effect1:13,HarvestLevel:4,ModifierTip1:\"\u00a7dBeheading\",Attack:9,RenderHead:101,ModDurability:0.0f,Handle:14,Broken:0b,Shoddy:0.0f,RenderHandle:14,Accessory:123,MiningSpeed:500,RenderAccessory:123,ToolLevel:1,Unbreaking:2,Damage:0,Beheading:1,BonusDurability:0,Modifiers:0,TotalDurability:405},display:{Name:\"\u00a7fArtaxerxes\"}}}";
                    Item item = GameRegistry.findItem((String)"TConstruct", (String)"broadsword");
                    if (item == null) {
                        System.out.println("Failed to create item!");
                        data.caysykaBookFixed = true;
                        data.func_76185_a();
                    }
                    ItemStack itemstack = new ItemStack(item, 1, 0);
                    NBTTagCompound tag = null;
                    try {
                        tag = (NBTTagCompound)JsonToNBT.func_150315_a((String)"{id:4502,Count:1,Damage:0,tag:{InfiTool:{BaseDurability:405,Head:101,Tooltip1:\"\u00a7dBeheading\",ToolEXP:0l,Effect1:13,HarvestLevel:4,ModifierTip1:\"\u00a7dBeheading\",Attack:9,RenderHead:101,ModDurability:0.0f,Handle:14,Broken:0b,Shoddy:0.0f,RenderHandle:14,Accessory:123,MiningSpeed:500,RenderAccessory:123,ToolLevel:1,Unbreaking:2,Damage:0,Beheading:1,BonusDurability:0,Modifiers:0,TotalDurability:405},display:{Name:\"\u00a7fArtaxerxes\"}}}");
                    }
                    catch (NBTException e) {
                        System.out.println("Error converting string to NBT");
                        data.caysykaBookFixed = true;
                        data.func_76185_a();
                        return;
                    }
                    if (tag == null) {
                        return;
                    }
                    itemstack.func_77963_c(tag);
                    chest.func_70299_a(13, itemstack);
                }
                data.broadswordFixed = true;
                data.func_76185_a();
                return;
            }
        }
    }
}

