/*
 * Decompiled with CFR 0.152.
 */
package midnight.filefix;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import midnight.filefix.EnterChunkEventHandler;
import org.apache.commons.io.FileUtils;

@Mod(modid="blightfallfilefix", name="BlightfallFileFixer", version="1.0.2", dependencies="")
public class FileFix {
    public static final String MODID = "blightfallfilefix";
    public static final String MODNAME = "BlightfallFileFixer";
    public static final String VERSION = "1.0.2";
    public static final String DEPS = "";
    public EnterChunkEventHandler worldLoadEventHandler;

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.worldLoadEventHandler = new EnterChunkEventHandler();
        File check = new File(".filefixer.done");
        String oldVersion = this.getFileFixerVersion(check);
        System.out.println("Old FileFixer version: " + oldVersion);
        if (!VERSION.equals(this.getFileFixerVersion(check))) {
            System.out.println("Previous version: " + oldVersion + ". Current version: " + VERSION + ". Running fixes...");
            try {
                this.fixFiles();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            try {
                check.createNewFile();
                BufferedWriter bw = new BufferedWriter(new FileWriter(check));
                bw.write(VERSION);
                bw.close();
            }
            catch (IOException e) {
                System.out.println("Failed to create .filefixer.done");
                e.printStackTrace();
            }
        } else {
            System.out.println("Old version matches current version, skipping.");
        }
    }

    private void fixFiles() throws IOException {
        this.purgeTerrainControlConfigs();
    }

    private void purgeTerrainControlConfigs() {
        File world;
        File saves = new File("saves");
        if (saves.exists() && saves.isDirectory()) {
            for (File directory : saves.listFiles()) {
                if (!directory.isDirectory()) continue;
                File tc = new File(new File(directory, "TerrainControl"), "WorldBiomes");
                try {
                    System.out.println("Deleting " + tc.getCanonicalPath());
                    FileUtils.deleteDirectory((File)tc);
                }
                catch (IOException e) {
                    System.out.println("Failed to delete " + tc.getName());
                }
            }
        }
        if ((world = new File("world")).exists() && world.isDirectory()) {
            File tc = new File(new File(world, "TerrainControl"), "WorldBiomes");
            try {
                System.out.println("Deleting " + tc.getCanonicalPath());
                FileUtils.deleteDirectory((File)tc);
            }
            catch (IOException e) {
                System.out.println("Failed to delete " + tc.getName());
            }
        }
    }

    private String getFileFixerVersion(File file) {
        try {
            if (file.exists()) {
                BufferedReader br = new BufferedReader(new FileReader(file));
                return br.readLine();
            }
            return "0.0.0";
        }
        catch (IOException ex) {
            return "0.0.0";
        }
    }
}

