/*
 * Decompiled with CFR 0.152.
 */
package co.nidmight.blighttweaks.coremod.asm;

import co.nidmight.blighttweaks.coremod.asm.IAsmEditor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class BlockTaintedSandEditor
implements IAsmEditor {
    private final boolean isObfuscated;

    public BlockTaintedSandEditor(boolean isObfuscated) {
        this.isObfuscated = isObfuscated;
    }

    @Override
    public void edit(MethodNode method) {
        int i;
        String sandField = this.getCorrectSymbol("sand", "field_151595_p");
        int sandRef = -1;
        for (i = 0; i < method.instructions.size(); ++i) {
            AbstractInsnNode insn = method.instructions.get(i);
            if (insn.getOpcode() != 178 || !(insn instanceof FieldInsnNode)) continue;
            FieldInsnNode fieldInsn = (FieldInsnNode)insn;
            if (!fieldInsn.name.equals(sandField) || !fieldInsn.owner.equals("net/minecraft/block/material/Material")) continue;
            sandRef = i;
            break;
        }
        if (sandRef < 0) {
            throw new RuntimeException("BlightCore failed to find a reference to the field " + sandField + " when blocking tainted sand.");
        }
        for (i = sandRef + 1; i < method.instructions.size(); ++i) {
            AbstractInsnNode instruction = method.instructions.get(i);
            if (!(instruction instanceof FrameNode)) continue;
            AbstractInsnNode nextInstruction = method.instructions.get(i + 1);
            method.instructions.insertBefore(nextInstruction, (AbstractInsnNode)new VarInsnNode(25, 12));
            method.instructions.insertBefore(nextInstruction, (AbstractInsnNode)new FieldInsnNode(178, "net/minecraft/block/material/Material", sandField, "Lnet/minecraft/block/material/Material;"));
            LabelNode returnToMethod = new LabelNode();
            method.instructions.insertBefore(nextInstruction, (AbstractInsnNode)new JumpInsnNode(166, returnToMethod));
            method.instructions.insertBefore(nextInstruction, (AbstractInsnNode)new InsnNode(177));
            method.instructions.insertBefore(nextInstruction, (AbstractInsnNode)returnToMethod);
            return;
        }
    }

    @Override
    public String getClassName() {
        return "thaumcraft.common.blocks.BlockTaintFibres";
    }

    @Override
    public String getMethodName() {
        return this.getCorrectSymbol("updateTick", "func_149674_a");
    }

    @Override
    public String getMethodDesc() {
        return "(Lnet/minecraft/world/World;IIILjava/util/Random;)V";
    }

    private String getCorrectSymbol(String deobfuscated, String obfuscated) {
        return this.isObfuscated ? obfuscated : deobfuscated;
    }
}

