/*
 * Decompiled with CFR 0.152.
 */
package co.nidmight.blighttweaks.coremod.asm;

import co.nidmight.blighttweaks.coremod.asm.IAsmEditor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ItemStackManaPetalEditor
implements IAsmEditor {
    private boolean isObfuscated = false;
    private String nbtSymbol = "";

    public ItemStackManaPetalEditor(boolean isObfuscated) {
        this.isObfuscated = isObfuscated;
        this.nbtSymbol = this.getCorrectSymbol("net/minecraft/nbt/NBTTagCompound", "dh");
    }

    @Override
    public void edit(MethodNode method) {
        AbstractInsnNode firstInstruction = method.instructions.getFirst();
        if (firstInstruction == null) {
            throw new RuntimeException("BlightCore failed to find an injection point to remap mana petals.");
        }
        method.instructions.insertBefore(firstInstruction, (AbstractInsnNode)new VarInsnNode(25, 1));
        MethodInsnNode methodInstruction = new MethodInsnNode(184, "co/nidmight/blighttweaks/coremod/support/ManaPetalRemapSupport", "remapManaPetal", "(L" + this.nbtSymbol + ";)V", false);
        method.instructions.insertBefore(firstInstruction, (AbstractInsnNode)methodInstruction);
    }

    @Override
    public String getClassName() {
        return "net.minecraft.item.ItemStack";
    }

    @Override
    public String getMethodName() {
        return this.getCorrectSymbol("readFromNBT", "c");
    }

    @Override
    public String getMethodDesc() {
        return "(L" + this.nbtSymbol + ";)V";
    }

    private String getCorrectSymbol(String deobfuscated, String obfuscated) {
        return this.isObfuscated ? obfuscated : deobfuscated;
    }
}

