/*
 * Decompiled with CFR 0.152.
 */
package talonos.cavestokingdoms.client.pages;

import cpw.mods.fml.common.registry.GameRegistry;
import iguanaman.iguanatweakstconstruct.util.HarvestLevels;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import talonos.cavestokingdoms.client.pages.orediscovery.OreDiscoveryPage;

public class C2KMiningPage
extends OreDiscoveryPage {
    String title;
    ItemStack ore;
    int minheight = 0;
    int maxheight = 64;
    String location;
    int requiredLevel;
    int minesAsLevel = -1;
    String description;
    ResourceLocation background;
    String whereFound = "Unknown.";
    int locationImg = 0;
    int indexNum = 0;
    List<String> examples = new ArrayList<String>();

    public void readPageFromXML(Element element) {
        NodeList nodes = element.getElementsByTagName("title");
        this.title = nodes.item(0).getTextContent();
        nodes = element.getElementsByTagName("text");
        this.description = nodes.item(0).getTextContent();
        nodes = element.getElementsByTagName("min");
        this.minheight = Integer.parseInt(nodes.item(0).getTextContent());
        nodes = element.getElementsByTagName("max");
        this.maxheight = Integer.parseInt(nodes.item(0).getTextContent());
        nodes = element.getElementsByTagName("location");
        if (nodes.item(0) != null && nodes.item(0).getTextContent() != null) {
            this.location = nodes.item(0).getTextContent();
        }
        if ((nodes = element.getElementsByTagName("minesAsLevel")).item(0) != null) {
            try {
                this.minesAsLevel = Integer.parseInt(nodes.item(0).getTextContent());
            }
            catch (NumberFormatException e) {
                Logger.getAnonymousLogger().log(Level.WARNING, "Can't parse required level for " + this.title + "!");
            }
        }
        if ((nodes = element.getElementsByTagName("ore")).item(0) != null) {
            Item iconItem;
            Node oreNode = nodes.item(0);
            String total = oreNode.getTextContent();
            String mod = total.substring(0, total.indexOf(58));
            String itemName = total.substring(total.indexOf(58) + 1);
            int secondColonPosition = itemName.indexOf(58);
            int meta = 0;
            if (secondColonPosition != -1) {
                meta = Integer.parseInt(itemName.substring(itemName.indexOf(58) + 1));
                itemName = itemName.substring(0, itemName.indexOf(58));
            }
            if ((iconItem = GameRegistry.findItem((String)mod, (String)itemName)) != null) {
                this.ore = new ItemStack(GameRegistry.findItem((String)mod, (String)itemName), 1, meta);
                this.requiredLevel = GameRegistry.findBlock((String)mod, (String)itemName).getHarvestLevel(meta);
                if (this.requiredLevel == -1) {
                    this.requiredLevel = 0;
                }
                this.populateExamplesList();
            }
        }
        this.loadStringsAndImageLoc(this.location);
        int pictureNum = this.locationImg / 9;
        this.indexNum = this.locationImg % 9;
        this.location = "cavestokingdoms:textures/gui/locations" + pictureNum + ".png";
        this.background = new ResourceLocation(this.location);
    }

    public void renderContentLayer(int localWidth, int localHeight, boolean isTranslatable) {
        if (this.isDiscovered(this.requiredLevel)) {
            this.drawNormal(localWidth, localHeight);
        } else {
            this.drawLocked(localWidth, localHeight);
        }
    }

    private void loadStringsAndImageLoc(String location) {
        switch (location) {
            case "all": 
            case "chunkerror": {
                this.locationImg = 0;
                break;
            }
            case "nether": {
                this.locationImg = 1;
                break;
            }
            case "eerie": {
                this.locationImg = 2;
                break;
            }
            case "cache": {
                this.locationImg = 3;
                break;
            }
            case "alldesert": {
                this.locationImg = 4;
                break;
            }
            case "swamps": {
                this.locationImg = 5;
                break;
            }
            case "desert": {
                this.locationImg = 15;
                break;
            }
            case "plains": {
                this.locationImg = 7;
                break;
            }
            case "mountains": {
                this.locationImg = 8;
                break;
            }
            case "magic": {
                this.locationImg = 9;
                break;
            }
            case "cold": {
                this.locationImg = 10;
                break;
            }
            case "ocean": {
                this.locationImg = 11;
                break;
            }
            case "mushroom": {
                this.locationImg = 12;
                break;
            }
            case "forests": {
                this.locationImg = 13;
                break;
            }
            default: {
                this.locationImg = 14;
            }
        }
        this.whereFound = StatCollector.func_74838_a((String)("manual.cavestokingdoms.location." + location.toLowerCase()));
    }

    private void drawNormal(int localWidth, int localHeight) {
        String minesAsLevel = StatCollector.func_74838_a((String)"manual.cavestokingdoms.minesaslevel");
        String requiredToMine = StatCollector.func_74838_a((String)"manual.cavestokingdoms.requiredtomine");
        String biome = StatCollector.func_74838_a((String)"manual.cavestokingdoms.biome");
        String height = StatCollector.func_74838_a((String)"manual.cavestokingdoms.height");
        String between = StatCollector.func_74838_a((String)"manual.cavestokingdoms.between");
        String and = StatCollector.func_74838_a((String)"manual.cavestokingdoms.and");
        this.manual.fonts.drawString("\u00a7n" + this.title, localWidth + 70, localHeight + 4, 0);
        GL11.glEnable((int)32826);
        RenderHelper.func_74520_c();
        this.manual.renderitem.renderItemAndEffectIntoGUI(this.manual.fonts, this.manual.getMC().field_71446_o, this.ore, localWidth + 4, localHeight + 4);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        this.manual.renderitem.zLevel = 100.0f;
        if (this.minesAsLevel != -1) {
            this.manual.fonts.drawString(minesAsLevel + ": " + this.minesAsLevel + " (" + HarvestLevels.getHarvestLevelName((int)this.minesAsLevel) + ")", localWidth, localHeight + 25, 0);
        }
        this.manual.fonts.drawSplitString(requiredToMine + ": " + this.requiredLevel + " (" + HarvestLevels.getHarvestLevelName((int)this.requiredLevel) + ")", localWidth, localHeight + 35, 100, 0);
        this.manual.fonts.drawSplitString("\u00a7l" + biome + ": \u00a7r" + this.whereFound, localWidth, localHeight + 60, 106, 0);
        this.manual.fonts.drawSplitString("\u00a7l" + height + ": \u00a7r" + between + " " + this.minheight + " " + and + " " + this.maxheight + ".", localWidth, localHeight + 105, 100, 0);
        this.manual.fonts.drawSplitString(this.description, localWidth, localHeight + 130, 178, 0);
        this.manual.renderitem.zLevel = 0.0f;
    }

    private void drawLocked(int localWidth, int localHeight) {
        String entryOn = StatCollector.func_74838_a((String)"manual.cavestokingdoms.entryon");
        String isLocked = StatCollector.func_74838_a((String)"manual.cavestokingdoms.islocked");
        String toUnlock = StatCollector.func_74838_a((String)"manual.cavestokingdoms.tounlockobtain");
        String suchAs = StatCollector.func_74838_a((String)"manual.cavestokingdoms.suchas");
        String required = StatCollector.func_74838_a((String)("discover.cavestokingdoms.harvestlevel" + this.requiredLevel));
        this.manual.fonts.drawString("\u00a7n" + entryOn + " " + this.title + " " + isLocked, localWidth + 28, localHeight + 4, 0);
        this.manual.fonts.drawString(toUnlock + " ", localWidth + 50, localHeight + 18, 0);
        this.manual.fonts.drawString(required + " " + suchAs, localWidth + 70 - (int)((double)required.length() * 1.8), localHeight + 26, 0);
        int yoffset = 0;
        for (String s : this.examples) {
            this.manual.fonts.drawString(" - " + s, localWidth + 44, localHeight + 36 + (yoffset += 12), 0);
        }
    }

    public void renderBackgroundLayer(int localWidth, int localHeight) {
        if (this.isDiscovered(this.requiredLevel)) {
            int xIndex = this.indexNum % 3;
            int yIndex = this.indexNum / 3;
            if (this.background != null) {
                this.manual.getMC().func_110434_K().func_110577_a(this.background);
            }
            this.manual.func_73729_b(localWidth + 110, localHeight + 15, xIndex * 70, yIndex * 85, 70, 85);
        }
    }

    public void populateExamplesList() {
        switch (this.requiredLevel) {
            case 1: {
                this.examples.add("Flint");
                this.examples.add("Ghostwood");
                this.examples.add("Plastic");
                this.examples.add("Cardboard");
                break;
            }
            case 2: {
                this.examples.add("Prometheum");
                this.examples.add("Copper");
                this.examples.add("Deep Iron");
                this.examples.add("Darkwood");
                this.examples.add("Certus Quartz");
                break;
            }
            case 3: {
                this.examples.add("Oureclase");
                this.examples.add("Bronze");
                this.examples.add("Iron Pick Head");
                this.examples.add("Fusewood");
                this.examples.add("Thaumium");
                this.examples.add("NetherQuartz");
                break;
            }
            case 4: {
                this.examples.add("Steel");
                this.examples.add("Damascus Steel");
                this.examples.add("Hepatizon");
                this.examples.add("Invar");
                this.examples.add("Manasteel");
                this.examples.add("Bloodwood");
                break;
            }
            case 5: {
                this.examples.add("Platinum");
                this.examples.add("Ardite");
                this.examples.add("Astral Silver");
                this.examples.add("Void Metal");
                this.examples.add("Elementium");
                break;
            }
            case 6: {
                this.examples.add("Mithril");
                this.examples.add("Cobalt");
                this.examples.add("Carmot");
                break;
            }
            case 7: {
                this.examples.add("Orichalcum");
                this.examples.add("Manyullyn");
                this.examples.add("Pokefennium");
                break;
            }
            case 8: {
                this.examples.add("Adamantine");
                this.examples.add("Sanguinite");
                this.examples.add("Desichalkos");
            }
        }
    }

    private boolean isDiscovered(int level) {
        if (level == 0) {
            return true;
        }
        return this.isDiscovered("discover.cavestokingdoms.harvestlevel" + level);
    }
}

