/*
 * Decompiled with CFR 0.152.
 */
package talonos.cavestokingdoms.client.pages.orediscovery;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import talonos.cavestokingdoms.client.pages.orediscovery.entries.IDiscoveryEntry;
import talonos.cavestokingdoms.client.pages.orediscovery.entries.ItemDiscoveryEntry;
import talonos.cavestokingdoms.client.pages.orediscovery.entries.OreDictionaryDiscoveryEntry;
import talonos.cavestokingdoms.network.CavesToKingdomsNetwork;
import talonos.cavestokingdoms.network.packets.AddDiscoveryPacket;

public class OreDiscoveryRegistry {
    private static OreDiscoveryRegistry instance = null;
    private final List<IDiscoveryEntry> discoverData = new ArrayList<IDiscoveryEntry>();

    public static OreDiscoveryRegistry getInstance() {
        if (instance == null) {
            instance = new OreDiscoveryRegistry();
        }
        return instance;
    }

    public OreDiscoveryRegistry() {
        this.registerAllMetalsWith("ingot");
        this.registerAllMetalsWith("block");
        this.registerAllMetalsWith("nugget");
        this.registerAllMetalsWith("ore");
        this.registerDiscovery("crystalCertusQuartz", "discover.cavestokingdoms.certusquartz");
        this.registerDiscovery("crystalNetherQuartz", "discover.cavestokingdoms.netherquartz");
        this.registerDiscovery("gemAmethyst", "discover.cavestokingdoms.amethyst");
        this.registerDiscovery("gemRuby", "discover.cavestokingdoms.ruby");
        this.registerDiscovery("gemSaphire", "discover.cavestokingdoms.sapphire");
        this.registerDiscovery("gravel", "discover.cavestokingdoms.gravel");
        this.registerDiscovery("netherrack", "discover.cavestokingdoms.netherrack");
        this.registerDiscovery("obsidian", "discover.cavestokingdoms.obsidian");
        this.registerDiscovery("logWood", "discover.cavestokingdoms.wood");
        this.registerDiscovery("plankWood", "discover.cavestokingdoms.wood");
        this.registerDiscovery("woodLog", "discover.cavestokingdoms.wood");
        this.registerDiscovery(GameRegistry.findItem((String)"ExtraUtilities", (String)"bedrockiumIngot"), "discover.cavestokingdoms.bedrockium");
        this.registerDiscovery(GameRegistry.findItem((String)"Natura", (String)"bloodwood"), 0, "discover.cavestokingdoms.bloodwood");
        this.registerDiscovery(GameRegistry.findItem((String)"Natura", (String)"planks"), 4, "discover.cavestokingdoms.bloodwood");
        this.registerDiscovery(GameRegistry.findItem((String)"TConstruct", (String)"strangeFood"), 0, "discover.cavestokingdoms.blueslime");
        this.registerDiscovery(GameRegistry.findItem((String)"minecraft", (String)"dye"), 15, "discover.cavestokingdoms.bonemeal");
        this.registerDiscovery(GameRegistry.findItem((String)"minecraft", (String)"cactus"), "discover.cavestokingdoms.cactus");
        this.registerDiscovery(GameRegistry.findItem((String)"Natura", (String)"Saguaro"), 0, "discover.cavestokingdoms.cactus");
        this.registerDiscovery(GameRegistry.findItem((String)"appliedenergistics2", (String)"item.ItemMultiMaterial"), 1, "discover.cavestokingdoms.certusquartz");
        this.registerDiscovery(GameRegistry.findItem((String)"minecraft", (String)"chainmail_helmet"), "discover.cavestokingdoms.chain");
        this.registerDiscovery(GameRegistry.findItem((String)"minecraft", (String)"chainmail_chestplate"), "discover.cavestokingdoms.chain");
        this.registerDiscovery(GameRegistry.findItem((String)"minecraft", (String)"chainmail_leggings"), "discover.cavestokingdoms.chain");
        this.registerDiscovery(GameRegistry.findItem((String)"minecraft", (String)"chainmail_boots"), "discover.cavestokingdoms.chain");
        this.registerDiscovery(GameRegistry.findItem((String)"Thaumcraft", (String)"ItemBootsCultist"), "discover.cavestokingdoms.crimson");
        this.registerDiscovery(GameRegistry.findItem((String)"Thaumcraft", (String)"ItemChestplateCultistLeaderPlate"), "discover.cavestokingdoms.crimson");
        this.registerDiscovery(GameRegistry.findItem((String)"Thaumcraft", (String)"ItemChestplateCultistPlate"), "discover.cavestokingdoms.crimson");
        this.registerDiscovery(GameRegistry.findItem((String)"Thaumcraft", (String)"ItemChestplateCultistRobe"), "discover.cavestokingdoms.crimson");
        this.registerDiscovery(GameRegistry.findItem((String)"Thaumcraft", (String)"ItemHelmetCultistLeaderPlate"), "discover.cavestokingdoms.crimson");
        this.registerDiscovery(GameRegistry.findItem((String)"Thaumcraft", (String)"ItemHelmetCultistPlate"), "discover.cavestokingdoms.crimson");
        this.registerDiscovery(GameRegistry.findItem((String)"Thaumcraft", (String)"ItemHelmetCultistRobe"), "discover.cavestokingdoms.crimson");
        this.registerDiscovery(GameRegistry.findItem((String)"Thaumcraft", (String)"ItemLeggingsCultistLeaderPlate"), "discover.cavestokingdoms.crimson");
        this.registerDiscovery(GameRegistry.findItem((String)"Thaumcraft", (String)"ItemLeggingsCultistPlate"), "discover.cavestokingdoms.crimson");
        this.registerDiscovery(GameRegistry.findItem((String)"Thaumcraft", (String)"ItemLeggingsCultistRobe"), "discover.cavestokingdoms.crimson");
        this.registerDiscovery(GameRegistry.findItem((String)"Natura", (String)"Dark Tree"), 0, "discover.cavestokingdoms.darkwood");
        this.registerDiscovery(GameRegistry.findItem((String)"Natura", (String)"planks"), 11, "discover.cavestokingdoms.darkwood");
        this.registerDiscovery(GameRegistry.findItem((String)"Natura", (String)"Dark Tree"), 1, "discover.cavestokingdoms.fusewood");
        this.registerDiscovery(GameRegistry.findItem((String)"Natura", (String)"planks"), 12, "discover.cavestokingdoms.fusewood");
        this.registerDiscovery(GameRegistry.findItem((String)"Natura", (String)"tree"), 2, "discover.cavestokingdoms.ghostwood");
        this.registerDiscovery(GameRegistry.findItem((String)"Natura", (String)"planks"), 2, "discover.cavestokingdoms.ghostwood");
        this.registerDiscovery(GameRegistry.findItem((String)"TConstruct", (String)"materials"), 36, "discover.cavestokingdoms.glue");
        this.registerDiscovery(GameRegistry.findItem((String)"minecraft", (String)"slime_ball"), "discover.cavestokingdoms.greenslime");
        this.registerDiscovery(GameRegistry.findItem((String)"ThaumicTinkerer", (String)"kamiResource"), 1, "discover.cavestokingdoms.ichorcloth");
        this.registerDiscovery(GameRegistry.findItem((String)"minecraft", (String)"leather"), "discover.cavestokingdoms.leather");
        this.registerDiscovery(GameRegistry.findItem((String)"Thaumcraft", (String)"ItemResource"), 7, "discover.cavestokingdoms.magiccloth");
        this.registerDiscovery(GameRegistry.findItem((String)"ExtraTiC", (String)"chunk"), 165, "discover.cavestokingdoms.peridot");
        this.registerDiscovery(GameRegistry.findItem((String)"minecraft", (String)"reeds"), "discover.cavestokingdoms.reeds");
        this.registerDiscovery(GameRegistry.findItem((String)"customnpcs", (String)"npcNanorumChest"), "discover.cavestokingdoms.scout");
        this.registerDiscovery(GameRegistry.findItem((String)"customnpcs", (String)"npcSoldierLegs"), "discover.cavestokingdoms.scout");
        this.registerDiscovery(GameRegistry.findItem((String)"customnpcs", (String)"npcSoldierHead"), "discover.cavestokingdoms.scout");
        this.registerDiscovery(GameRegistry.findItem((String)"customnpcs", (String)"npcWizardHead"), "discover.cavestokingdoms.wizard");
        this.registerDiscovery(GameRegistry.findItem((String)"customnpcs", (String)"npcWizardChest"), "discover.cavestokingdoms.wizard");
        this.registerDiscovery(GameRegistry.findItem((String)"customnpcs", (String)"npcWizardPants"), "discover.cavestokingdoms.wizard");
        this.registerDiscovery(GameRegistry.findItem((String)"customnpcs", (String)"npcAssassinHead"), "discover.cavestokingdoms.assassin");
        this.registerDiscovery(GameRegistry.findItem((String)"customnpcs", (String)"npcAssassinBoots"), "discover.cavestokingdoms.assassin");
        this.registerDiscovery(GameRegistry.findItem((String)"customnpcs", (String)"npcAssassinLeggings"), "discover.cavestokingdoms.assassin");
        this.registerDiscovery(GameRegistry.findItem((String)"MineFactoryReloaded", (String)"pinkslime"), "discover.cavestokingdoms.pinkslime");
        this.registerDiscovery(GameRegistry.findItem((String)"MineFactoryReloaded", (String)"rubber.raw"), "discover.cavestokingdoms.plastic");
        this.registerDiscovery(GameRegistry.findItem((String)"MineFactoryReloaded", (String)"plastic.raw"), "discover.cavestokingdoms.plastic");
        this.registerDiscovery(GameRegistry.findItem((String)"MineFactoryReloaded", (String)"plastic.sheets"), "discover.cavestokingdoms.plastic");
        this.registerDiscovery(GameRegistry.findItem((String)"Thaumcraft", (String)"blockStoneDevice"), 2, "discover.cavestokingdoms.enhancedthaumium");
        this.registerDiscovery(GameRegistry.findItem((String)"Thaumcraft", (String)"ItemSwordElemental"), "discover.cavestokingdoms.enhancedthaumium");
        this.registerDiscovery(GameRegistry.findItem((String)"Thaumcraft", (String)"ItemAxeElemental"), "discover.cavestokingdoms.enhancedthaumium");
        this.registerDiscovery(GameRegistry.findItem((String)"Thaumcraft", (String)"ItemPickaxeElemental"), "discover.cavestokingdoms.enhancedthaumium");
        this.registerDiscovery(GameRegistry.findItem((String)"Thaumcraft", (String)"ItemHoeElemental"), "discover.cavestokingdoms.enhancedthaumium");
        this.registerDiscovery(GameRegistry.findItem((String)"Thaumcraft", (String)"ItemShovelElemental"), "discover.cavestokingdoms.enhancedthaumium");
        this.registerDiscovery(GameRegistry.findItem((String)"ForbiddenMagic", (String)"NetherShard"), 1, "discover.cavestokingdoms.chameleon");
        this.registerDiscovery(GameRegistry.findItem((String)"ThaumicTinkerer", (String)"kamiResource"), 2, "discover.cavestokingdoms.ichorium");
        this.registerDiscovery(GameRegistry.findItem((String)"ExtraUtilities", (String)"unstableingot"), 0, "discover.cavestokingdoms.unstable");
        this.registerDiscovery(GameRegistry.findItem((String)"ExtraUtilities", (String)"decorativeBlock1"), 8, "discover.cavestokingdoms.magicalwood");
        this.registerDiscovery(GameRegistry.findItem((String)"AWWayofTime", (String)"masterStone"), "discover.cavestokingdoms.bound");
        this.registerDiscovery(GameRegistry.findItem((String)"AWWayofTime", (String)"energySword"), "discover.cavestokingdoms.bound");
        this.registerDiscovery(GameRegistry.findItem((String)"AWWayofTime", (String)"boundPickaxe"), "discover.cavestokingdoms.bound");
        this.registerDiscovery(GameRegistry.findItem((String)"AWWayofTime", (String)"boundAxe"), "discover.cavestokingdoms.bound");
        this.registerDiscovery(GameRegistry.findItem((String)"AWWayofTime", (String)"boundShovel"), "discover.cavestokingdoms.bound");
        this.registerDiscovery("crystalCertusQuartz", "discover.cavestokingdoms.harvestlevel2");
        this.registerDiscovery("crystalNetherQuartz", "discover.cavestokingdoms.harvestlevel3");
        this.registerDiscovery("gemAmethyst", "discover.cavestokingdoms.harvestlevel4");
        this.registerDiscovery("gemRuby", "discover.cavestokingdoms.harvestlevel3");
        this.registerDiscovery("gemSaphire", "discover.cavestokingdoms.harvestlevel3");
        this.registerDiscovery("gravel", "discover.cavestokingdoms.harvestlevel1");
        this.registerDiscovery("netherrack", "discover.cavestokingdoms.harvestlevel1");
        this.registerDiscovery("obsidian", "discover.cavestokingdoms.harvestlevel4");
        this.registerDiscovery(GameRegistry.findItem((String)"Natura", (String)"bloodwood"), 0, "discover.cavestokingdoms.harvestlevel4");
        this.registerDiscovery(GameRegistry.findItem((String)"Natura", (String)"planks"), 4, "discover.cavestokingdoms.harvestlevel4");
        this.registerDiscovery(GameRegistry.findItem((String)"appliedenergistics2", (String)"item.ItemMultiMaterial"), 1, "discover.cavestokingdoms.harvestlevel2");
        this.registerDiscovery(GameRegistry.findItem((String)"Natura", (String)"Dark Tree"), 0, "discover.cavestokingdoms.harvestlevel2");
        this.registerDiscovery(GameRegistry.findItem((String)"Natura", (String)"planks"), 11, "discover.cavestokingdoms.harvestlevel2");
        this.registerDiscovery(GameRegistry.findItem((String)"Natura", (String)"Dark Tree"), 1, "discover.cavestokingdoms.harvestlevel3");
        this.registerDiscovery(GameRegistry.findItem((String)"Natura", (String)"planks"), 12, "discover.cavestokingdoms.harvestlevel3");
        this.registerDiscovery(GameRegistry.findItem((String)"Natura", (String)"tree"), 2, "discover.cavestokingdoms.harvestlevel1");
        this.registerDiscovery(GameRegistry.findItem((String)"Natura", (String)"planks"), 2, "discover.cavestokingdoms.harvestlevel1");
        this.registerDiscovery(GameRegistry.findItem((String)"ExtraTiC", (String)"chunk"), 165, "discover.cavestokingdoms.harvestlevel3");
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void registerAllMetalsWith(String type) {
        this.registerDiscovery(type + "Adamantine", "discover.cavestokingdoms.adamantine");
        this.registerDiscovery(type + "Alumite", "discover.cavestokingdoms.alumite");
        this.registerDiscovery(type + "Amordrine", "discover.cavestokingdoms.amordrine");
        this.registerDiscovery(type + "Angmallen", "discover.cavestokingdoms.angmallen");
        this.registerDiscovery(type + "Ardite", "discover.cavestokingdoms.ardite");
        this.registerDiscovery(type + "AstralSilver", "discover.cavestokingdoms.astralsilver");
        this.registerDiscovery(type + "Atlarus", "discover.cavestokingdoms.atlarus");
        this.registerDiscovery(type + "BlackSteel", "discover.cavestokingdoms.blacksteel");
        this.registerDiscovery(type + "Brass", "discover.cavestokingdoms.brass");
        this.registerDiscovery(type + "Bronze", "discover.cavestokingdoms.bronze");
        this.registerDiscovery(type + "Carmot", "discover.cavestokingdoms.carmot");
        this.registerDiscovery(type + "Celenegil", "discover.cavestokingdoms.celenegil");
        this.registerDiscovery(type + "Ceruclase", "discover.cavestokingdoms.ceruclase");
        this.registerDiscovery(type + "Cobalt", "discover.cavestokingdoms.cobalt");
        this.registerDiscovery(type + "Copper", "discover.cavestokingdoms.copper");
        this.registerDiscovery(type + "DamascusSteel", "discover.cavestokingdoms.damascussteel");
        this.registerDiscovery(type + "DeepIron", "discover.cavestokingdoms.deepiron");
        this.registerDiscovery(type + "Desichalkos", "discover.cavestokingdoms.desichalkos");
        this.registerDiscovery(type + "Electrum", "discover.cavestokingdoms.electrum");
        this.registerDiscovery(type + "ElvenElementium", "discover.cavestokingdoms.elementium");
        this.registerDiscovery(type + "Enderium", "discover.cavestokingdoms.enderium");
        this.registerDiscovery(type + "Eximite", "discover.cavestokingdoms.eximite");
        this.registerDiscovery(type + "Fairy", "discover.cavestokingdoms.fairy");
        this.registerDiscovery(type + "ElectrumFlux", "discover.cavestokingdoms.fluxinfused");
        this.registerDiscovery(type + "Gold", "discover.cavestokingdoms.gold");
        this.registerDiscovery(type + "Haderoth", "discover.cavestokingdoms.haderoth");
        this.registerDiscovery(type + "Hepatizon", "discover.cavestokingdoms.hepatizon");
        this.registerDiscovery(type + "Ignatius", "discover.cavestokingdoms.ignatius");
        this.registerDiscovery(type + "Inolashite", "discover.cavestokingdoms.inolashite");
        this.registerDiscovery(type + "Invar", "discover.cavestokingdoms.invar");
        this.registerDiscovery(type + "Iron", "discover.cavestokingdoms.iron");
        this.registerDiscovery(type + "Kalendrite", "discover.cavestokingdoms.kalendrite");
        this.registerDiscovery(type + "Lead", "discover.cavestokingdoms.lead");
        this.registerDiscovery(type + "Lumium", "discover.cavestokingdoms.lumium");
        this.registerDiscovery(type + "Manasteel", "discover.cavestokingdoms.manasteel");
        this.registerDiscovery(type + "Manyullyn", "discover.cavestokingdoms.manyullyn");
        this.registerDiscovery(type + "Midasium", "discover.cavestokingdoms.midasium");
        this.registerDiscovery(type + "Mithril", "discover.cavestokingdoms.mithril");
        this.registerDiscovery(type + "Nickel", "discover.cavestokingdoms.nickel");
        this.registerDiscovery(type + "Orichalcum", "discover.cavestokingdoms.orichalcum");
        this.registerDiscovery(type + "Oureclase", "discover.cavestokingdoms.oureclase");
        this.registerDiscovery(type + "PigIron", "discover.cavestokingdoms.pigiron");
        this.registerDiscovery(type + "Platinum", "discover.cavestokingdoms.platinum");
        this.registerDiscovery(type + "Pokefennium", "discover.cavestokingdoms.pokefennium");
        this.registerDiscovery(type + "Prometheum", "discover.cavestokingdoms.prometheum");
        this.registerDiscovery(type + "Sanguinite", "discover.cavestokingdoms.sanguinite");
        this.registerDiscovery(type + "ShadowIron", "discover.cavestokingdoms.shadowiron");
        this.registerDiscovery(type + "ShadowSteel", "discover.cavestokingdoms.shadowsteel");
        this.registerDiscovery(type + "Signalum", "discover.cavestokingdoms.signalum");
        this.registerDiscovery(type + "Silver", "discover.cavestokingdoms.silver");
        this.registerDiscovery(type + "Steel", "discover.cavestokingdoms.steel");
        this.registerDiscovery(type + "Tartarite", "discover.cavestokingdoms.tartarite");
        this.registerDiscovery(type + "Terrasteel", "discover.cavestokingdoms.terrasteel");
        this.registerDiscovery(type + "Thaumium", "discover.cavestokingdoms.thaumium");
        this.registerDiscovery(type + "Tin", "discover.cavestokingdoms.tin");
        this.registerDiscovery(type + "Void", "discover.cavestokingdoms.voidmetal");
        this.registerDiscovery(type + "Vulcanite", "discover.cavestokingdoms.vulcanite");
        this.registerDiscovery(type + "Vyroxeres", "discover.cavestokingdoms.vyroxeres");
        this.registerDiscovery(type + "Unstable", "discover.cavestokingdoms.unstable");
        this.registerDiscovery(type + "Adamantine", "discover.cavestokingdoms.harvestlevel8");
        this.registerDiscovery(type + "Alumite", "discover.cavestokingdoms.harvestlevel5");
        this.registerDiscovery(type + "Amordrine", "discover.cavestokingdoms.harvestlevel6");
        this.registerDiscovery(type + "Angmallen", "discover.cavestokingdoms.harvestlevel3");
        this.registerDiscovery(type + "Ardite", "discover.cavestokingdoms.harvestlevel5");
        this.registerDiscovery(type + "AstralSilver", "discover.cavestokingdoms.harvestlevel5");
        this.registerDiscovery(type + "Atlarus", "discover.cavestokingdoms.harvestlevel8");
        this.registerDiscovery(type + "BlackSteel", "discover.cavestokingdoms.harvestlevel3");
        this.registerDiscovery(type + "Brass", "discover.cavestokingdoms.harvestlevel2");
        this.registerDiscovery(type + "Bronze", "discover.cavestokingdoms.harvestlevel3");
        this.registerDiscovery(type + "Carmot", "discover.cavestokingdoms.harvestlevel6");
        this.registerDiscovery(type + "Celenegil", "discover.cavestokingdoms.harvestlevel7");
        this.registerDiscovery(type + "Ceruclase", "discover.cavestokingdoms.harvestlevel5");
        this.registerDiscovery(type + "Cobalt", "discover.cavestokingdoms.harvestlevel6");
        this.registerDiscovery(type + "Copper", "discover.cavestokingdoms.harvestlevel2");
        this.registerDiscovery(type + "DamascusSteel", "discover.cavestokingdoms.harvestlevel4");
        this.registerDiscovery(type + "DeepIron", "discover.cavestokingdoms.harvestlevel2");
        this.registerDiscovery(type + "Desichalkos", "discover.cavestokingdoms.harvestlevel8");
        this.registerDiscovery(type + "Electrum", "discover.cavestokingdoms.harvestlevel3");
        this.registerDiscovery(type + "ElvenElementium", "discover.cavestokingdoms.harvestlevel5");
        this.registerDiscovery(type + "Enderium", "discover.cavestokingdoms.harvestlevel5");
        this.registerDiscovery(type + "Eximite", "discover.cavestokingdoms.harvestlevel6");
        this.registerDiscovery(type + "Fairy", "discover.cavestokingdoms.harvestlevel6");
        this.registerDiscovery(type + "ElectrumFlux", "discover.cavestokingdoms.harvestlevel6");
        this.registerDiscovery(type + "Haderoth", "discover.cavestokingdoms.harvestlevel6");
        this.registerDiscovery(type + "Hepatizon", "discover.cavestokingdoms.harvestlevel4");
        this.registerDiscovery(type + "Ignatius", "discover.cavestokingdoms.harvestlevel3");
        this.registerDiscovery(type + "Inolashite", "discover.cavestokingdoms.harvestlevel6");
        this.registerDiscovery(type + "Invar", "discover.cavestokingdoms.harvestlevel4");
        this.registerDiscovery(type + "Kalendrite", "discover.cavestokingdoms.harvestlevel6");
        this.registerDiscovery(type + "Manasteel", "discover.cavestokingdoms.harvestlevel5");
        this.registerDiscovery(type + "Manyullyn", "discover.cavestokingdoms.harvestlevel7");
        this.registerDiscovery(type + "Midasium", "discover.cavestokingdoms.harvestlevel4");
        this.registerDiscovery(type + "Mithril", "discover.cavestokingdoms.harvestlevel6");
        this.registerDiscovery(type + "Nickel", "discover.cavestokingdoms.harvestlevel3");
        this.registerDiscovery(type + "Orichalcum", "discover.cavestokingdoms.harvestlevel7");
        this.registerDiscovery(type + "Oureclase", "discover.cavestokingdoms.harvestlevel3");
        this.registerDiscovery(type + "PigIron", "discover.cavestokingdoms.harvestlevel5");
        this.registerDiscovery(type + "Platinum", "discover.cavestokingdoms.harvestlevel5");
        this.registerDiscovery(type + "Pokefennium", "discover.cavestokingdoms.harvestlevel7");
        this.registerDiscovery(type + "Prometheum", "discover.cavestokingdoms.harvestlevel2");
        this.registerDiscovery(type + "Sanguinite", "discover.cavestokingdoms.harvestlevel8");
        this.registerDiscovery(type + "ShadowIron", "discover.cavestokingdoms.harvestlevel3");
        this.registerDiscovery(type + "ShadowSteel", "discover.cavestokingdoms.harvestlevel4");
        this.registerDiscovery(type + "Signalum", "discover.cavestokingdoms.harvestlevel2");
        this.registerDiscovery(type + "Silver", "discover.cavestokingdoms.harvestlevel3");
        this.registerDiscovery(type + "Steel", "discover.cavestokingdoms.harvestlevel4");
        this.registerDiscovery(type + "Tartarite", "discover.cavestokingdoms.harvestlevel8");
        this.registerDiscovery(type + "Terrasteel", "discover.cavestokingdoms.harvestlevel5");
        this.registerDiscovery(type + "Thaumium", "discover.cavestokingdoms.harvestlevel3");
        this.registerDiscovery(type + "Void", "discover.cavestokingdoms.harvestlevel7");
        this.registerDiscovery(type + "Vulcanite", "discover.cavestokingdoms.harvestlevel7");
        this.registerDiscovery(type + "Vyroxeres", "discover.cavestokingdoms.harvestlevel5");
        if (!type.equals("nugget")) {
            this.registerDiscovery(type + "Quicksilver", "discover.cavestokingdoms.quicksilver");
            this.registerDiscovery(type + "Quicksilver", "discover.cavestokingdoms.harvestlevel6");
        }
    }

    public void registerDiscovery(String oreDictionaryEntry, String discovery) {
        this.discoverData.add(new OreDictionaryDiscoveryEntry(oreDictionaryEntry, discovery));
    }

    public void registerDiscovery(Item item, String discovery) {
        this.registerDiscovery(item, 0, 0, discovery);
    }

    public void registerDiscovery(Item item, int meta, String discovery) {
        this.registerDiscovery(item, meta, 15, discovery);
    }

    public void registerDiscovery(Item item, int meta, int metaFlags, String discovery) {
        this.discoverData.add(new ItemDiscoveryEntry(item, meta, metaFlags, discovery));
    }

    public List<String> findDiscoveries(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        ArrayList<String> discoveries = new ArrayList<String>();
        for (IDiscoveryEntry discoverDatum : this.discoverData) {
            if (!discoverDatum.matches(stack)) continue;
            discoveries.add(discoverDatum.getDiscoveredOreData());
        }
        return discoveries;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void playerReceivedItem(PlayerEvent.ItemPickupEvent event) {
        ItemStack item = event.pickedUp.func_92059_d();
        this.checkDiscovery(item, event.player);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        ItemStack item = event.crafting;
        this.checkDiscovery(item, event.player);
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        if (event.wasDeath && event.original.getEntityData().func_74764_b("cavesToKingdomsOreDiscoveries")) {
            event.entity.getEntityData().func_74782_a("cavesToKingdomsOreDiscoveries", event.original.getEntityData().func_74781_a("cavesToKingdomsOreDiscoveries"));
        }
    }

    protected void checkDiscovery(ItemStack item, EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        List<String> discoveryOres = this.findDiscoveries(item);
        if (discoveryOres != null && !discoveryOres.isEmpty()) {
            for (String discovery : discoveryOres) {
                this.addDiscovery(player, discovery);
            }
        }
    }

    public void scanPlayerForDiscoveries(EntityPlayer player) {
        InventoryPlayer inventory = player.field_71071_by;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            this.checkDiscovery(stack, player);
        }
    }

    public boolean hasDiscovery(EntityPlayer player, String discoveryOre) {
        return this.hasDiscovery(player.getEntityData(), discoveryOre);
    }

    public void addDiscovery(EntityPlayer player, String discoveryOre) {
        if (this.hasDiscovery(player, discoveryOre)) {
            return;
        }
        this.addDiscovery(player.getEntityData(), discoveryOre);
        if (!player.field_70175_ag) {
            return;
        }
        if (!player.field_70170_p.field_72995_K) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("blightfallmanual.discovery.add", new Object[]{StatCollector.func_74838_a((String)discoveryOre)}));
        }
        if (player instanceof EntityPlayerMP) {
            CavesToKingdomsNetwork.sendToPlayer(new AddDiscoveryPacket(discoveryOre), (EntityPlayerMP)player);
        }
    }

    public void addAllDiscoveries(NBTTagCompound tag) {
        for (IDiscoveryEntry entry : this.discoverData) {
            this.addDiscovery(tag, entry.getDiscoveredOreData());
        }
    }

    public void clearDiscoveries(NBTTagCompound tag) {
        NBTTagList list = tag.func_150295_c("cavesToKingdomsOreDiscoveries", 8);
        if (list.func_74745_c() > 0) {
            tag.func_82580_o("cavesToKingdomsOreDiscoveries");
        }
    }

    public boolean hasDiscovery(NBTTagCompound tag, String discoveryOre) {
        if (tag == null) {
            return false;
        }
        NBTTagList list = tag.func_150295_c("cavesToKingdomsOreDiscoveries", 8);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            if (!list.func_150307_f(i).equals(discoveryOre)) continue;
            return true;
        }
        return false;
    }

    public void addDiscovery(NBTTagCompound tag, String discoveryOre) {
        NBTTagList list = tag.func_150295_c("cavesToKingdomsOreDiscoveries", 8);
        list.func_74742_a((NBTBase)new NBTTagString(discoveryOre));
        tag.func_74782_a("cavesToKingdomsOreDiscoveries", (NBTBase)list);
    }

    public void copyDiscoveries(NBTTagCompound from, NBTTagCompound to) {
        NBTTagList list = from.func_150295_c("cavesToKingdomsOreDiscoveries", 8);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            String discovery = list.func_150307_f(i);
            if (this.hasDiscovery(to, discovery)) continue;
            this.addDiscovery(to, discovery);
        }
    }
}

