/*
 * Decompiled with CFR 0.152.
 */
package talonos.cavestokingdoms.command;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import org.apache.commons.io.FileUtils;
import talonos.cavestokingdoms.CavesToKingdoms;

public class ScanBlocks
extends CommandBase {
    public String func_71517_b() {
        return "scanBlocks";
    }

    public String func_71518_a(ICommandSender p_71518_1_) {
        return "/scanBlocks";
    }

    public void func_71515_b(ICommandSender p_71515_1_, String[] p_71515_2_) {
        p_71515_1_.func_145747_a((IChatComponent)new ChatComponentText("Beginning Scan"));
        new CommandBlockScanner(p_71515_1_);
    }

    public static class CommandBlockScanner {
        private final ICommandSender commandSender;
        private int x = 0;
        private int z = 0;
        private double total = 0.0;
        private final HashMap<String, Integer> blockData = new HashMap();

        public CommandBlockScanner(ICommandSender commandSender) {
            this.commandSender = commandSender;
            FMLCommonHandler.instance().bus().register((Object)this);
        }

        @SubscribeEvent
        public void tickHandler(TickEvent.WorldTickEvent tickEvent) {
            if (tickEvent.phase != TickEvent.Phase.START) {
                return;
            }
            if (this.x == 1760) {
                this.x = 0;
                ++this.z;
            }
            if (this.z == 2160) {
                this.writeValues();
                return;
            }
            this.scanRow();
        }

        private void scanRow() {
            World world = this.commandSender.func_130014_f_();
            for (int i = 0; i < 160; ++i) {
                for (int y = 0; y < 255; ++y) {
                    if (world.func_147437_c(this.x, y, this.z)) continue;
                    this.total += 1.0;
                    Block block = world.func_147439_a(this.x, y, this.z);
                    int meta = world.func_72805_g(this.x, y, this.z);
                    String blockName = this.toBlockString(new ItemStack(block, 1, meta));
                    int blockCount = 0;
                    if (this.blockData.containsKey(blockName)) {
                        blockCount = this.blockData.get(blockName);
                    }
                    this.blockData.put(blockName, ++blockCount);
                }
                ++this.x;
            }
        }

        public String toBlockString(ItemStack stack) {
            StringBuilder result = new StringBuilder();
            result.append('<');
            result.append(Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()));
            if (stack.func_77960_j() > 0) {
                result.append(':').append(stack.func_77960_j());
            }
            result.append('>');
            return result.toString();
        }

        private void writeValues() {
            try {
                FileOutputStream streamOut = FileUtils.openOutputStream((File)new File("scanOut.csv"));
                OutputStreamWriter writer = new OutputStreamWriter(streamOut);
                writer.write("block,count,percent" + System.lineSeparator());
                for (String key : this.blockData.keySet()) {
                    int count = this.blockData.get(key);
                    double percent = (double)count / this.total * 100.0;
                    writer.write(key + "," + count + "," + percent + System.lineSeparator());
                }
                writer.close();
                streamOut.close();
            }
            catch (IOException ex) {
                CavesToKingdoms.logger.error("Failed to write scan data", (Throwable)ex);
            }
            FMLCommonHandler.instance().bus().unregister((Object)this);
            this.commandSender.func_145747_a((IChatComponent)new ChatComponentText("Scan complete"));
        }
    }
}

