/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.launch;

import com.mumfrey.liteloader.launch.NonDelegatingClassLoader;
import com.mumfrey.liteloader.transformers.PacketTransformer;
import com.mumfrey.liteloader.util.SortableValue;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraft.launchwrapper.LogWrapper;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;

public class ClassTransformerManager {
    private boolean gameStarted;
    private Set<String> pendingTransformers = new HashSet<String>();
    private Set<String> downstreamTransformers = new HashSet<String>();
    private Map<String, TreeSet<SortableValue<String>>> packetTransformers = new HashMap<String, TreeSet<SortableValue<String>>>();
    private final List<String> requiredTransformers;
    private final Set<String> injectedTransformers = new HashSet<String>();
    private final Map<String, List<Throwable>> transformerStartupErrors = new HashMap<String, List<Throwable>>();
    private Logger attachedLog;
    private String pendingTransformer;

    public ClassTransformerManager(List<String> requiredTransformers) {
        this.requiredTransformers = requiredTransformers;
        this.appendObserver();
    }

    private void appendObserver() {
        try {
            Field fLogger = LogWrapper.class.getDeclaredField("myLog");
            fLogger.setAccessible(true);
            this.attachedLog = (Logger)fLogger.get(LogWrapper.log);
            if (this.attachedLog instanceof org.apache.logging.log4j.core.Logger) {
                ((org.apache.logging.log4j.core.Logger)this.attachedLog).addAppender((Appender)new ThrowableObserver());
            }
        }
        catch (Exception ex) {
            LiteLoaderLogger.warning("Failed to append ThrowableObserver to LogWrapper, transformer startup exceptions may not be logged", new Object[0]);
        }
    }

    public boolean injectTransformer(String transformerClass) {
        if (!this.gameStarted) {
            this.pendingTransformers.add(transformerClass);
            return true;
        }
        return false;
    }

    public boolean injectTransformers(Collection<String> transformerClasses) {
        if (!this.gameStarted) {
            this.pendingTransformers.addAll(transformerClasses);
            return true;
        }
        return false;
    }

    public boolean injectTransformers(String[] transformerClasses) {
        if (!this.gameStarted) {
            this.pendingTransformers.addAll(Arrays.asList(transformerClasses));
            return true;
        }
        return false;
    }

    void injectUpstreamTransformers(LaunchClassLoader classLoader) {
        this.sieveAndSortPacketTransformers(classLoader, this.pendingTransformers);
        for (String string : this.requiredTransformers) {
            LiteLoaderLogger.info("Injecting required class transformer '%s'", string);
            this.injectTransformer(classLoader, string);
        }
        for (Map.Entry entry : this.packetTransformers.entrySet()) {
            for (SortableValue transformerInfo : (TreeSet)entry.getValue()) {
                String packetClass = (String)entry.getKey();
                String transformerClassName = (String)transformerInfo.getValue();
                if (packetClass.lastIndexOf(46) != -1) {
                    packetClass = packetClass.substring(packetClass.lastIndexOf(46) + 1);
                }
                LiteLoaderLogger.info("Injecting packet class transformer '%s' for packet class '%s' with priority %d", transformerClassName, packetClass, transformerInfo.getPriority());
                this.injectTransformer(classLoader, transformerClassName);
            }
        }
        this.pendingTransformers = this.downstreamTransformers;
    }

    void injectDownstreamTransformers(LaunchClassLoader classLoader) {
        if (this.downstreamTransformers.size() > 0) {
            LiteLoaderLogger.info("Injecting downstream transformers", new Object[0]);
        }
        for (String transformerClassName : this.downstreamTransformers) {
            LiteLoaderLogger.info("Injecting additional class transformer class '%s'", transformerClassName);
            this.injectTransformer(classLoader, transformerClassName);
        }
        this.downstreamTransformers.clear();
        this.gameStarted = true;
    }

    private void sieveAndSortPacketTransformers(LaunchClassLoader classLoader, Set<String> transformers) {
        LiteLoaderLogger.info("Sorting registered packet transformers by priority", new Object[0]);
        int registeredTransformers = 0;
        NonDelegatingClassLoader tempLoader = new NonDelegatingClassLoader(classLoader.getURLs(), this.getClass().getClassLoader());
        tempLoader.addDelegatedClassName("com.mumfrey.liteloader.core.transformers.PacketTransformer");
        tempLoader.addDelegatedClassName("com.mumfrey.liteloader.core.runtime.Obf");
        tempLoader.addDelegatedClassName("net.minecraft.launchwrapper.IClassTransformer");
        tempLoader.addDelegatedPackage("org.objectweb.asm.");
        Iterator<String> iter = transformers.iterator();
        while (iter.hasNext()) {
            String transformerClassName = iter.next();
            try {
                Class<?> transformerClass = tempLoader.addAndLoadClass(transformerClassName);
                if (!PacketTransformer.class.isAssignableFrom(transformerClass)) continue;
                if (tempLoader.isValid()) {
                    PacketTransformer transformer = (PacketTransformer)transformerClass.newInstance();
                    String packetClass = transformer.getPacketClass();
                    if (!this.packetTransformers.containsKey(packetClass)) {
                        this.packetTransformers.put(packetClass, new TreeSet());
                    }
                    this.packetTransformers.get(packetClass).add(transformer.getInfo(transformerClassName));
                    ++registeredTransformers;
                    iter.remove();
                    continue;
                }
                LiteLoaderLogger.warning("Packet transformer class '%s' references class '%s' which is not allowed. Packet transformers must not contain references to other classes", transformerClassName, tempLoader.getInvalidClassName());
                iter.remove();
            }
            catch (NoClassDefFoundError err) {
                LiteLoaderLogger.warning(err, "Packet transformer class '%s' references a missing class. This probably means it is out of date or missing a dependency.", transformerClassName);
                err.printStackTrace();
                iter.remove();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.downstreamTransformers.addAll(transformers);
        transformers.clear();
        LiteLoaderLogger.info("Added %d packet transformer classes to the transformer list", registeredTransformers);
    }

    private synchronized void injectTransformer(LaunchClassLoader classLoader, String transformerClassName) {
        this.pendingTransformer = transformerClassName;
        classLoader.registerTransformer(transformerClassName);
        this.pendingTransformer = null;
        if (this.findTransformer(classLoader, transformerClassName) != null) {
            this.injectedTransformers.add(transformerClassName);
        }
    }

    public void observeThrowable(Throwable th) {
        if (th != null && this.pendingTransformer != null) {
            List<Throwable> transformerErrors = this.transformerStartupErrors.get(this.pendingTransformer);
            if (transformerErrors == null) {
                transformerErrors = new ArrayList<Throwable>();
                this.transformerStartupErrors.put(this.pendingTransformer, transformerErrors);
            }
            transformerErrors.add(th);
        }
    }

    private IClassTransformer findTransformer(LaunchClassLoader classLoader, String transformerClassName) {
        for (IClassTransformer transformer : classLoader.getTransformers()) {
            if (!transformer.getClass().getName().equals(transformerClassName)) continue;
            return transformer;
        }
        return null;
    }

    public Set<String> getInjectedTransformers() {
        return Collections.unmodifiableSet(this.injectedTransformers);
    }

    public List<Throwable> getTransformerStartupErrors(String transformerClassName) {
        List<Throwable> errorList = this.transformerStartupErrors.get(transformerClassName);
        return errorList != null ? Collections.unmodifiableList(errorList) : null;
    }

    class ThrowableObserver
    extends AbstractAppender {
        public ThrowableObserver() {
            super("Throwable Observer", null, null);
            this.start();
        }

        public void append(LogEvent event) {
            ClassTransformerManager.this.observeThrowable(event.getThrown());
        }
    }
}

