/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.launch;

import com.mumfrey.liteloader.core.runtime.Obf;
import com.mumfrey.liteloader.launch.LiteLoaderTweaker;
import com.mumfrey.liteloader.transformers.ClassTransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class LiteLoaderTransformer
extends ClassTransformer {
    private static final String LITELOADER_TWEAKER_CLASS = LiteLoaderTweaker.class.getName().replace('.', '/');
    private static final String METHOD_PRE_BEGIN_GAME = "preBeginGame";

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return basicClass;
        }
        if (Obf.MinecraftMain.name.equals(transformedName)) {
            return this.transformMain(basicClass);
        }
        if (Obf.Blocks.obf.equals(transformedName) || Obf.Blocks.name.equals(transformedName) || Obf.Items.obf.equals(transformedName) || Obf.Items.name.equals(transformedName)) {
            return this.stripFinalModifiers(basicClass);
        }
        return basicClass;
    }

    private byte[] transformMain(byte[] basicClass) {
        ClassNode classNode = this.readClass(basicClass, true);
        for (MethodNode method : classNode.methods) {
            if (!"main".equals(method.name)) continue;
            method.instructions.insert((AbstractInsnNode)new MethodInsnNode(184, LITELOADER_TWEAKER_CLASS, METHOD_PRE_BEGIN_GAME, "()V", false));
        }
        return this.writeClass(classNode);
    }

    private byte[] stripFinalModifiers(byte[] basicClass) {
        ClassNode classNode = this.readClass(basicClass, true);
        for (FieldNode field : classNode.fields) {
            field.access &= 0xFFFFFFEF;
        }
        return this.writeClass(classNode);
    }
}

