/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.permissions;

import java.util.Hashtable;
import java.util.Map;

public class Permission {
    private final boolean isRootNode;
    private final boolean isWildcardNode;
    private final String nodeName;
    private final Map<String, Permission> childNodes = new Hashtable<String, Permission>();
    private boolean value;

    public Permission() {
        this.isRootNode = true;
        this.isWildcardNode = false;
        this.value = true;
        this.nodeName = "root";
    }

    public Permission(String permissionName, boolean value) {
        this.isRootNode = false;
        this.isWildcardNode = permissionName.equals("*");
        this.value = value;
        this.nodeName = permissionName;
    }

    public Permission(String permissionName) {
        this(permissionName, true);
    }

    public boolean isRoot() {
        return this.isRootNode;
    }

    public boolean isWildcard() {
        return this.isWildcardNode;
    }

    public String getName() {
        return this.nodeName;
    }

    public boolean getValue() {
        return this.value;
    }

    public void setValue(boolean newValue) {
        this.value = newValue;
    }

    public Permission getPermission(String name) {
        Permission fallback;
        Permission permission = fallback = this.isWildcardNode ? this : null;
        if (name.indexOf(46) > -1) {
            String head = name.substring(0, name.indexOf(46));
            String tail = name.substring(name.indexOf(46) + 1);
            Permission child = this.getPermission(head);
            if (child != null) {
                return child.getPermission(tail);
            }
        } else if (this.childNodes.containsKey(name)) {
            return this.childNodes.get(name);
        }
        for (Permission childPermission : this.childNodes.values()) {
            if (!childPermission.isWildcard()) continue;
            return childPermission;
        }
        return fallback;
    }

    public Permission setPermission(String name) {
        return this.setPermission(name, true);
    }

    public Permission setPermission(String name, boolean value) {
        if (name.indexOf(46) > -1) {
            String head = name.substring(0, name.indexOf(46));
            String tail = name.substring(name.indexOf(46) + 1);
            Permission child = this.setPermission(head, false);
            return child.setPermission(tail, value);
        }
        Permission child = this.getPermission(name);
        if (child == null || child.isWildcard()) {
            child = new Permission(name, value);
            this.childNodes.put(child.getName(), child);
        } else {
            child.setValue(value | child.value);
        }
        return child;
    }

    public Permission setPermissionAndValue(String name, boolean value) {
        Permission permission = this.setPermission(name, value);
        permission.setValue(value);
        return permission;
    }

    public boolean isSet(String name, boolean value) {
        Permission child = this.getPermission(name);
        return child == null ? value : child.getValue();
    }
}

