/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.transformers.event;

import com.mumfrey.liteloader.transformers.ClassTransformer;
import com.mumfrey.liteloader.transformers.event.Event;
import com.mumfrey.liteloader.transformers.event.InjectionPoint;
import com.mumfrey.liteloader.transformers.event.MethodInfo;
import com.mumfrey.liteloader.transformers.event.ReadOnlyInsnList;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class EventInjectionTransformer
extends ClassTransformer {
    private static Map<String, Map<String, Map<Event, InjectionPoint>>> eventMappings = new HashMap<String, Map<String, Map<Event, InjectionPoint>>>();
    private static EventInjectionTransformer master;
    private final boolean runValidator = false;
    private int globalEventID = 0;

    public EventInjectionTransformer() {
        if (master == null) {
            master = this;
        }
        try {
            this.addEvents();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected abstract void addEvents();

    protected final Event addEvent(String eventName, MethodInfo targetMethod, InjectionPoint injectionPoint) {
        return this.addEvent(Event.getOrCreate(eventName), targetMethod, injectionPoint);
    }

    protected final Event addEvent(Event event, MethodInfo targetMethod, InjectionPoint injectionPoint) {
        if (event == null) {
            throw new IllegalArgumentException("Event cannot be null!");
        }
        if (injectionPoint == null) {
            throw new IllegalArgumentException("Injection point cannot be null for event " + event.getName());
        }
        this.addEvent(event, targetMethod.owner, targetMethod.sig, injectionPoint);
        this.addEvent(event, targetMethod.owner, targetMethod.sigSrg, injectionPoint);
        this.addEvent(event, targetMethod.ownerObf, targetMethod.sigObf, injectionPoint);
        event.addPendingInjection(targetMethod);
        return event;
    }

    private void addEvent(Event event, String className, String signature, InjectionPoint injectionPoint) {
        Map<Event, InjectionPoint> events;
        Map<String, Map<Event, InjectionPoint>> mappings = eventMappings.get(className);
        if (mappings == null) {
            mappings = new HashMap<String, Map<Event, InjectionPoint>>();
            eventMappings.put(className, mappings);
        }
        if ((events = mappings.get(signature)) == null) {
            events = new LinkedHashMap<Event, InjectionPoint>();
            mappings.put(signature, events);
        }
        events.put(event, injectionPoint);
    }

    public final byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (master == this && basicClass != null && eventMappings.containsKey(transformedName)) {
            return this.injectEvents(basicClass, eventMappings.get(transformedName));
        }
        return basicClass;
    }

    private byte[] injectEvents(byte[] basicClass, Map<String, Map<Event, InjectionPoint>> mappings) {
        if (mappings == null) {
            return basicClass;
        }
        ClassNode classNode = this.readClass(basicClass, true);
        for (MethodNode method : classNode.methods) {
            String signature = MethodInfo.generateSignature(method.name, method.desc);
            Map<Event, InjectionPoint> methodInjections = mappings.get(signature);
            if (methodInjections == null) continue;
            this.injectIntoMethod(classNode, signature, method, methodInjections);
        }
        this.getClass();
        return this.writeClass(classNode);
    }

    void injectIntoMethod(ClassNode classNode, String signature, MethodNode method, Map<Event, InjectionPoint> methodInjections) {
        Map<AbstractInsnNode, Set<Event>> injectionPoints = this.findInjectionPoints(classNode, method, methodInjections);
        for (Map.Entry<AbstractInsnNode, Set<Event>> injectionPoint : injectionPoints.entrySet()) {
            this.injectEventsAt(classNode, method, injectionPoint.getKey(), injectionPoint.getValue());
        }
        for (Event event : methodInjections.keySet()) {
            event.notifyInjected(method.name, method.desc, classNode.name);
            event.detach();
        }
    }

    private Map<AbstractInsnNode, Set<Event>> findInjectionPoints(ClassNode classNode, MethodNode method, Map<Event, InjectionPoint> methodInjections) {
        ReadOnlyInsnList insns = new ReadOnlyInsnList(method.instructions);
        ArrayList<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>(32);
        LinkedHashMap<AbstractInsnNode, Set<Event>> injectionPoints = new LinkedHashMap<AbstractInsnNode, Set<Event>>();
        for (Map.Entry<Event, InjectionPoint> eventEntry : methodInjections.entrySet()) {
            Event event = eventEntry.getKey();
            event.attach(method);
            InjectionPoint injectionPoint = eventEntry.getValue();
            nodes.clear();
            if (!injectionPoint.find(method.desc, insns, nodes, event)) continue;
            for (AbstractInsnNode node : nodes) {
                TreeSet<Event> nodeEvents = (TreeSet<Event>)injectionPoints.get(node);
                if (nodeEvents == null) {
                    nodeEvents = new TreeSet<Event>();
                    injectionPoints.put(node, nodeEvents);
                }
                nodeEvents.add(event);
            }
        }
        return injectionPoints;
    }

    private void injectEventsAt(ClassNode classNode, MethodNode method, AbstractInsnNode injectionPoint, Set<Event> events) {
        boolean cancellable = false;
        for (Event event : events) {
            cancellable |= event.isCancellable();
        }
        Event head = events.iterator().next();
        MethodNode handler = head.inject(injectionPoint, cancellable, this.globalEventID);
        LiteLoaderLogger.info("Injecting %s[x%d] in %s in %s", head.getName(), events.size(), method.name, EventInjectionTransformer.getSimpleClassName(classNode));
        for (Event event : events) {
            event.addToHandler(handler);
        }
        ++this.globalEventID;
    }

    private static String getSimpleClassName(ClassNode classNode) {
        String className = classNode.name.replace('/', '.');
        int dotPos = className.lastIndexOf(46);
        return dotPos == -1 ? className : className.substring(dotPos + 1);
    }
}

