/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.util;

import com.mumfrey.liteloader.util.InputHandler;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.Event;

public class InputEvent {
    private final Controller controller;
    private final Component component;
    private final InputHandler handler;
    private InputEvent next;

    InputEvent(Controller controller, Component component, InputHandler handler) {
        this.controller = controller;
        this.component = component;
        this.handler = handler;
    }

    InputEvent link(InputEvent chain) {
        if (chain == null) {
            return this;
        }
        return chain.append(this);
    }

    private InputEvent append(InputEvent delegate) {
        InputEvent tail = this;
        while (tail.next != null) {
            tail = tail.next;
        }
        tail.next = delegate;
        return this;
    }

    void onEvent(Event event) {
        if (this.component.isAnalog()) {
            this.onAxisEvent(event.getValue(), event.getNanos());
        } else if (this.component.getIdentifier() == Component.Identifier.Axis.POV) {
            this.onPovEvent(event.getValue(), event.getNanos());
        } else {
            this.onButtonEvent(event.getValue() == 1.0f);
        }
    }

    private void onAxisEvent(float value, long nanos) {
        this.handler.onAxisEvent(this, value, nanos);
        if (this.next != null) {
            this.next.onAxisEvent(value, nanos);
        }
    }

    private void onPovEvent(float value, long nanos) {
        this.handler.onPovEvent(this, value, nanos);
        if (this.next != null) {
            this.next.onPovEvent(value, nanos);
        }
    }

    private void onButtonEvent(boolean pressed) {
        this.handler.onButtonEvent(this, pressed);
        if (this.next != null) {
            this.next.onButtonEvent(pressed);
        }
    }

    public Controller getController() {
        return this.controller;
    }

    public Component getComponent() {
        return this.component;
    }
}

