/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.util.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class HttpStringRetriever
extends Thread {
    public static final String LINE_ENDING_LF = "\n";
    public static final String LINE_ENDING_CR = "\r";
    public static final String LINE_ENDING_CRLF = "\r\n";
    private final String url;
    private final Map<String, String> headers;
    private final String lineEnding;
    private int httpResponseCode = 0;
    private final Object resultLock = new Object();
    private String string;
    private volatile boolean done = false;
    private volatile boolean success = false;

    public HttpStringRetriever(String url, Map<String, String> headers, String lineEnding) {
        this.url = url;
        this.headers = headers;
        this.lineEnding = lineEnding;
    }

    public HttpStringRetriever(String url, Map<String, String> headers) {
        this(url, headers, LINE_ENDING_LF);
    }

    public HttpStringRetriever(String url) {
        this(url, null);
    }

    public HttpStringRetriever() {
        this((String)null, (Map<String, String>)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString() {
        Object object = this.resultLock;
        synchronized (object) {
            return this.string;
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean getSuccess() {
        return this.success;
    }

    public int getHttpResponseCode() {
        return this.httpResponseCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String result = this.fetch(new URL(this.url));
            Object object = this.resultLock;
            synchronized (object) {
                this.string = result;
            }
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        this.done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String fetch(URL url) {
        StringBuilder readString;
        block13: {
            readString = new StringBuilder();
            HttpURLConnection httpClient = null;
            try {
                httpClient = (HttpURLConnection)url.openConnection();
                httpClient.setDoInput(true);
                httpClient.setUseCaches(false);
                httpClient.setRequestMethod("GET");
                httpClient.setRequestProperty("Connection", "Close");
                httpClient.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:19.0) Gecko/20100101 Firefox/21.0");
                if (this.headers != null) {
                    for (Map.Entry<String, String> header : this.headers.entrySet()) {
                        httpClient.addRequestProperty(header.getKey(), header.getValue());
                    }
                }
                this.httpResponseCode = httpClient.getResponseCode();
                if (this.httpResponseCode < 200 || this.httpResponseCode >= 300) break block13;
                InputStream httpStream = httpClient.getInputStream();
                BufferedReader reader = null;
                try {
                    String readLine;
                    reader = new BufferedReader(new InputStreamReader(httpStream));
                    while ((readLine = reader.readLine()) != null) {
                        readString.append(readLine).append(this.lineEnding);
                    }
                    this.success = true;
                }
                catch (IOException ex) {
                    IOUtils.closeQuietly(reader);
                    IOUtils.closeQuietly((InputStream)httpStream);
                    break block13;
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(reader);
                        IOUtils.closeQuietly((InputStream)httpStream);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Reader)reader);
                IOUtils.closeQuietly((InputStream)httpStream);
            }
            catch (IOException ex) {
                this.httpResponseCode = -1;
            }
            finally {
                if (httpClient != null) {
                    httpClient.disconnect();
                }
            }
        }
        return readString.toString();
    }
}

