/*
 * Decompiled with CFR 0.152.
 */
package org.lwjglx;

import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicBoolean;
import me.eigenraven.lwjgl3ify.client.MainThreadExec;
import me.eigenraven.lwjgl3ify.core.Config;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.Version;
import org.lwjgl.sdl.SDLClipboard;
import org.lwjgl.sdl.SDLHints;
import org.lwjgl.sdl.SDLInit;
import org.lwjgl.sdl.SDLMessageBox;
import org.lwjgl.sdl.SDLMisc;
import org.lwjgl.sdl.SDLStdinc;
import org.lwjgl.sdl.SDLTimer;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Platform;
import org.lwjgl.system.Pointer;
import org.lwjglx.SDLException;
import org.lwjglx.opengl.Display;

public class Sys {
    private static final AtomicBoolean isFirstInit = new AtomicBoolean(true);

    private static void firstTimeInit() {
        Configuration.OPENGL_EXPLICIT_INIT.set((Object)true);
        Configuration.HARFBUZZ_LIBRARY_NAME.set((Object)"freetype");
        if (Platform.get() == Platform.MACOSX && !GraphicsEnvironment.isHeadless()) {
            throw new IllegalStateException("java.awt.headless must be set to true on macOS, this is normally set by RFB!");
        }
        MainThreadExec.ensureInitialised();
        MainThreadExec.runOnMainThread(() -> {
            SDLStdinc.SDL_SetMemoryFunctions(MemoryUtil::nmemAllocChecked, MemoryUtil::nmemCallocChecked, MemoryUtil::nmemReallocChecked, MemoryUtil::nmemFree);
            Sys.checkSdl(SDLInit.SDL_SetAppMetadata((CharSequence)"Lwjgl3ify Minecraft", (CharSequence)"1.7.10", (CharSequence)Config.APP_ID));
            Sys.checkSdl(SDLInit.SDL_SetAppMetadataProperty((CharSequence)"SDL.app.metadata.url", (CharSequence)"https://github.com/GTNewHorizons/lwjgl3ify"));
            Sys.checkSdl(SDLInit.SDL_SetAppMetadataProperty((CharSequence)"SDL.app.metadata.creator", (CharSequence)"Mojang, GTNH Team"));
            Sys.checkSdl(SDLInit.SDL_SetAppMetadataProperty((CharSequence)"SDL.app.metadata.copyright", (CharSequence)"https://www.minecraft.net/en-us/eula"));
            Sys.checkSdl(SDLInit.SDL_SetAppMetadataProperty((CharSequence)"SDL.app.metadata.type", (CharSequence)"game"));
            Platform currentPlatform = Platform.get();
            if (currentPlatform == Platform.LINUX && Config.WINDOW_LINUX_DESKTOP_ENTRY) {
                try {
                    Sys.createLinuxDesktopEntry();
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not follow linuxCreateAppDesktopEntry logic in lwjgl3ify", e);
                }
            }
            if (currentPlatform == Platform.LINUX) {
                SDLHints.SDL_SetHint((CharSequence)"SDL_VIDEO_FORCE_EGL", (CharSequence)"1");
            }
            if (!SDLInit.SDL_Init((int)61984)) {
                throw new SDLException("Could not initialize SDL.");
            }
            switch (currentPlatform) {
                case MACOSX: {
                    SDLHints.SDL_SetHint((CharSequence)"SDL_MAC_OPENGL_ASYNC_DISPATCH", (CharSequence)"1");
                    break;
                }
                case LINUX: {
                    SDLStdinc.SDL_setenv_unsafe((CharSequence)"__GL_THREADED_OPTIMIZATIONS", (CharSequence)"0", (int)1);
                    break;
                }
            }
            SDLHints.SDL_SetHint((CharSequence)"SDL_MOUSE_FOCUS_CLICKTHROUGH", (CharSequence)"1");
        });
    }

    private static void createLinuxDesktopEntry() throws IOException {
        String HOME;
        FileSystem fs = FileSystems.getDefault();
        Path XDG_DATA_HOME = null;
        String XDH_ENV = System.getenv("XDG_DATA_HOME");
        if (XDH_ENV != null) {
            XDG_DATA_HOME = fs.getPath(XDH_ENV, new String[0]);
        }
        if (XDG_DATA_HOME == null || !Files.isDirectory(XDG_DATA_HOME, new LinkOption[0])) {
            XDG_DATA_HOME = null;
            HOME = System.getenv("HOME");
            if (Files.isDirectory(fs.getPath(HOME, new String[0]), new LinkOption[0])) {
                XDG_DATA_HOME = fs.getPath(HOME, ".local", "share");
            }
        }
        if (XDG_DATA_HOME == null || !Files.isDirectory(XDG_DATA_HOME, new LinkOption[0])) {
            XDG_DATA_HOME = null;
            HOME = System.getProperty("user.home");
            if (Files.isDirectory(fs.getPath(HOME, new String[0]), new LinkOption[0])) {
                XDG_DATA_HOME = fs.getPath(HOME, ".local", "share");
            }
        }
        if (XDG_DATA_HOME == null || !Files.isDirectory(XDG_DATA_HOME, new LinkOption[0])) {
            throw new RuntimeException("Could not find $XDG_DATA_HOME or $HOME/.local/share, please either set the proper environment variables or turn off linuxCreateAppDesktopEntry in lwjgl3ify.cfg");
        }
        Path applicationsPath = XDG_DATA_HOME.resolve("applications");
        Path appDesktopPath = applicationsPath.resolve(Config.APP_ID + ".desktop");
        if (Files.exists(appDesktopPath, new LinkOption[0])) {
            return;
        }
        if (!Files.exists(applicationsPath, new LinkOption[0])) {
            Files.createDirectory(applicationsPath, new FileAttribute[0]);
        }
        String desktopContents = "# Autogenerated by lwjgl3ify because linuxCreateAppDesktopEntry was set to true in its config\n[Desktop Entry]\nVersion=1.0\nType=Application\nName=Lwjgl3ify Minecraft\nNoDisplay=true\n\n";
        Files.write(appDesktopPath, "# Autogenerated by lwjgl3ify because linuxCreateAppDesktopEntry was set to true in its config\n[Desktop Entry]\nVersion=1.0\nType=Application\nName=Lwjgl3ify Minecraft\nNoDisplay=true\n\n".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        System.out.println("lwjgl3ify: Created a .desktop file at " + appDesktopPath + " for better Wayland support, because linuxCreateAppDesktopEntry=true in lwjgl3ify.cfg");
    }

    public static void initialize() {
        if (!isFirstInit.compareAndSet(true, false)) {
            return;
        }
        Sys.firstTimeInit();
    }

    public static String getVersion() {
        return Version.getVersion();
    }

    public static long getTimerResolution() {
        return 1000L;
    }

    public static long getTime() {
        return SDLTimer.SDL_GetTicksNS() / 1000000L;
    }

    public static long getNanoTime() {
        return SDLTimer.SDL_GetTicksNS();
    }

    public static boolean openURL(String url) {
        return MainThreadExec.runOnMainThread(() -> SDLMisc.SDL_OpenURL((CharSequence)url));
    }

    public static void alert(String title, String message) {
        MainThreadExec.runOnMainThread(() -> SDLMessageBox.SDL_ShowSimpleMessageBox((int)32, (CharSequence)title, (CharSequence)message, (long)Display.getWindow()));
    }

    public static boolean is64Bit() {
        return Pointer.BITS64;
    }

    public static String getClipboard() {
        return MainThreadExec.runOnMainThread(SDLClipboard::SDL_GetClipboardText);
    }

    public static void checkSdl(boolean result) {
        if (!result) {
            throw new SDLException();
        }
    }

    @NotNull
    public static <T> T checkSdl(@Nullable T result) {
        if (result == null) {
            throw new SDLException();
        }
        return result;
    }

    public static int checkSdl(int result) {
        if ((long)result == 0L) {
            throw new SDLException();
        }
        return result;
    }

    public static long checkSdl(long result) {
        if (result == 0L) {
            throw new SDLException();
        }
        return result;
    }
}

