/*
 * Decompiled with CFR 0.152.
 */
package darkevilmac.movingworld.client.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import darkevilmac.movingworld.MovingWorld;
import darkevilmac.movingworld.common.chunk.mobilechunk.MobileChunk;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class MobileChunkRenderer {
    public boolean isInFrustum = false;
    public boolean[] skipRenderPass = new boolean[2];
    public boolean needsUpdate;
    public boolean isRemoved;
    public AxisAlignedBB rendererBoundingBox;
    public List<TileEntity> tileEntities;
    private MobileChunk chunk;
    private int glRenderList = 0;
    private boolean isInitialized = false;
    private List<TileEntity> tileEntityRenderers = new ArrayList<TileEntity>();
    private int bytesDrawn;

    public MobileChunkRenderer(MobileChunk mobilechunk) {
        this.chunk = mobilechunk;
        this.needsUpdate = true;
        this.tileEntities = new ArrayList<TileEntity>();
    }

    private void tryEndDrawing() {
        try {
            Tessellator.field_78398_a.func_78381_a();
            MovingWorld.logger.trace("Drawing stopped");
        }
        catch (IllegalStateException ise) {
            MovingWorld.logger.trace("Not drawing");
        }
    }

    public void render(float partialticks) {
        if (this.isRemoved) {
            if (this.glRenderList != 0) {
                GLAllocation.func_74523_b((int)this.glRenderList);
                this.glRenderList = 0;
            }
            return;
        }
        if (this.needsUpdate) {
            try {
                this.updateRender();
            }
            catch (Exception e) {
                MovingWorld.logger.error("A mobile chunk render error has occured", (Throwable)e);
                this.tryEndDrawing();
            }
        }
        if (this.glRenderList != 0) {
            for (int pass = 0; pass < 2; ++pass) {
                GL11.glCallList((int)(this.glRenderList + pass));
                RenderHelper.func_74519_b();
                Iterator<TileEntity> it = this.tileEntityRenderers.iterator();
                while (it.hasNext()) {
                    TileEntity tile = it.next();
                    try {
                        if (!tile.shouldRenderInPass(pass)) continue;
                        this.renderTileEntity(tile, partialticks);
                    }
                    catch (Exception e) {
                        it.remove();
                        MovingWorld.logger.error("A tile entity render error has occured", (Throwable)e);
                        this.tryEndDrawing();
                    }
                }
            }
        }
    }

    public void renderTileEntity(TileEntity tileentity, float partialticks) {
        int i = this.chunk.func_72802_i(tileentity.field_145851_c, tileentity.field_145848_d, tileentity.field_145849_e, 0);
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)j / 1.0f), (float)((float)k / 1.0f));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        World tesrDispatchWorld = TileEntityRendererDispatcher.field_147556_a.field_147550_f;
        TileEntity tileClone = tileentity;
        TileEntityRendererDispatcher.field_147556_a.func_147549_a(tileentity, (double)tileentity.field_145851_c, (double)tileentity.field_145848_d, (double)tileentity.field_145849_e, partialticks);
    }

    private void updateRender() {
        if (this.glRenderList == 0) {
            this.glRenderList = GLAllocation.func_74526_a((int)2);
        }
        for (int i = 0; i < 2; ++i) {
            this.skipRenderPass[i] = true;
        }
        Chunk.field_76640_a = false;
        HashSet<TileEntity> hashset0 = new HashSet<TileEntity>();
        hashset0.addAll(this.tileEntityRenderers);
        this.tileEntityRenderers.clear();
        RenderBlocks renderblocks = new RenderBlocks((IBlockAccess)this.chunk);
        this.bytesDrawn = 0;
        for (int pass = 0; pass < 2; ++pass) {
            boolean flag = false;
            boolean flag1 = false;
            boolean glliststarted = false;
            for (int y = this.chunk.minY(); y < this.chunk.maxY(); ++y) {
                for (int z = this.chunk.minZ(); z < this.chunk.maxZ(); ++z) {
                    for (int x = this.chunk.minX(); x < this.chunk.maxX(); ++x) {
                        int blockpass;
                        TileEntity tileentity;
                        Block block = this.chunk.func_147439_a(x, y, z);
                        if (block == null || block.func_149688_o() == Material.field_151579_a) continue;
                        if (!glliststarted) {
                            glliststarted = true;
                            GL11.glNewList((int)(this.glRenderList + pass), (int)4864);
                            GL11.glPushMatrix();
                            float f = 1.000001f;
                            GL11.glTranslatef((float)-8.0f, (float)-8.0f, (float)-8.0f);
                            GL11.glScalef((float)f, (float)f, (float)f);
                            GL11.glTranslatef((float)8.0f, (float)8.0f, (float)8.0f);
                            Tessellator.field_78398_a.func_78382_b();
                        }
                        if (pass == 0 && block.hasTileEntity(this.chunk.func_72805_g(x, y, z)) && TileEntityRendererDispatcher.field_147556_a.func_147545_a(tileentity = this.chunk.func_147438_o(x, y, z))) {
                            this.tileEntityRenderers.add(tileentity);
                        }
                        if ((blockpass = block.func_149701_w()) > pass) {
                            flag = true;
                        }
                        if (!block.canRenderInPass(pass)) continue;
                        flag1 |= renderblocks.func_147805_b(block, x, y, z);
                    }
                }
            }
            if (glliststarted) {
                this.bytesDrawn += Tessellator.field_78398_a.func_78381_a();
                GL11.glPopMatrix();
                GL11.glEndList();
                Tessellator.field_78398_a.func_78373_b(0.0, 0.0, 0.0);
            } else {
                flag1 = false;
            }
            if (flag1) {
                this.skipRenderPass[pass] = false;
            }
            if (!flag) break;
        }
        HashSet<TileEntity> hashset1 = new HashSet<TileEntity>();
        hashset1.addAll(this.tileEntityRenderers);
        hashset1.removeAll(hashset0);
        this.tileEntities.addAll(hashset1);
        hashset0.removeAll(this.tileEntityRenderers);
        this.tileEntities.removeAll(hashset0);
        this.isInitialized = true;
        this.needsUpdate = false;
    }

    public void markDirty() {
        this.needsUpdate = true;
    }

    public void markRemoved() {
        this.isRemoved = true;
        try {
            if (this.glRenderList != 0) {
                MovingWorld.logger.debug("Deleting mobile chunk display list " + this.glRenderList);
                GLAllocation.func_74523_b((int)this.glRenderList);
                this.glRenderList = 0;
            }
        }
        catch (Exception e) {
            MovingWorld.logger.error("Failed to destroy mobile chunk display list", (Throwable)e);
        }
    }
}

