/*
 * Decompiled with CFR 0.152.
 */
package darkevilmac.movingworld.common.chunk.assembly;

import cpw.mods.fml.common.eventhandler.Event;
import darkevilmac.movingworld.MovingWorld;
import darkevilmac.movingworld.common.chunk.LocatedBlock;
import darkevilmac.movingworld.common.chunk.assembly.AssembleResult;
import darkevilmac.movingworld.common.chunk.assembly.MovingWorldAssemblyInteractor;
import darkevilmac.movingworld.common.chunk.mobilechunk.MobileChunk;
import darkevilmac.movingworld.common.entity.EntityMovingWorld;
import darkevilmac.movingworld.common.event.DisassembleBlockEvent;
import darkevilmac.movingworld.common.tile.IMovingWorldTileEntity;
import darkevilmac.movingworld.common.tile.TileMovingWorldMarkingBlock;
import darkevilmac.movingworld.common.util.FloodFiller;
import darkevilmac.movingworld.common.util.LocatedBlockList;
import darkevilmac.movingworld.common.util.MathHelperMod;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class ChunkDisassembler {
    public boolean overwrite;
    private EntityMovingWorld movingWorld;
    private AssembleResult result;
    private LocatedBlockList removedFluidBlocks;
    private TileMovingWorldMarkingBlock tileMarker;

    public ChunkDisassembler(EntityMovingWorld EntityMovingWorld2) {
        this.movingWorld = EntityMovingWorld2;
        this.overwrite = false;
    }

    public boolean canDisassemble(MovingWorldAssemblyInteractor assemblyInteractor) {
        if (this.overwrite) {
            return true;
        }
        World world = this.movingWorld.field_70170_p;
        MobileChunk chunk = this.movingWorld.getMovingWorldChunk();
        float yaw = (float)Math.round(this.movingWorld.field_70177_z / 90.0f) * 90.0f;
        yaw = (float)Math.toRadians(yaw);
        float ox = -chunk.getCenterX();
        float oy = -chunk.minY();
        float oz = -chunk.getCenterZ();
        Vec3 vec = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        for (int i = chunk.minX(); i < chunk.maxX(); ++i) {
            for (int j = chunk.minY(); j < chunk.maxY(); ++j) {
                for (int k = chunk.minZ(); k < chunk.maxZ(); ++k) {
                    if (chunk.func_147437_c(i, j, k)) continue;
                    vec.field_72450_a = (float)i + ox;
                    vec.field_72448_b = (float)j + oy;
                    vec.field_72449_c = (float)k + oz;
                    vec.func_72442_b(yaw);
                    int ix = MathHelperMod.round_double(vec.field_72450_a + this.movingWorld.field_70165_t);
                    int iy = MathHelperMod.round_double(vec.field_72448_b + this.movingWorld.field_70163_u);
                    int iz = MathHelperMod.round_double(vec.field_72449_c + this.movingWorld.field_70161_v);
                    Block block = world.func_147439_a(ix, iy, iz);
                    if ((block == null || block.isAir((IBlockAccess)world, ix, iy, iz) || block.func_149688_o().func_76224_d() || assemblyInteractor.canOverwriteBlock(block)) && !(vec.field_72448_b > (double)world.func_72940_L())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public AssembleResult doDisassemble(MovingWorldAssemblyInteractor assemblyInteractor) {
        int iz;
        int iy;
        int ix;
        this.tileMarker = null;
        if (this.movingWorld.getMobileChunk().marker != null && this.movingWorld.getMobileChunk().marker.tileEntity != null && this.movingWorld.getMobileChunk().marker.tileEntity instanceof TileMovingWorldMarkingBlock) {
            this.tileMarker = (TileMovingWorldMarkingBlock)this.movingWorld.getMobileChunk().marker.tileEntity;
        }
        this.removedFluidBlocks = new LocatedBlockList();
        World world = this.movingWorld.field_70170_p;
        MobileChunk chunk = this.movingWorld.getMovingWorldChunk();
        LocatedBlockList fillableBlocks = new FloodFiller().floodFillMobileChunk(chunk);
        this.result = new AssembleResult();
        this.result.xOffset = Integer.MAX_VALUE;
        this.result.yOffset = Integer.MAX_VALUE;
        this.result.zOffset = Integer.MAX_VALUE;
        int currentRot = Math.round(this.movingWorld.field_70177_z / 90.0f) & 3;
        int deltarot = -currentRot & 3;
        this.movingWorld.field_70177_z = (float)currentRot * 90.0f;
        this.movingWorld.field_70125_A = 0.0f;
        float yaw = (float)currentRot * 1.5707964f;
        boolean flag = world.func_82736_K().func_82766_b("doTileDrops");
        world.func_82736_K().func_82764_b("doTileDrops", "false");
        float ox = -chunk.getCenterX();
        float oy = -chunk.minY();
        float oz = -chunk.getCenterZ();
        LocatedBlockList lbList = new LocatedBlockList();
        Vec3 vec = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        for (int i = chunk.minX(); i < chunk.maxX(); ++i) {
            for (int j = chunk.minY(); j < chunk.maxY(); ++j) {
                for (int k = chunk.minZ(); k < chunk.maxZ(); ++k) {
                    Block block = chunk.func_147439_a(i, j, k);
                    int meta = chunk.func_72805_g(i, j, k);
                    if (block == Blocks.field_150350_a ? meta == 1 : block.isAir((IBlockAccess)world, i, j, k)) continue;
                    TileEntity tileentity = chunk.func_147438_o(i, j, k);
                    meta = MovingWorld.instance.metaRotations.getRotatedMeta(block, meta, deltarot);
                    vec.field_72450_a = (float)i + ox;
                    vec.field_72448_b = (float)j + oy;
                    vec.field_72449_c = (float)k + oz;
                    vec.func_72442_b(yaw);
                    ix = MathHelperMod.round_double(vec.field_72450_a + this.movingWorld.field_70165_t);
                    iy = MathHelperMod.round_double(vec.field_72448_b + this.movingWorld.field_70163_u);
                    iz = MathHelperMod.round_double(vec.field_72449_c + this.movingWorld.field_70161_v);
                    lbList.add(new LocatedBlock(block, meta, tileentity, new ChunkPosition(ix, iy, iz), new ChunkPosition(i, j, k)));
                }
            }
        }
        LocatedBlockList postList = new LocatedBlockList();
        postList = this.processLocatedBlockList(world, lbList, postList, assemblyInteractor, fillableBlocks, currentRot);
        world.func_82736_K().func_82764_b("doTileDrops", String.valueOf(flag));
        for (LocatedBlock ilb : postList) {
            ix = ilb.coords.field_151329_a;
            iy = ilb.coords.field_151327_b;
            iz = ilb.coords.field_151328_c;
            MovingWorld.logger.debug("Post-rejoining block: " + ilb.toString());
            world.func_147465_d(ix, iy, iz, ilb.block, ilb.blockMeta, 0);
            assemblyInteractor.blockDisassembled(ilb);
            this.result.assembleBlock(ilb);
        }
        if (this.tileMarker != null) {
            this.tileMarker.removedFluidBlocks = this.removedFluidBlocks;
        }
        this.movingWorld.func_70106_y();
        if (this.result.movingWorldMarkingBlock == null || !assemblyInteractor.isTileMovingWorldMarker(this.result.movingWorldMarkingBlock.tileEntity)) {
            this.result.resultCode = 3;
        } else {
            this.result.checkConsistent(world);
        }
        assemblyInteractor.chunkDissasembled(this.result);
        this.result.assemblyInteractor = assemblyInteractor;
        return this.result;
    }

    LocatedBlockList processLocatedBlockList(World world, LocatedBlockList locatedBlocks, LocatedBlockList postList, MovingWorldAssemblyInteractor assemblyInteractor, LocatedBlockList fillList, int currentRot) {
        LocatedBlockList retPostList = new LocatedBlockList();
        retPostList.addAll(postList);
        for (LocatedBlock locatedBlock : locatedBlocks) {
            int i = locatedBlock.coordsNoOffset.field_151329_a;
            int j = locatedBlock.coordsNoOffset.field_151327_b;
            int k = locatedBlock.coordsNoOffset.field_151328_c;
            int ix = locatedBlock.coords.field_151329_a;
            int iy = locatedBlock.coords.field_151327_b;
            int iz = locatedBlock.coords.field_151328_c;
            Block block = locatedBlock.block;
            int meta = locatedBlock.blockMeta;
            TileEntity tileentity = locatedBlock.tileEntity;
            Block owBlock = world.func_147439_a(ix, iy, iz);
            int owMeta = world.func_72805_g(ix, iy, iz);
            if (owBlock != null) {
                assemblyInteractor.blockOverwritten(owBlock);
            }
            if (!fillList.containsLBOfPos(locatedBlock.coordsNoOffset)) {
                if (world.func_147439_a(ix, iy, iz).func_149688_o().func_76224_d() && !this.removedFluidBlocks.containsLBOfPos(locatedBlock.coords)) {
                    this.removedFluidBlocks.add(new LocatedBlock(owBlock, owMeta, new ChunkPosition(ix, iy, iz)));
                }
                if (!world.func_147465_d(ix, iy, iz, block, meta, 2) || block != world.func_147439_a(ix, iy, iz)) {
                    retPostList.add(new LocatedBlock(block, meta, tileentity, new ChunkPosition(ix, iy, iz), null));
                    continue;
                }
                if (block != world.func_147439_a(ix, iy, iz)) {
                    world.func_147465_d(ix, iy, iz, block, meta, 2);
                }
            }
            if (tileentity != null) {
                tileentity.field_145851_c = ix;
                tileentity.field_145848_d = iy;
                tileentity.field_145849_e = iz;
                if (tileentity instanceof IMovingWorldTileEntity) {
                    ((IMovingWorldTileEntity)tileentity).setParentMovingWorld(null, i, j, k);
                }
                NBTTagCompound tileTag = new NBTTagCompound();
                tileentity.func_145841_b(tileTag);
                world.func_147455_a(ix, iy, iz, tileentity);
                world.func_147438_o(ix, iy, iz).func_145839_a(tileTag);
                tileentity.func_145829_t();
                tileentity = world.func_147438_o(ix, iy, iz);
                if (this.tileMarker != null && new ChunkPosition(this.tileMarker.field_145851_c, this.tileMarker.field_145848_d, this.tileMarker.field_145849_e).equals((Object)new ChunkPosition(tileentity.field_145851_c, tileentity.field_145848_d, tileentity.field_145849_e))) {
                    this.tileMarker = (TileMovingWorldMarkingBlock)tileentity;
                }
            }
            block = world.func_147439_a(ix, iy, iz);
            meta = world.func_72805_g(ix, iy, iz);
            tileentity = world.func_147438_o(ix, iy, iz);
            if (!MovingWorld.instance.metaRotations.hasBlock(block)) {
                assemblyInteractor.blockRotated(block, world, ix, iy, iz, currentRot);
                this.rotateBlock(block, world, ix, iy, iz, currentRot);
                block = world.func_147439_a(ix, iy, iz);
                meta = world.func_72805_g(ix, iy, iz);
                tileentity = world.func_147438_o(ix, iy, iz);
            }
            LocatedBlock lb = new LocatedBlock(block, meta, tileentity, new ChunkPosition(ix, iy, iz), new ChunkPosition(i, j, k));
            assemblyInteractor.blockDisassembled(lb);
            DisassembleBlockEvent event = new DisassembleBlockEvent(lb);
            MinecraftForge.EVENT_BUS.post((Event)event);
            this.result.assembleBlock(lb);
        }
        return retPostList;
    }

    private void rotateBlock(Block block, World world, int x, int y, int z, int deltarot) {
        if ((deltarot &= 3) != 0) {
            if (deltarot == 3) {
                block.rotateBlock(world, x, y, z, ForgeDirection.UP);
            } else {
                for (int r = 0; r < deltarot; ++r) {
                    block.rotateBlock(world, x, y, z, ForgeDirection.DOWN);
                }
            }
        }
    }
}

