/*
 * Decompiled with CFR 0.152.
 */
package darkevilmac.movingworld.common.entity;

import darkevilmac.movingworld.MovingWorld;
import darkevilmac.movingworld.common.chunk.mobilechunk.MobileChunk;
import darkevilmac.movingworld.common.entity.EntityMovingWorld;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;

public abstract class MovingWorldHandlerCommon {
    public MovingWorldHandlerCommon(EntityMovingWorld entityMovingWorld) {
        this.setMovingWorld(entityMovingWorld);
    }

    public abstract EntityMovingWorld getMovingWorld();

    public abstract void setMovingWorld(EntityMovingWorld var1);

    public boolean interact(EntityPlayer player) {
        return false;
    }

    public void onChunkUpdate() {
        MobileChunk chunk = this.getMovingWorld().getMovingWorldChunk();
        this.getMovingWorld().getCapabilities().clearBlockCount();
        for (int i = chunk.minX(); i < chunk.maxX(); ++i) {
            for (int j = chunk.minY(); j < chunk.maxY(); ++j) {
                for (int k = chunk.minZ(); k < chunk.maxZ(); ++k) {
                    Block block = chunk.func_147439_a(i, j, k);
                    if (block.func_149688_o() == Material.field_151579_a) continue;
                    this.getMovingWorld().getCapabilities().onChunkBlockAdded(block, chunk.func_72805_g(i, j, k), i, j, k);
                }
            }
        }
        this.getMovingWorld().func_70105_a(Math.max(chunk.maxX() - chunk.minX(), chunk.maxZ() - chunk.minZ()), chunk.maxY() - chunk.minY());
        World.MAX_ENTITY_RADIUS = Math.max(World.MAX_ENTITY_RADIUS, (double)(Math.max(this.getMovingWorld().field_70130_N, this.getMovingWorld().field_70131_O) + 2.0f));
        try {
            this.getMovingWorld().fillAirBlocks(new HashSet<ChunkPosition>(), -1, -1, -1);
        }
        catch (StackOverflowError e) {
            MovingWorld.logger.error("Failure during moving world post-initialization", (Throwable)e);
        }
        this.getMovingWorld().setLayeredBlockVolumeCount(new int[chunk.maxY() - chunk.minY()]);
        for (int y = 0; y < this.getMovingWorld().getLayeredBlockVolumeCount().length; ++y) {
            for (int i = chunk.minX(); i < chunk.maxX(); ++i) {
                for (int j = chunk.minZ(); j < chunk.maxZ(); ++j) {
                    if (!chunk.isBlockTakingWaterVolume(i, y + chunk.minY(), j)) continue;
                    int[] layeredBlockVolCount = this.getMovingWorld().getLayeredBlockVolumeCount();
                    int n = y;
                    layeredBlockVolCount[n] = layeredBlockVolCount[n] + 1;
                    this.getMovingWorld().setLayeredBlockVolumeCount(layeredBlockVolCount);
                }
            }
        }
        this.getMovingWorld().isFlying = this.getMovingWorld().getCapabilities().canFly();
        this.getMovingWorld().getCapabilities().postBlockAdding();
    }
}

