/*
 * Decompiled with CFR 0.152.
 */
package darkevilmac.movingworld.common.network;

import cpw.mods.fml.relauncher.Side;
import darkevilmac.movingworld.common.chunk.ChunkIO;
import darkevilmac.movingworld.common.entity.EntityMovingWorld;
import darkevilmac.movingworld.common.network.EntityMovingWorldMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.ChunkPosition;

public class ChunkBlockUpdateMessage
extends EntityMovingWorldMessage {
    private Collection<ChunkPosition> sendQueue;

    public ChunkBlockUpdateMessage() {
    }

    public ChunkBlockUpdateMessage(EntityMovingWorld movingWorld, Collection<ChunkPosition> blocks) {
        super(movingWorld);
        this.sendQueue = blocks;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buf, Side side) {
        super.encodeInto(ctx, buf, side);
        try {
            ChunkIO.writeCompressed(buf, this.movingWorld.getMovingWorldChunk(), this.sendQueue);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buf, EntityPlayer player, Side side) {
        super.decodeInto(ctx, buf, player, side);
        if (this.movingWorld != null) {
            try {
                ChunkIO.readCompressed(buf, this.movingWorld.getMovingWorldChunk());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

