/*
 * Decompiled with CFR 0.152.
 */
package darkevilmac.movingworld.common.network;

import cpw.mods.fml.relauncher.Side;
import darkevilmac.movingworld.common.entity.EntityMovingWorld;
import darkevilmac.movingworld.common.network.EntityMovingWorldMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public class MovingWorldClientActionMessage
extends EntityMovingWorldMessage {
    public Action actionID;

    public MovingWorldClientActionMessage() {
        this.actionID = Action.NONE;
    }

    public MovingWorldClientActionMessage(EntityMovingWorld movingWorld, Action id) {
        super(movingWorld);
        this.actionID = id;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buf, Side side) {
        super.encodeInto(ctx, buf, side);
        buf.writeByte(this.actionID.toInt(this.actionID));
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buf, EntityPlayer player, Side side) {
        super.decodeInto(ctx, buf, player, side);
        this.actionID = Action.NONE;
        this.actionID = this.actionID.fromInt(buf.readByte());
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        if (this.movingWorld != null && this.movingWorld.field_70153_n == player) {
            switch (this.actionID) {
                case DISASSEMBLE: {
                    this.movingWorld.alignToGrid();
                    this.movingWorld.updateRiderPosition((Entity)player, this.movingWorld.riderDestinationX, this.movingWorld.riderDestinationY, this.movingWorld.riderDestinationZ, 1);
                    this.movingWorld.disassemble(false);
                    break;
                }
                case DISASSEMBLEOVERWRITE: {
                    this.movingWorld.alignToGrid();
                    this.movingWorld.updateRiderPosition((Entity)player, this.movingWorld.riderDestinationX, this.movingWorld.riderDestinationY, this.movingWorld.riderDestinationZ, 1);
                    this.movingWorld.disassemble(true);
                    break;
                }
                case ALIGN: {
                    this.movingWorld.alignToGrid();
                    break;
                }
            }
        }
    }

    public static enum Action {
        NONE,
        ALIGN,
        DISASSEMBLE,
        DISASSEMBLEOVERWRITE;


        public int toInt(Action action) {
            switch (action) {
                case ALIGN: {
                    return 1;
                }
                case DISASSEMBLE: {
                    return 2;
                }
                case DISASSEMBLEOVERWRITE: {
                    return 3;
                }
            }
            return 0;
        }

        public Action fromInt(int actionInt) {
            switch (actionInt) {
                case 1: {
                    return ALIGN;
                }
                case 2: {
                    return DISASSEMBLE;
                }
                case 3: {
                    return DISASSEMBLEOVERWRITE;
                }
            }
            return NONE;
        }
    }
}

